// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Current state of migration. </summary>
    public readonly partial struct MigrationState : IEquatable<MigrationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MigrationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MigrationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string InProgressValue = "InProgress";
        private const string FailedValue = "Failed";
        private const string WarningValue = "Warning";
        private const string CompletedValue = "Completed";
        private const string SkippedValue = "Skipped";
        private const string StoppedValue = "Stopped";

        /// <summary> None. </summary>
        public static MigrationState None { get; } = new MigrationState(NoneValue);
        /// <summary> InProgress. </summary>
        public static MigrationState InProgress { get; } = new MigrationState(InProgressValue);
        /// <summary> Failed. </summary>
        public static MigrationState Failed { get; } = new MigrationState(FailedValue);
        /// <summary> Warning. </summary>
        public static MigrationState Warning { get; } = new MigrationState(WarningValue);
        /// <summary> Completed. </summary>
        public static MigrationState Completed { get; } = new MigrationState(CompletedValue);
        /// <summary> Skipped. </summary>
        public static MigrationState Skipped { get; } = new MigrationState(SkippedValue);
        /// <summary> Stopped. </summary>
        public static MigrationState Stopped { get; } = new MigrationState(StoppedValue);
        /// <summary> Determines if two <see cref="MigrationState"/> values are the same. </summary>
        public static bool operator ==(MigrationState left, MigrationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MigrationState"/> values are not the same. </summary>
        public static bool operator !=(MigrationState left, MigrationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MigrationState"/>. </summary>
        public static implicit operator MigrationState(string value) => new MigrationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MigrationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MigrationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
