// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Information about migration eligibility of a server object. </summary>
    public partial class MigrationEligibilityInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigrationEligibilityInfo"/>. </summary>
        internal MigrationEligibilityInfo()
        {
            ValidationMessages = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="MigrationEligibilityInfo"/>. </summary>
        /// <param name="isEligibleForMigration"> Whether object is eligible for migration or not. </param>
        /// <param name="validationMessages"> Information about eligibility failure for the server object. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigrationEligibilityInfo(bool? isEligibleForMigration, IReadOnlyList<string> validationMessages, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsEligibleForMigration = isEligibleForMigration;
            ValidationMessages = validationMessages;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Whether object is eligible for migration or not. </summary>
        public bool? IsEligibleForMigration { get; }
        /// <summary> Information about eligibility failure for the server object. </summary>
        public IReadOnlyList<string> ValidationMessages { get; }
    }
}
