// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> The MigrateSqlServerSqlMITaskOutputDatabaseLevel. </summary>
    public partial class MigrateSqlServerSqlMITaskOutputDatabaseLevel : MigrateSqlServerSqlMITaskOutput
    {
        /// <summary> Initializes a new instance of <see cref="MigrateSqlServerSqlMITaskOutputDatabaseLevel"/>. </summary>
        internal MigrateSqlServerSqlMITaskOutputDatabaseLevel()
        {
            ExceptionsAndWarnings = new ChangeTrackingList<ReportableException>();
            ResultType = "DatabaseLevelOutput";
        }

        /// <summary> Initializes a new instance of <see cref="MigrateSqlServerSqlMITaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="sizeMB"> Size of the database in megabytes. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="stage"> Current stage of migration. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        internal MigrateSqlServerSqlMITaskOutputDatabaseLevel(string id, string resultType, IDictionary<string, BinaryData> serializedAdditionalRawData, string databaseName, double? sizeMB, MigrationState? state, DatabaseMigrationStage? stage, DateTimeOffset? startedOn, DateTimeOffset? endedOn, string message, IReadOnlyList<ReportableException> exceptionsAndWarnings) : base(id, resultType, serializedAdditionalRawData)
        {
            DatabaseName = databaseName;
            SizeMB = sizeMB;
            State = state;
            Stage = stage;
            StartedOn = startedOn;
            EndedOn = endedOn;
            Message = message;
            ExceptionsAndWarnings = exceptionsAndWarnings;
            ResultType = resultType ?? "DatabaseLevelOutput";
        }

        /// <summary> Name of the database. </summary>
        public string DatabaseName { get; }
        /// <summary> Size of the database in megabytes. </summary>
        public double? SizeMB { get; }
        /// <summary> Current state of migration. </summary>
        public MigrationState? State { get; }
        /// <summary> Current stage of migration. </summary>
        public DatabaseMigrationStage? Stage { get; }
        /// <summary> Migration start time. </summary>
        public DateTimeOffset? StartedOn { get; }
        /// <summary> Migration end time. </summary>
        public DateTimeOffset? EndedOn { get; }
        /// <summary> Migration progress message. </summary>
        public string Message { get; }
        /// <summary> Migration exceptions and warnings. </summary>
        public IReadOnlyList<ReportableException> ExceptionsAndWarnings { get; }
    }
}
