// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Input for task that migrates SQL Server databases to Azure SQL Database Managed Instance. </summary>
    public partial class MigrateSqlServerSqlMITaskInput : SqlMigrationTaskInput
    {
        /// <summary> Initializes a new instance of <see cref="MigrateSqlServerSqlMITaskInput"/>. </summary>
        /// <param name="sourceConnectionInfo"> Information for connecting to source. </param>
        /// <param name="targetConnectionInfo"> Information for connecting to target. </param>
        /// <param name="selectedDatabases"> Databases to migrate. </param>
        /// <param name="backupBlobShare"> SAS URI of Azure Storage Account Container to be used for storing backup files. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourceConnectionInfo"/>, <paramref name="targetConnectionInfo"/>, <paramref name="selectedDatabases"/> or <paramref name="backupBlobShare"/> is null. </exception>
        public MigrateSqlServerSqlMITaskInput(SqlConnectionInfo sourceConnectionInfo, SqlConnectionInfo targetConnectionInfo, IEnumerable<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases, BlobShare backupBlobShare) : base(sourceConnectionInfo, targetConnectionInfo)
        {
            Argument.AssertNotNull(sourceConnectionInfo, nameof(sourceConnectionInfo));
            Argument.AssertNotNull(targetConnectionInfo, nameof(targetConnectionInfo));
            Argument.AssertNotNull(selectedDatabases, nameof(selectedDatabases));
            Argument.AssertNotNull(backupBlobShare, nameof(backupBlobShare));

            SelectedDatabases = selectedDatabases.ToList();
            SelectedLogins = new ChangeTrackingList<string>();
            SelectedAgentJobs = new ChangeTrackingList<string>();
            BackupBlobShare = backupBlobShare;
        }

        /// <summary> Initializes a new instance of <see cref="MigrateSqlServerSqlMITaskInput"/>. </summary>
        /// <param name="sourceConnectionInfo"> Information for connecting to source. </param>
        /// <param name="targetConnectionInfo"> Information for connecting to target. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="selectedDatabases"> Databases to migrate. </param>
        /// <param name="startedOn"> Date and time relative to UTC when the migration was started on. </param>
        /// <param name="selectedLogins"> Logins to migrate. </param>
        /// <param name="selectedAgentJobs"> Agent Jobs to migrate. </param>
        /// <param name="backupFileShare"> Backup file share information for all selected databases. </param>
        /// <param name="backupBlobShare"> SAS URI of Azure Storage Account Container to be used for storing backup files. </param>
        /// <param name="backupMode"> Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases. </param>
        /// <param name="aadDomainName"> Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if Windows logins are selected. </param>
        /// <param name="encryptedKeyForSecureFields"> encrypted key for secure fields. </param>
        internal MigrateSqlServerSqlMITaskInput(SqlConnectionInfo sourceConnectionInfo, SqlConnectionInfo targetConnectionInfo, IDictionary<string, BinaryData> serializedAdditionalRawData, IList<MigrateSqlServerSqlMIDatabaseInput> selectedDatabases, string startedOn, IList<string> selectedLogins, IList<string> selectedAgentJobs, FileShare backupFileShare, BlobShare backupBlobShare, BackupMode? backupMode, string aadDomainName, string encryptedKeyForSecureFields) : base(sourceConnectionInfo, targetConnectionInfo, serializedAdditionalRawData)
        {
            SelectedDatabases = selectedDatabases;
            StartedOn = startedOn;
            SelectedLogins = selectedLogins;
            SelectedAgentJobs = selectedAgentJobs;
            BackupFileShare = backupFileShare;
            BackupBlobShare = backupBlobShare;
            BackupMode = backupMode;
            AadDomainName = aadDomainName;
            EncryptedKeyForSecureFields = encryptedKeyForSecureFields;
        }

        /// <summary> Initializes a new instance of <see cref="MigrateSqlServerSqlMITaskInput"/> for deserialization. </summary>
        internal MigrateSqlServerSqlMITaskInput()
        {
        }

        /// <summary> Databases to migrate. </summary>
        public IList<MigrateSqlServerSqlMIDatabaseInput> SelectedDatabases { get; }
        /// <summary> Date and time relative to UTC when the migration was started on. </summary>
        public string StartedOn { get; set; }
        /// <summary> Logins to migrate. </summary>
        public IList<string> SelectedLogins { get; }
        /// <summary> Agent Jobs to migrate. </summary>
        public IList<string> SelectedAgentJobs { get; }
        /// <summary> Backup file share information for all selected databases. </summary>
        public FileShare BackupFileShare { get; set; }
        /// <summary> SAS URI of Azure Storage Account Container to be used for storing backup files. </summary>
        internal BlobShare BackupBlobShare { get; set; }
        /// <summary> SAS URI of Azure Storage Account Container. </summary>
        public Uri BackupBlobShareSasUri
        {
            get => BackupBlobShare is null ? default : BackupBlobShare.SasUri;
            set
            {
                if (BackupBlobShare is null)
                    BackupBlobShare = new BlobShare();
                BackupBlobShare.SasUri = value;
            }
        }

        /// <summary> Backup Mode to specify whether to use existing backup or create new backup. If using existing backups, backup file paths are required to be provided in selectedDatabases. </summary>
        public BackupMode? BackupMode { get; set; }
        /// <summary> Azure Active Directory domain name in the format of 'contoso.com' for federated Azure AD or 'contoso.onmicrosoft.com' for managed domain, required if and only if Windows logins are selected. </summary>
        public string AadDomainName { get; set; }
        /// <summary> encrypted key for secure fields. </summary>
        public string EncryptedKeyForSecureFields { get; set; }
    }
}
