// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Properties for the task that migrates on-prem SQL Server databases to Azure SQL Database. </summary>
    public partial class MigrateSqlServerSqlDBTaskProperties : ProjectTaskProperties
    {
        /// <summary> Initializes a new instance of <see cref="MigrateSqlServerSqlDBTaskProperties"/>. </summary>
        public MigrateSqlServerSqlDBTaskProperties()
        {
            Output = new ChangeTrackingList<MigrateSqlServerSqlDBTaskOutput>();
            TaskType = TaskType.MigrateSqlServerSqlDB;
        }

        /// <summary> Initializes a new instance of <see cref="MigrateSqlServerSqlDBTaskProperties"/>. </summary>
        /// <param name="taskType"> Task type. </param>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MongoDBCancelCommand"/>, <see cref="MongoDBFinishCommand"/>, <see cref="MigrateMISyncCompleteCommandProperties"/>, <see cref="MigrateSyncCompleteCommandProperties"/> and <see cref="MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="MigrateSqlServerSqlDBTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MigrateSqlServerSqlDBTaskOutputDatabaseLevel"/>, <see cref="MigrateSqlServerSqlDBTaskOutputError"/>, <see cref="MigrateSqlServerSqlDBTaskOutputDatabaseLevelValidationResult"/>, <see cref="MigrateSqlServerSqlDBTaskOutputMigrationLevel"/>, <see cref="MigrateSqlServerSqlDBTaskOutputValidationResult"/> and <see cref="MigrateSqlServerSqlDBTaskOutputTableLevel"/>.
        /// </param>
        /// <param name="taskId"> task id. </param>
        /// <param name="isCloneable"> whether the task can be cloned or not. </param>
        /// <param name="createdOn"> DateTime in UTC when the task was created. </param>
        internal MigrateSqlServerSqlDBTaskProperties(TaskType taskType, IReadOnlyList<ODataError> errors, TaskState? state, IReadOnlyList<CommandProperties> commands, IDictionary<string, string> clientData, IDictionary<string, BinaryData> serializedAdditionalRawData, MigrateSqlServerSqlDBTaskInput input, IReadOnlyList<MigrateSqlServerSqlDBTaskOutput> output, string taskId, bool? isCloneable, string createdOn) : base(taskType, errors, state, commands, clientData, serializedAdditionalRawData)
        {
            Input = input;
            Output = output;
            TaskId = taskId;
            IsCloneable = isCloneable;
            CreatedOn = createdOn;
            TaskType = taskType;
        }

        /// <summary> Task input. </summary>
        public MigrateSqlServerSqlDBTaskInput Input { get; set; }
        /// <summary>
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="MigrateSqlServerSqlDBTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MigrateSqlServerSqlDBTaskOutputDatabaseLevel"/>, <see cref="MigrateSqlServerSqlDBTaskOutputError"/>, <see cref="MigrateSqlServerSqlDBTaskOutputDatabaseLevelValidationResult"/>, <see cref="MigrateSqlServerSqlDBTaskOutputMigrationLevel"/>, <see cref="MigrateSqlServerSqlDBTaskOutputValidationResult"/> and <see cref="MigrateSqlServerSqlDBTaskOutputTableLevel"/>.
        /// </summary>
        public IReadOnlyList<MigrateSqlServerSqlDBTaskOutput> Output { get; }
        /// <summary> task id. </summary>
        public string TaskId { get; set; }
        /// <summary> whether the task can be cloned or not. </summary>
        public bool? IsCloneable { get; set; }
        /// <summary> DateTime in UTC when the task was created. </summary>
        public string CreatedOn { get; set; }
    }
}
