// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Properties for task that migrates Schema for SQL Server databases to Azure SQL databases. </summary>
    public partial class MigrateSchemaSqlServerSqlDBTaskProperties : ProjectTaskProperties
    {
        /// <summary> Initializes a new instance of <see cref="MigrateSchemaSqlServerSqlDBTaskProperties"/>. </summary>
        public MigrateSchemaSqlServerSqlDBTaskProperties()
        {
            Output = new ChangeTrackingList<MigrateSchemaSqlServerSqlDBTaskOutput>();
            TaskType = TaskType.MigrateSchemaSqlServerSqlDB;
        }

        /// <summary> Initializes a new instance of <see cref="MigrateSchemaSqlServerSqlDBTaskProperties"/>. </summary>
        /// <param name="taskType"> Task type. </param>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MongoDBCancelCommand"/>, <see cref="MongoDBFinishCommand"/>, <see cref="MigrateMISyncCompleteCommandProperties"/>, <see cref="MigrateSyncCompleteCommandProperties"/> and <see cref="MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="MigrateSchemaSqlServerSqlDBTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel"/>, <see cref="MigrateSchemaSqlTaskOutputError"/>, <see cref="MigrateSchemaSqlServerSqlDBTaskOutputMigrationLevel"/> and <see cref="MigrateSchemaSqlServerSqlDBTaskOutputError"/>.
        /// </param>
        /// <param name="createdOn"> DateTime in UTC when the task was created. </param>
        /// <param name="taskId"> Task id. </param>
        /// <param name="isCloneable"> whether the task can be cloned or not. </param>
        internal MigrateSchemaSqlServerSqlDBTaskProperties(TaskType taskType, IReadOnlyList<ODataError> errors, TaskState? state, IReadOnlyList<CommandProperties> commands, IDictionary<string, string> clientData, IDictionary<string, BinaryData> serializedAdditionalRawData, MigrateSchemaSqlServerSqlDBTaskInput input, IReadOnlyList<MigrateSchemaSqlServerSqlDBTaskOutput> output, string createdOn, string taskId, bool? isCloneable) : base(taskType, errors, state, commands, clientData, serializedAdditionalRawData)
        {
            Input = input;
            Output = output;
            CreatedOn = createdOn;
            TaskId = taskId;
            IsCloneable = isCloneable;
            TaskType = taskType;
        }

        /// <summary> Task input. </summary>
        public MigrateSchemaSqlServerSqlDBTaskInput Input { get; set; }
        /// <summary>
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="MigrateSchemaSqlServerSqlDBTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel"/>, <see cref="MigrateSchemaSqlTaskOutputError"/>, <see cref="MigrateSchemaSqlServerSqlDBTaskOutputMigrationLevel"/> and <see cref="MigrateSchemaSqlServerSqlDBTaskOutputError"/>.
        /// </summary>
        public IReadOnlyList<MigrateSchemaSqlServerSqlDBTaskOutput> Output { get; }
        /// <summary> DateTime in UTC when the task was created. </summary>
        public string CreatedOn { get; set; }
        /// <summary> Task id. </summary>
        public string TaskId { get; set; }
        /// <summary> whether the task can be cloned or not. </summary>
        public bool? IsCloneable { get; set; }
    }
}
