// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> The MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel. </summary>
    public partial class MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel : MigrateSchemaSqlServerSqlDBTaskOutput
    {
        /// <summary> Initializes a new instance of <see cref="MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel"/>. </summary>
        internal MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel()
        {
            ResultType = "DatabaseLevelOutput";
        }

        /// <summary> Initializes a new instance of <see cref="MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="state"> State of the schema migration for this database. </param>
        /// <param name="stage"> Schema migration stage for this database. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="databaseErrorResultPrefix"> Prefix string to use for querying errors for this database. </param>
        /// <param name="schemaErrorResultPrefix"> Prefix string to use for querying schema errors for this database. </param>
        /// <param name="numberOfSuccessfulOperations"> Number of successful operations for this database. </param>
        /// <param name="numberOfFailedOperations"> Number of failed operations for this database. </param>
        /// <param name="fileId"> Identifier for the file resource containing the schema of this database. </param>
        internal MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel(string id, string resultType, IDictionary<string, BinaryData> serializedAdditionalRawData, string databaseName, MigrationState? state, SchemaMigrationStage? stage, DateTimeOffset? startedOn, DateTimeOffset? endedOn, string databaseErrorResultPrefix, string schemaErrorResultPrefix, long? numberOfSuccessfulOperations, long? numberOfFailedOperations, string fileId) : base(id, resultType, serializedAdditionalRawData)
        {
            DatabaseName = databaseName;
            State = state;
            Stage = stage;
            StartedOn = startedOn;
            EndedOn = endedOn;
            DatabaseErrorResultPrefix = databaseErrorResultPrefix;
            SchemaErrorResultPrefix = schemaErrorResultPrefix;
            NumberOfSuccessfulOperations = numberOfSuccessfulOperations;
            NumberOfFailedOperations = numberOfFailedOperations;
            FileId = fileId;
            ResultType = resultType ?? "DatabaseLevelOutput";
        }

        /// <summary> The name of the database. </summary>
        public string DatabaseName { get; }
        /// <summary> State of the schema migration for this database. </summary>
        public MigrationState? State { get; }
        /// <summary> Schema migration stage for this database. </summary>
        public SchemaMigrationStage? Stage { get; }
        /// <summary> Migration start time. </summary>
        public DateTimeOffset? StartedOn { get; }
        /// <summary> Migration end time. </summary>
        public DateTimeOffset? EndedOn { get; }
        /// <summary> Prefix string to use for querying errors for this database. </summary>
        public string DatabaseErrorResultPrefix { get; }
        /// <summary> Prefix string to use for querying schema errors for this database. </summary>
        public string SchemaErrorResultPrefix { get; }
        /// <summary> Number of successful operations for this database. </summary>
        public long? NumberOfSuccessfulOperations { get; }
        /// <summary> Number of failed operations for this database. </summary>
        public long? NumberOfFailedOperations { get; }
        /// <summary> Identifier for the file resource containing the schema of this database. </summary>
        public string FileId { get; }
    }
}
