// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Database input for migrate schema Sql Server to Azure SQL Server scenario. </summary>
    public partial class MigrateSchemaSqlServerSqlDBDatabaseInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigrateSchemaSqlServerSqlDBDatabaseInput"/>. </summary>
        public MigrateSchemaSqlServerSqlDBDatabaseInput()
        {
        }

        /// <summary> Initializes a new instance of <see cref="MigrateSchemaSqlServerSqlDBDatabaseInput"/>. </summary>
        /// <param name="name"> Name of source database. </param>
        /// <param name="id"> Id of the source database. </param>
        /// <param name="targetDatabaseName"> Name of target database. </param>
        /// <param name="schemaSetting"> Database schema migration settings. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigrateSchemaSqlServerSqlDBDatabaseInput(string name, string id, string targetDatabaseName, SchemaMigrationSetting schemaSetting, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Id = id;
            TargetDatabaseName = targetDatabaseName;
            SchemaSetting = schemaSetting;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of source database. </summary>
        public string Name { get; set; }
        /// <summary> Id of the source database. </summary>
        public string Id { get; set; }
        /// <summary> Name of target database. </summary>
        public string TargetDatabaseName { get; set; }
        /// <summary> Database schema migration settings. </summary>
        public SchemaMigrationSetting SchemaSetting { get; set; }
    }
}
