// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Database specific information for PostgreSQL to Azure Database for PostgreSQL migration task inputs. </summary>
    public partial class MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput"/>. </summary>
        public MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput()
        {
            MigrationSetting = new ChangeTrackingDictionary<string, BinaryData>();
            SourceSetting = new ChangeTrackingDictionary<string, string>();
            TargetSetting = new ChangeTrackingDictionary<string, string>();
            SelectedTables = new ChangeTrackingList<MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseTableInput>();
        }

        /// <summary> Initializes a new instance of <see cref="MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput"/>. </summary>
        /// <param name="name"> Name of the database. </param>
        /// <param name="id"> Result identifier. </param>
        /// <param name="targetDatabaseName"> Name of target database. Note: Target database will be truncated before starting migration. </param>
        /// <param name="migrationSetting"> Migration settings which tune the migration behavior. </param>
        /// <param name="sourceSetting"> Source settings to tune source endpoint migration behavior. </param>
        /// <param name="targetSetting"> Target settings to tune target endpoint migration behavior. </param>
        /// <param name="selectedTables"> Tables selected for migration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput(string name, string id, string targetDatabaseName, IDictionary<string, BinaryData> migrationSetting, IDictionary<string, string> sourceSetting, IDictionary<string, string> targetSetting, IList<MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseTableInput> selectedTables, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Id = id;
            TargetDatabaseName = targetDatabaseName;
            MigrationSetting = migrationSetting;
            SourceSetting = sourceSetting;
            TargetSetting = targetSetting;
            SelectedTables = selectedTables;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the database. </summary>
        public string Name { get; set; }
        /// <summary> Result identifier. </summary>
        public string Id { get; }
        /// <summary> Name of target database. Note: Target database will be truncated before starting migration. </summary>
        public string TargetDatabaseName { get; set; }
        /// <summary>
        /// Migration settings which tune the migration behavior
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IDictionary<string, BinaryData> MigrationSetting { get; }
        /// <summary> Source settings to tune source endpoint migration behavior. </summary>
        public IDictionary<string, string> SourceSetting { get; }
        /// <summary> Target settings to tune target endpoint migration behavior. </summary>
        public IDictionary<string, string> TargetSetting { get; }
        /// <summary> Tables selected for migration. </summary>
        public IList<MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseTableInput> SelectedTables { get; }
    }
}
