// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Input for command that completes online migration for an Azure SQL Database Managed Instance. </summary>
    internal partial class MigrateMISyncCompleteCommandInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MigrateMISyncCompleteCommandInput"/>. </summary>
        /// <param name="sourceDatabaseName"> Name of managed instance database. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="sourceDatabaseName"/> is null. </exception>
        public MigrateMISyncCompleteCommandInput(string sourceDatabaseName)
        {
            Argument.AssertNotNull(sourceDatabaseName, nameof(sourceDatabaseName));

            SourceDatabaseName = sourceDatabaseName;
        }

        /// <summary> Initializes a new instance of <see cref="MigrateMISyncCompleteCommandInput"/>. </summary>
        /// <param name="sourceDatabaseName"> Name of managed instance database. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MigrateMISyncCompleteCommandInput(string sourceDatabaseName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceDatabaseName = sourceDatabaseName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MigrateMISyncCompleteCommandInput"/> for deserialization. </summary>
        internal MigrateMISyncCompleteCommandInput()
        {
        }

        /// <summary> Name of managed instance database. </summary>
        public string SourceDatabaseName { get; set; }
    }
}
