// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Input for the task that gets the list of tables contained within a provided list of Oracle schemas. </summary>
    public partial class GetUserTablesOracleTaskInput
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="GetUserTablesOracleTaskInput"/>. </summary>
        /// <param name="connectionInfo"> Information for connecting to Oracle source. </param>
        /// <param name="selectedSchemas"> List of Oracle schemas for which to collect tables. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="connectionInfo"/> or <paramref name="selectedSchemas"/> is null. </exception>
        public GetUserTablesOracleTaskInput(OracleConnectionInfo connectionInfo, IEnumerable<string> selectedSchemas)
        {
            Argument.AssertNotNull(connectionInfo, nameof(connectionInfo));
            Argument.AssertNotNull(selectedSchemas, nameof(selectedSchemas));

            ConnectionInfo = connectionInfo;
            SelectedSchemas = selectedSchemas.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="GetUserTablesOracleTaskInput"/>. </summary>
        /// <param name="connectionInfo"> Information for connecting to Oracle source. </param>
        /// <param name="selectedSchemas"> List of Oracle schemas for which to collect tables. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal GetUserTablesOracleTaskInput(OracleConnectionInfo connectionInfo, IList<string> selectedSchemas, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ConnectionInfo = connectionInfo;
            SelectedSchemas = selectedSchemas;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="GetUserTablesOracleTaskInput"/> for deserialization. </summary>
        internal GetUserTablesOracleTaskInput()
        {
        }

        /// <summary> Information for connecting to Oracle source. </summary>
        public OracleConnectionInfo ConnectionInfo { get; set; }
        /// <summary> List of Oracle schemas for which to collect tables. </summary>
        public IList<string> SelectedSchemas { get; }
    }
}
