// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataMigration.Models
{
    public partial class GetTdeCertificatesSqlTaskInput : IUtf8JsonSerializable, IJsonModel<GetTdeCertificatesSqlTaskInput>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<GetTdeCertificatesSqlTaskInput>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<GetTdeCertificatesSqlTaskInput>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetTdeCertificatesSqlTaskInput>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GetTdeCertificatesSqlTaskInput)} does not support writing '{format}' format.");
            }

            writer.WritePropertyName("connectionInfo"u8);
            writer.WriteObjectValue(ConnectionInfo, options);
            writer.WritePropertyName("backupFileShare"u8);
            writer.WriteObjectValue(BackupFileShare, options);
            writer.WritePropertyName("selectedCertificates"u8);
            writer.WriteStartArray();
            foreach (var item in SelectedCertificates)
            {
                writer.WriteObjectValue(item, options);
            }
            writer.WriteEndArray();
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        GetTdeCertificatesSqlTaskInput IJsonModel<GetTdeCertificatesSqlTaskInput>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetTdeCertificatesSqlTaskInput>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(GetTdeCertificatesSqlTaskInput)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeGetTdeCertificatesSqlTaskInput(document.RootElement, options);
        }

        internal static GetTdeCertificatesSqlTaskInput DeserializeGetTdeCertificatesSqlTaskInput(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SqlConnectionInfo connectionInfo = default;
            FileShare backupFileShare = default;
            IList<SelectedCertificateInput> selectedCertificates = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("connectionInfo"u8))
                {
                    connectionInfo = SqlConnectionInfo.DeserializeSqlConnectionInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("backupFileShare"u8))
                {
                    backupFileShare = FileShare.DeserializeFileShare(property.Value, options);
                    continue;
                }
                if (property.NameEquals("selectedCertificates"u8))
                {
                    List<SelectedCertificateInput> array = new List<SelectedCertificateInput>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SelectedCertificateInput.DeserializeSelectedCertificateInput(item, options));
                    }
                    selectedCertificates = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new GetTdeCertificatesSqlTaskInput(connectionInfo, backupFileShare, selectedCertificates, serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<GetTdeCertificatesSqlTaskInput>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetTdeCertificatesSqlTaskInput>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(GetTdeCertificatesSqlTaskInput)} does not support writing '{options.Format}' format.");
            }
        }

        GetTdeCertificatesSqlTaskInput IPersistableModel<GetTdeCertificatesSqlTaskInput>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<GetTdeCertificatesSqlTaskInput>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeGetTdeCertificatesSqlTaskInput(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(GetTdeCertificatesSqlTaskInput)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<GetTdeCertificatesSqlTaskInput>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
