// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Current stage of migration. </summary>
    public readonly partial struct DatabaseMigrationStage : IEquatable<DatabaseMigrationStage>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DatabaseMigrationStage"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DatabaseMigrationStage(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string InitializeValue = "Initialize";
        private const string BackupValue = "Backup";
        private const string FileCopyValue = "FileCopy";
        private const string RestoreValue = "Restore";
        private const string CompletedValue = "Completed";

        /// <summary> None. </summary>
        public static DatabaseMigrationStage None { get; } = new DatabaseMigrationStage(NoneValue);
        /// <summary> Initialize. </summary>
        public static DatabaseMigrationStage Initialize { get; } = new DatabaseMigrationStage(InitializeValue);
        /// <summary> Backup. </summary>
        public static DatabaseMigrationStage Backup { get; } = new DatabaseMigrationStage(BackupValue);
        /// <summary> FileCopy. </summary>
        public static DatabaseMigrationStage FileCopy { get; } = new DatabaseMigrationStage(FileCopyValue);
        /// <summary> Restore. </summary>
        public static DatabaseMigrationStage Restore { get; } = new DatabaseMigrationStage(RestoreValue);
        /// <summary> Completed. </summary>
        public static DatabaseMigrationStage Completed { get; } = new DatabaseMigrationStage(CompletedValue);
        /// <summary> Determines if two <see cref="DatabaseMigrationStage"/> values are the same. </summary>
        public static bool operator ==(DatabaseMigrationStage left, DatabaseMigrationStage right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DatabaseMigrationStage"/> values are not the same. </summary>
        public static bool operator !=(DatabaseMigrationStage left, DatabaseMigrationStage right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DatabaseMigrationStage"/>. </summary>
        public static implicit operator DatabaseMigrationStage(string value) => new DatabaseMigrationStage(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DatabaseMigrationStage other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DatabaseMigrationStage other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
