// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> An enumeration of SQL Server database file types. </summary>
    public readonly partial struct DatabaseFileType : IEquatable<DatabaseFileType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DatabaseFileType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DatabaseFileType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RowsValue = "Rows";
        private const string LogValue = "Log";
        private const string FilestreamValue = "Filestream";
        private const string NotSupportedValue = "NotSupported";
        private const string FulltextValue = "Fulltext";

        /// <summary> Rows. </summary>
        public static DatabaseFileType Rows { get; } = new DatabaseFileType(RowsValue);
        /// <summary> Log. </summary>
        public static DatabaseFileType Log { get; } = new DatabaseFileType(LogValue);
        /// <summary> Filestream. </summary>
        public static DatabaseFileType Filestream { get; } = new DatabaseFileType(FilestreamValue);
        /// <summary> NotSupported. </summary>
        public static DatabaseFileType NotSupported { get; } = new DatabaseFileType(NotSupportedValue);
        /// <summary> Fulltext. </summary>
        public static DatabaseFileType Fulltext { get; } = new DatabaseFileType(FulltextValue);
        /// <summary> Determines if two <see cref="DatabaseFileType"/> values are the same. </summary>
        public static bool operator ==(DatabaseFileType left, DatabaseFileType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DatabaseFileType"/> values are not the same. </summary>
        public static bool operator !=(DatabaseFileType left, DatabaseFileType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DatabaseFileType"/>. </summary>
        public static implicit operator DatabaseFileType(string value) => new DatabaseFileType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DatabaseFileType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DatabaseFileType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
