// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Information about backup files when existing backup mode is used. </summary>
    public partial class DatabaseBackupInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DatabaseBackupInfo"/>. </summary>
        internal DatabaseBackupInfo()
        {
            BackupFiles = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="DatabaseBackupInfo"/>. </summary>
        /// <param name="databaseName"> Database name. </param>
        /// <param name="backupType"> Backup Type. </param>
        /// <param name="backupFiles"> The list of backup files for the current database. </param>
        /// <param name="position"> Position of current database backup in the file. </param>
        /// <param name="isDamaged"> Database was damaged when backed up, but the backup operation was requested to continue despite errors. </param>
        /// <param name="isCompressed"> Whether the backup set is compressed. </param>
        /// <param name="familyCount"> Number of files in the backup set. </param>
        /// <param name="backupFinishOn"> Date and time when the backup operation finished. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DatabaseBackupInfo(string databaseName, BackupType? backupType, IReadOnlyList<string> backupFiles, int? position, bool? isDamaged, bool? isCompressed, int? familyCount, DateTimeOffset? backupFinishOn, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DatabaseName = databaseName;
            BackupType = backupType;
            BackupFiles = backupFiles;
            Position = position;
            IsDamaged = isDamaged;
            IsCompressed = isCompressed;
            FamilyCount = familyCount;
            BackupFinishOn = backupFinishOn;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Database name. </summary>
        public string DatabaseName { get; }
        /// <summary> Backup Type. </summary>
        public BackupType? BackupType { get; }
        /// <summary> The list of backup files for the current database. </summary>
        public IReadOnlyList<string> BackupFiles { get; }
        /// <summary> Position of current database backup in the file. </summary>
        public int? Position { get; }
        /// <summary> Database was damaged when backed up, but the backup operation was requested to continue despite errors. </summary>
        public bool? IsDamaged { get; }
        /// <summary> Whether the backup set is compressed. </summary>
        public bool? IsCompressed { get; }
        /// <summary> Number of files in the backup set. </summary>
        public int? FamilyCount { get; }
        /// <summary> Date and time when the backup operation finished. </summary>
        public DateTimeOffset? BackupFinishOn { get; }
    }
}
