// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataMigration.Models
{
    public partial class CopyProgressDetails : IUtf8JsonSerializable, IJsonModel<CopyProgressDetails>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<CopyProgressDetails>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<CopyProgressDetails>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CopyProgressDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CopyProgressDetails)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(TableName))
            {
                writer.WritePropertyName("tableName"u8);
                writer.WriteStringValue(TableName);
            }
            if (options.Format != "W" && Optional.IsDefined(Status))
            {
                writer.WritePropertyName("status"u8);
                writer.WriteStringValue(Status);
            }
            if (options.Format != "W" && Optional.IsDefined(ParallelCopyType))
            {
                writer.WritePropertyName("parallelCopyType"u8);
                writer.WriteStringValue(ParallelCopyType);
            }
            if (options.Format != "W" && Optional.IsDefined(UsedParallelCopies))
            {
                writer.WritePropertyName("usedParallelCopies"u8);
                writer.WriteNumberValue(UsedParallelCopies.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(DataRead))
            {
                writer.WritePropertyName("dataRead"u8);
                writer.WriteNumberValue(DataRead.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(DataWritten))
            {
                writer.WritePropertyName("dataWritten"u8);
                writer.WriteNumberValue(DataWritten.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(RowsRead))
            {
                writer.WritePropertyName("rowsRead"u8);
                writer.WriteNumberValue(RowsRead.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(RowsCopied))
            {
                writer.WritePropertyName("rowsCopied"u8);
                writer.WriteNumberValue(RowsCopied.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CopyStart))
            {
                writer.WritePropertyName("copyStart"u8);
                writer.WriteStringValue(CopyStart.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(CopyThroughput))
            {
                writer.WritePropertyName("copyThroughput"u8);
                writer.WriteNumberValue(CopyThroughput.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(CopyDuration))
            {
                writer.WritePropertyName("copyDuration"u8);
                writer.WriteNumberValue(CopyDuration.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        CopyProgressDetails IJsonModel<CopyProgressDetails>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CopyProgressDetails>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(CopyProgressDetails)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeCopyProgressDetails(document.RootElement, options);
        }

        internal static CopyProgressDetails DeserializeCopyProgressDetails(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string tableName = default;
            string status = default;
            string parallelCopyType = default;
            int? usedParallelCopies = default;
            long? dataRead = default;
            long? dataWritten = default;
            long? rowsRead = default;
            long? rowsCopied = default;
            DateTimeOffset? copyStart = default;
            double? copyThroughput = default;
            int? copyDuration = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("tableName"u8))
                {
                    tableName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("status"u8))
                {
                    status = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("parallelCopyType"u8))
                {
                    parallelCopyType = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("usedParallelCopies"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    usedParallelCopies = property.Value.GetInt32();
                    continue;
                }
                if (property.NameEquals("dataRead"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataRead = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("dataWritten"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataWritten = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("rowsRead"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rowsRead = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("rowsCopied"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    rowsCopied = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("copyStart"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    copyStart = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("copyThroughput"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    copyThroughput = property.Value.GetDouble();
                    continue;
                }
                if (property.NameEquals("copyDuration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    copyDuration = property.Value.GetInt32();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new CopyProgressDetails(
                tableName,
                status,
                parallelCopyType,
                usedParallelCopies,
                dataRead,
                dataWritten,
                rowsRead,
                rowsCopied,
                copyStart,
                copyThroughput,
                copyDuration,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<CopyProgressDetails>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CopyProgressDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(CopyProgressDetails)} does not support writing '{options.Format}' format.");
            }
        }

        CopyProgressDetails IPersistableModel<CopyProgressDetails>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<CopyProgressDetails>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeCopyProgressDetails(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(CopyProgressDetails)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<CopyProgressDetails>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
