// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Login level output for the task that validates connection to SQL Server and also validates source server requirements. </summary>
    public partial class ConnectToSourceSqlServerTaskOutputLoginLevel : ConnectToSourceSqlServerTaskOutput
    {
        /// <summary> Initializes a new instance of <see cref="ConnectToSourceSqlServerTaskOutputLoginLevel"/>. </summary>
        internal ConnectToSourceSqlServerTaskOutputLoginLevel()
        {
            ResultType = "LoginLevelOutput";
        }

        /// <summary> Initializes a new instance of <see cref="ConnectToSourceSqlServerTaskOutputLoginLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Type of result - database level or task level. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="name"> Login name. </param>
        /// <param name="loginType"> The type of login. </param>
        /// <param name="defaultDatabase"> The default database for the login. </param>
        /// <param name="isEnabled"> The state of the login. </param>
        /// <param name="migrationEligibility"> Information about eligibility of login for migration. </param>
        internal ConnectToSourceSqlServerTaskOutputLoginLevel(string id, string resultType, IDictionary<string, BinaryData> serializedAdditionalRawData, string name, LoginType? loginType, string defaultDatabase, bool? isEnabled, MigrationEligibilityInfo migrationEligibility) : base(id, resultType, serializedAdditionalRawData)
        {
            Name = name;
            LoginType = loginType;
            DefaultDatabase = defaultDatabase;
            IsEnabled = isEnabled;
            MigrationEligibility = migrationEligibility;
            ResultType = resultType ?? "LoginLevelOutput";
        }

        /// <summary> Login name. </summary>
        public string Name { get; }
        /// <summary> The type of login. </summary>
        public LoginType? LoginType { get; }
        /// <summary> The default database for the login. </summary>
        public string DefaultDatabase { get; }
        /// <summary> The state of the login. </summary>
        public bool? IsEnabled { get; }
        /// <summary> Information about eligibility of login for migration. </summary>
        public MigrationEligibilityInfo MigrationEligibility { get; }
    }
}
