// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Properties for the task that checks for OCI drivers. </summary>
    public partial class CheckOciDriverTaskProperties : ProjectTaskProperties
    {
        /// <summary> Initializes a new instance of <see cref="CheckOciDriverTaskProperties"/>. </summary>
        public CheckOciDriverTaskProperties()
        {
            Output = new ChangeTrackingList<CheckOciDriverTaskOutput>();
            TaskType = TaskType.ServiceCheckOci;
        }

        /// <summary> Initializes a new instance of <see cref="CheckOciDriverTaskProperties"/>. </summary>
        /// <param name="taskType"> Task type. </param>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MongoDBCancelCommand"/>, <see cref="MongoDBFinishCommand"/>, <see cref="MigrateMISyncCompleteCommandProperties"/>, <see cref="MigrateSyncCompleteCommandProperties"/> and <see cref="MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        /// <param name="input"> Input for the service task to check for OCI drivers. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        internal CheckOciDriverTaskProperties(TaskType taskType, IReadOnlyList<ODataError> errors, TaskState? state, IReadOnlyList<CommandProperties> commands, IDictionary<string, string> clientData, IDictionary<string, BinaryData> serializedAdditionalRawData, CheckOciDriverTaskInput input, IReadOnlyList<CheckOciDriverTaskOutput> output) : base(taskType, errors, state, commands, clientData, serializedAdditionalRawData)
        {
            Input = input;
            Output = output;
            TaskType = taskType;
        }

        /// <summary> Input for the service task to check for OCI drivers. </summary>
        internal CheckOciDriverTaskInput Input { get; set; }
        /// <summary> Version of the source server to check against.  Optional. </summary>
        public string InputServerVersion
        {
            get => Input is null ? default : Input.ServerVersion;
            set
            {
                if (Input is null)
                    Input = new CheckOciDriverTaskInput();
                Input.ServerVersion = value;
            }
        }

        /// <summary> Task output. This is ignored if submitted. </summary>
        public IReadOnlyList<CheckOciDriverTaskOutput> Output { get; }
    }
}
