// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Information of backup set. </summary>
    public partial class BackupSetInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupSetInfo"/>. </summary>
        internal BackupSetInfo()
        {
            ListOfBackupFiles = new ChangeTrackingList<BackupFileInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="BackupSetInfo"/>. </summary>
        /// <param name="backupSetId"> Id for the set of backup files. </param>
        /// <param name="firstLsn"> First log sequence number of the backup file. </param>
        /// <param name="lastLsn"> Last log sequence number of the backup file. </param>
        /// <param name="lastModifiedOn"> Last modified time of the backup file in share location. </param>
        /// <param name="backupType"> Enum of the different backup types. </param>
        /// <param name="listOfBackupFiles"> List of files in the backup set. </param>
        /// <param name="databaseName"> Name of the database to which the backup set belongs. </param>
        /// <param name="backupStartOn"> Date and time that the backup operation began. </param>
        /// <param name="backupFinishedOn"> Date and time that the backup operation finished. </param>
        /// <param name="isBackupRestored"> Whether the backup set is restored or not. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupSetInfo(string backupSetId, string firstLsn, string lastLsn, DateTimeOffset? lastModifiedOn, BackupType? backupType, IReadOnlyList<BackupFileInfo> listOfBackupFiles, string databaseName, DateTimeOffset? backupStartOn, DateTimeOffset? backupFinishedOn, bool? isBackupRestored, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BackupSetId = backupSetId;
            FirstLsn = firstLsn;
            LastLsn = lastLsn;
            LastModifiedOn = lastModifiedOn;
            BackupType = backupType;
            ListOfBackupFiles = listOfBackupFiles;
            DatabaseName = databaseName;
            BackupStartOn = backupStartOn;
            BackupFinishedOn = backupFinishedOn;
            IsBackupRestored = isBackupRestored;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id for the set of backup files. </summary>
        public string BackupSetId { get; }
        /// <summary> First log sequence number of the backup file. </summary>
        public string FirstLsn { get; }
        /// <summary> Last log sequence number of the backup file. </summary>
        public string LastLsn { get; }
        /// <summary> Last modified time of the backup file in share location. </summary>
        public DateTimeOffset? LastModifiedOn { get; }
        /// <summary> Enum of the different backup types. </summary>
        public BackupType? BackupType { get; }
        /// <summary> List of files in the backup set. </summary>
        public IReadOnlyList<BackupFileInfo> ListOfBackupFiles { get; }
        /// <summary> Name of the database to which the backup set belongs. </summary>
        public string DatabaseName { get; }
        /// <summary> Date and time that the backup operation began. </summary>
        public DateTimeOffset? BackupStartOn { get; }
        /// <summary> Date and time that the backup operation finished. </summary>
        public DateTimeOffset? BackupFinishedOn { get; }
        /// <summary> Whether the backup set is restored or not. </summary>
        public bool? IsBackupRestored { get; }
    }
}
