// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.DataMigration.Models
{
    public partial class BackupSetInfo : IUtf8JsonSerializable, IJsonModel<BackupSetInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<BackupSetInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<BackupSetInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupSetInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupSetInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(BackupSetId))
            {
                writer.WritePropertyName("backupSetId"u8);
                writer.WriteStringValue(BackupSetId);
            }
            if (Optional.IsDefined(FirstLsn))
            {
                writer.WritePropertyName("firstLsn"u8);
                writer.WriteStringValue(FirstLsn);
            }
            if (Optional.IsDefined(LastLsn))
            {
                writer.WritePropertyName("lastLsn"u8);
                writer.WriteStringValue(LastLsn);
            }
            if (Optional.IsDefined(LastModifiedOn))
            {
                writer.WritePropertyName("lastModifiedTime"u8);
                writer.WriteStringValue(LastModifiedOn.Value, "O");
            }
            if (Optional.IsDefined(BackupType))
            {
                writer.WritePropertyName("backupType"u8);
                writer.WriteStringValue(BackupType.Value.ToString());
            }
            if (Optional.IsCollectionDefined(ListOfBackupFiles))
            {
                writer.WritePropertyName("listOfBackupFiles"u8);
                writer.WriteStartArray();
                foreach (var item in ListOfBackupFiles)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsDefined(DatabaseName))
            {
                writer.WritePropertyName("databaseName"u8);
                writer.WriteStringValue(DatabaseName);
            }
            if (Optional.IsDefined(BackupStartOn))
            {
                writer.WritePropertyName("backupStartDate"u8);
                writer.WriteStringValue(BackupStartOn.Value, "O");
            }
            if (Optional.IsDefined(BackupFinishedOn))
            {
                writer.WritePropertyName("backupFinishedDate"u8);
                writer.WriteStringValue(BackupFinishedOn.Value, "O");
            }
            if (Optional.IsDefined(IsBackupRestored))
            {
                writer.WritePropertyName("isBackupRestored"u8);
                writer.WriteBooleanValue(IsBackupRestored.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        BackupSetInfo IJsonModel<BackupSetInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupSetInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(BackupSetInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeBackupSetInfo(document.RootElement, options);
        }

        internal static BackupSetInfo DeserializeBackupSetInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string backupSetId = default;
            string firstLsn = default;
            string lastLsn = default;
            DateTimeOffset? lastModifiedTime = default;
            BackupType? backupType = default;
            IReadOnlyList<BackupFileInfo> listOfBackupFiles = default;
            string databaseName = default;
            DateTimeOffset? backupStartDate = default;
            DateTimeOffset? backupFinishedDate = default;
            bool? isBackupRestored = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("backupSetId"u8))
                {
                    backupSetId = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("firstLsn"u8))
                {
                    firstLsn = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastLsn"u8))
                {
                    lastLsn = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("lastModifiedTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastModifiedTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("backupType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    backupType = new BackupType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("listOfBackupFiles"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<BackupFileInfo> array = new List<BackupFileInfo>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(BackupFileInfo.DeserializeBackupFileInfo(item, options));
                    }
                    listOfBackupFiles = array;
                    continue;
                }
                if (property.NameEquals("databaseName"u8))
                {
                    databaseName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("backupStartDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    backupStartDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("backupFinishedDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    backupFinishedDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("isBackupRestored"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    isBackupRestored = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new BackupSetInfo(
                backupSetId,
                firstLsn,
                lastLsn,
                lastModifiedTime,
                backupType,
                listOfBackupFiles ?? new ChangeTrackingList<BackupFileInfo>(),
                databaseName,
                backupStartDate,
                backupFinishedDate,
                isBackupRestored,
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<BackupSetInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupSetInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(BackupSetInfo)} does not support writing '{options.Format}' format.");
            }
        }

        BackupSetInfo IPersistableModel<BackupSetInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<BackupSetInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeBackupSetInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(BackupSetInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<BackupSetInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
