// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> An enumeration of backup modes. </summary>
    public readonly partial struct BackupMode : IEquatable<BackupMode>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="BackupMode"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public BackupMode(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreateBackupValue = "CreateBackup";
        private const string ExistingBackupValue = "ExistingBackup";

        /// <summary> CreateBackup. </summary>
        public static BackupMode CreateBackup { get; } = new BackupMode(CreateBackupValue);
        /// <summary> ExistingBackup. </summary>
        public static BackupMode ExistingBackup { get; } = new BackupMode(ExistingBackupValue);
        /// <summary> Determines if two <see cref="BackupMode"/> values are the same. </summary>
        public static bool operator ==(BackupMode left, BackupMode right) => left.Equals(right);
        /// <summary> Determines if two <see cref="BackupMode"/> values are not the same. </summary>
        public static bool operator !=(BackupMode left, BackupMode right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="BackupMode"/>. </summary>
        public static implicit operator BackupMode(string value) => new BackupMode(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is BackupMode other && Equals(other);
        /// <inheritdoc />
        public bool Equals(BackupMode other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
