// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Information of the backup file. </summary>
    public partial class BackupFileInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupFileInfo"/>. </summary>
        internal BackupFileInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupFileInfo"/>. </summary>
        /// <param name="fileLocation"> Location of the backup file in shared folder. </param>
        /// <param name="familySequenceNumber"> Sequence number of the backup file in the backup set. </param>
        /// <param name="status"> Status of the backup file during migration. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupFileInfo(string fileLocation, int? familySequenceNumber, BackupFileStatus? status, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FileLocation = fileLocation;
            FamilySequenceNumber = familySequenceNumber;
            Status = status;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Location of the backup file in shared folder. </summary>
        public string FileLocation { get; }
        /// <summary> Sequence number of the backup file in the backup set. </summary>
        public int? FamilySequenceNumber { get; }
        /// <summary> Status of the backup file during migration. </summary>
        public BackupFileStatus? Status { get; }
    }
}
