// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Backup Configuration. </summary>
    public partial class BackupConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="BackupConfiguration"/>. </summary>
        public BackupConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="BackupConfiguration"/>. </summary>
        /// <param name="sourceLocation"> Source location of backups. </param>
        /// <param name="targetLocation"> Target location for copying backups. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal BackupConfiguration(SourceLocation sourceLocation, TargetLocation targetLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SourceLocation = sourceLocation;
            TargetLocation = targetLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Source location of backups. </summary>
        public SourceLocation SourceLocation { get; set; }
        /// <summary> Target location for copying backups. </summary>
        public TargetLocation TargetLocation { get; set; }
    }
}
