// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Azure Active Directory Application. </summary>
    public partial class AzureActiveDirectoryApp
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AzureActiveDirectoryApp"/>. </summary>
        public AzureActiveDirectoryApp()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AzureActiveDirectoryApp"/>. </summary>
        /// <param name="applicationId"> Application ID of the Azure Active Directory Application. </param>
        /// <param name="appKey"> Key used to authenticate to the Azure Active Directory Application. </param>
        /// <param name="tenantId"> Tenant id of the customer. </param>
        /// <param name="ignoreAzurePermissions"> Ignore checking azure permissions on the AAD app. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AzureActiveDirectoryApp(string applicationId, string appKey, Guid? tenantId, bool? ignoreAzurePermissions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ApplicationId = applicationId;
            AppKey = appKey;
            TenantId = tenantId;
            IgnoreAzurePermissions = ignoreAzurePermissions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Application ID of the Azure Active Directory Application. </summary>
        public string ApplicationId { get; set; }
        /// <summary> Key used to authenticate to the Azure Active Directory Application. </summary>
        public string AppKey { get; set; }
        /// <summary> Tenant id of the customer. </summary>
        public Guid? TenantId { get; set; }
        /// <summary> Ignore checking azure permissions on the AAD app. </summary>
        public bool? IgnoreAzurePermissions { get; set; }
    }
}
