// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> An enumeration of possible authentication types when connecting. </summary>
    public readonly partial struct AuthenticationType : IEquatable<AuthenticationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="AuthenticationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public AuthenticationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string WindowsAuthenticationValue = "WindowsAuthentication";
        private const string SqlAuthenticationValue = "SqlAuthentication";
        private const string ActiveDirectoryIntegratedValue = "ActiveDirectoryIntegrated";
        private const string ActiveDirectoryPasswordValue = "ActiveDirectoryPassword";

        /// <summary> None. </summary>
        public static AuthenticationType None { get; } = new AuthenticationType(NoneValue);
        /// <summary> WindowsAuthentication. </summary>
        public static AuthenticationType WindowsAuthentication { get; } = new AuthenticationType(WindowsAuthenticationValue);
        /// <summary> SqlAuthentication. </summary>
        public static AuthenticationType SqlAuthentication { get; } = new AuthenticationType(SqlAuthenticationValue);
        /// <summary> ActiveDirectoryIntegrated. </summary>
        public static AuthenticationType ActiveDirectoryIntegrated { get; } = new AuthenticationType(ActiveDirectoryIntegratedValue);
        /// <summary> ActiveDirectoryPassword. </summary>
        public static AuthenticationType ActiveDirectoryPassword { get; } = new AuthenticationType(ActiveDirectoryPasswordValue);
        /// <summary> Determines if two <see cref="AuthenticationType"/> values are the same. </summary>
        public static bool operator ==(AuthenticationType left, AuthenticationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AuthenticationType"/> values are not the same. </summary>
        public static bool operator !=(AuthenticationType left, AuthenticationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="AuthenticationType"/>. </summary>
        public static implicit operator AuthenticationType(string value) => new AuthenticationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AuthenticationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AuthenticationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
