// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.DataMigration
{
    internal class DatabaseMigrationSqlDBOperationSource : IOperationSource<DatabaseMigrationSqlDBResource>
    {
        private readonly ArmClient _client;

        internal DatabaseMigrationSqlDBOperationSource(ArmClient client)
        {
            _client = client;
        }

        DatabaseMigrationSqlDBResource IOperationSource<DatabaseMigrationSqlDBResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = DatabaseMigrationSqlDBData.DeserializeDatabaseMigrationSqlDBData(document.RootElement);
            return new DatabaseMigrationSqlDBResource(_client, data);
        }

        async ValueTask<DatabaseMigrationSqlDBResource> IOperationSource<DatabaseMigrationSqlDBResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = DatabaseMigrationSqlDBData.DeserializeDatabaseMigrationSqlDBData(document.RootElement);
            return new DatabaseMigrationSqlDBResource(_client, data);
        }
    }
}
