// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DataMigration.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDataMigrationArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDataMigrationArmClient"/> class for mocking. </summary>
        protected MockableDataMigrationArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDataMigrationArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDataMigrationArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDataMigrationArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DatabaseMigrationSqlDBResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DatabaseMigrationSqlDBResource.CreateResourceIdentifier" /> to create a <see cref="DatabaseMigrationSqlDBResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DatabaseMigrationSqlDBResource"/> object. </returns>
        public virtual DatabaseMigrationSqlDBResource GetDatabaseMigrationSqlDBResource(ResourceIdentifier id)
        {
            DatabaseMigrationSqlDBResource.ValidateResourceId(id);
            return new DatabaseMigrationSqlDBResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DatabaseMigrationSqlMIResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DatabaseMigrationSqlMIResource.CreateResourceIdentifier" /> to create a <see cref="DatabaseMigrationSqlMIResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DatabaseMigrationSqlMIResource"/> object. </returns>
        public virtual DatabaseMigrationSqlMIResource GetDatabaseMigrationSqlMIResource(ResourceIdentifier id)
        {
            DatabaseMigrationSqlMIResource.ValidateResourceId(id);
            return new DatabaseMigrationSqlMIResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DatabaseMigrationSqlVmResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DatabaseMigrationSqlVmResource.CreateResourceIdentifier" /> to create a <see cref="DatabaseMigrationSqlVmResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DatabaseMigrationSqlVmResource"/> object. </returns>
        public virtual DatabaseMigrationSqlVmResource GetDatabaseMigrationSqlVmResource(ResourceIdentifier id)
        {
            DatabaseMigrationSqlVmResource.ValidateResourceId(id);
            return new DatabaseMigrationSqlVmResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="SqlMigrationServiceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="SqlMigrationServiceResource.CreateResourceIdentifier" /> to create a <see cref="SqlMigrationServiceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="SqlMigrationServiceResource"/> object. </returns>
        public virtual SqlMigrationServiceResource GetSqlMigrationServiceResource(ResourceIdentifier id)
        {
            SqlMigrationServiceResource.ValidateResourceId(id);
            return new SqlMigrationServiceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataMigrationServiceResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataMigrationServiceResource.CreateResourceIdentifier" /> to create a <see cref="DataMigrationServiceResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataMigrationServiceResource"/> object. </returns>
        public virtual DataMigrationServiceResource GetDataMigrationServiceResource(ResourceIdentifier id)
        {
            DataMigrationServiceResource.ValidateResourceId(id);
            return new DataMigrationServiceResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceProjectTaskResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceProjectTaskResource.CreateResourceIdentifier" /> to create a <see cref="ServiceProjectTaskResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceProjectTaskResource"/> object. </returns>
        public virtual ServiceProjectTaskResource GetServiceProjectTaskResource(ResourceIdentifier id)
        {
            ServiceProjectTaskResource.ValidateResourceId(id);
            return new ServiceProjectTaskResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ServiceServiceTaskResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ServiceServiceTaskResource.CreateResourceIdentifier" /> to create a <see cref="ServiceServiceTaskResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ServiceServiceTaskResource"/> object. </returns>
        public virtual ServiceServiceTaskResource GetServiceServiceTaskResource(ResourceIdentifier id)
        {
            ServiceServiceTaskResource.ValidateResourceId(id);
            return new ServiceServiceTaskResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ProjectResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ProjectResource.CreateResourceIdentifier" /> to create a <see cref="ProjectResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ProjectResource"/> object. </returns>
        public virtual ProjectResource GetProjectResource(ResourceIdentifier id)
        {
            ProjectResource.ValidateResourceId(id);
            return new ProjectResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="ProjectFileResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="ProjectFileResource.CreateResourceIdentifier" /> to create a <see cref="ProjectFileResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="ProjectFileResource"/> object. </returns>
        public virtual ProjectFileResource GetProjectFileResource(ResourceIdentifier id)
        {
            ProjectFileResource.ValidateResourceId(id);
            return new ProjectFileResource(Client, id);
        }
    }
}
