// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;
using Azure.ResourceManager.Models;

namespace Azure.ResourceManager.DataMigration.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmDataMigrationModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="DataMigration.DatabaseMigrationSqlDBData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Database Migration Resource properties for SQL database. </param>
        /// <returns> A new <see cref="DataMigration.DatabaseMigrationSqlDBData"/> instance for mocking. </returns>
        public static DatabaseMigrationSqlDBData DatabaseMigrationSqlDBData(ResourceIdentifier id = null, string name = null, Core.ResourceType resourceType = default, SystemData systemData = null, DatabaseMigrationSqlDBProperties properties = null)
        {
            return new DatabaseMigrationSqlDBData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseMigrationSqlDBProperties"/>. </summary>
        /// <param name="scope"> Resource Id of the target resource (SQL VM or SQL Managed Instance). </param>
        /// <param name="provisioningState"> Provisioning State of migration. ProvisioningState as Succeeded implies that validations have been performed and migration has started. </param>
        /// <param name="migrationStatus"> Migration status. </param>
        /// <param name="startedOn"> Database migration start time. </param>
        /// <param name="endedOn"> Database migration end time. </param>
        /// <param name="sourceSqlConnection"> Source SQL Server connection details. </param>
        /// <param name="sourceDatabaseName"> Name of the source database. </param>
        /// <param name="sourceServerName"> Name of the source sql server. </param>
        /// <param name="migrationService"> Resource Id of the Migration Service. </param>
        /// <param name="migrationOperationId"> ID tracking current migration operation. </param>
        /// <param name="migrationFailureError"> Error details in case of migration failure. </param>
        /// <param name="targetDatabaseCollation"> Database collation to be used for the target database. </param>
        /// <param name="provisioningError"> Error message for migration provisioning failure, if any. </param>
        /// <param name="migrationStatusDetails"> Detailed migration status. Not included by default. </param>
        /// <param name="targetSqlConnection"> Target SQL DB connection details. </param>
        /// <param name="offline"> Offline configuration. </param>
        /// <param name="tableList"> List of tables to copy. </param>
        /// <returns> A new <see cref="Models.DatabaseMigrationSqlDBProperties"/> instance for mocking. </returns>
        public static DatabaseMigrationSqlDBProperties DatabaseMigrationSqlDBProperties(string scope = null, string provisioningState = null, string migrationStatus = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, SqlConnectionInformation sourceSqlConnection = null, string sourceDatabaseName = null, string sourceServerName = null, string migrationService = null, string migrationOperationId = null, ErrorInfo migrationFailureError = null, string targetDatabaseCollation = null, string provisioningError = null, SqlDBMigrationStatusDetails migrationStatusDetails = null, SqlConnectionInformation targetSqlConnection = null, bool? offline = null, IEnumerable<string> tableList = null)
        {
            tableList ??= new List<string>();

            return new DatabaseMigrationSqlDBProperties(
                ResourceType.SqlDB,
                scope,
                provisioningState,
                migrationStatus,
                startedOn,
                endedOn,
                sourceSqlConnection,
                sourceDatabaseName,
                sourceServerName,
                migrationService,
                migrationOperationId,
                migrationFailureError,
                targetDatabaseCollation,
                provisioningError,
                serializedAdditionalRawData: null,
                migrationStatusDetails,
                targetSqlConnection,
                offline != null ? new SqlDBOfflineConfiguration(offline, serializedAdditionalRawData: null) : null,
                tableList?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlDBMigrationStatusDetails"/>. </summary>
        /// <param name="migrationState"> Current State of Migration. </param>
        /// <param name="sqlDataCopyErrors"> Sql Data Copy errors, if any. </param>
        /// <param name="listOfCopyProgressDetails"> Details on progress of ADF copy activities. </param>
        /// <returns> A new <see cref="Models.SqlDBMigrationStatusDetails"/> instance for mocking. </returns>
        public static SqlDBMigrationStatusDetails SqlDBMigrationStatusDetails(string migrationState = null, IEnumerable<string> sqlDataCopyErrors = null, IEnumerable<CopyProgressDetails> listOfCopyProgressDetails = null)
        {
            sqlDataCopyErrors ??= new List<string>();
            listOfCopyProgressDetails ??= new List<CopyProgressDetails>();

            return new SqlDBMigrationStatusDetails(migrationState, sqlDataCopyErrors?.ToList(), listOfCopyProgressDetails?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CopyProgressDetails"/>. </summary>
        /// <param name="tableName"> Table Name. </param>
        /// <param name="status"> Status of the Copy activity (InProgress, Succeeded, Failed, Canceled). </param>
        /// <param name="parallelCopyType"> Type of parallel copy (Dynamic range, Physical partition, none). </param>
        /// <param name="usedParallelCopies"> The degree of parallelization. </param>
        /// <param name="dataRead"> Bytes read. </param>
        /// <param name="dataWritten"> Bytes written. </param>
        /// <param name="rowsRead"> Rows read. </param>
        /// <param name="rowsCopied"> Rows Copied. </param>
        /// <param name="copyStart"> Copy Start. </param>
        /// <param name="copyThroughput"> Copy throughput in KBps. </param>
        /// <param name="copyDuration"> Copy Duration in seconds. </param>
        /// <returns> A new <see cref="Models.CopyProgressDetails"/> instance for mocking. </returns>
        public static CopyProgressDetails CopyProgressDetails(string tableName = null, string status = null, string parallelCopyType = null, int? usedParallelCopies = null, long? dataRead = null, long? dataWritten = null, long? rowsRead = null, long? rowsCopied = null, DateTimeOffset? copyStart = null, double? copyThroughput = null, int? copyDuration = null)
        {
            return new CopyProgressDetails(
                tableName,
                status,
                parallelCopyType,
                usedParallelCopies,
                dataRead,
                dataWritten,
                rowsRead,
                rowsCopied,
                copyStart,
                copyThroughput,
                copyDuration,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseMigrationProperties"/>. </summary>
        /// <param name="kind"></param>
        /// <param name="scope"> Resource Id of the target resource (SQL VM or SQL Managed Instance). </param>
        /// <param name="provisioningState"> Provisioning State of migration. ProvisioningState as Succeeded implies that validations have been performed and migration has started. </param>
        /// <param name="migrationStatus"> Migration status. </param>
        /// <param name="startedOn"> Database migration start time. </param>
        /// <param name="endedOn"> Database migration end time. </param>
        /// <param name="sourceSqlConnection"> Source SQL Server connection details. </param>
        /// <param name="sourceDatabaseName"> Name of the source database. </param>
        /// <param name="sourceServerName"> Name of the source sql server. </param>
        /// <param name="migrationService"> Resource Id of the Migration Service. </param>
        /// <param name="migrationOperationId"> ID tracking current migration operation. </param>
        /// <param name="migrationFailureError"> Error details in case of migration failure. </param>
        /// <param name="targetDatabaseCollation"> Database collation to be used for the target database. </param>
        /// <param name="provisioningError"> Error message for migration provisioning failure, if any. </param>
        /// <returns> A new <see cref="Models.DatabaseMigrationProperties"/> instance for mocking. </returns>
        public static DatabaseMigrationProperties DatabaseMigrationProperties(string kind = null, string scope = null, string provisioningState = null, string migrationStatus = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, SqlConnectionInformation sourceSqlConnection = null, string sourceDatabaseName = null, string sourceServerName = null, string migrationService = null, string migrationOperationId = null, ErrorInfo migrationFailureError = null, string targetDatabaseCollation = null, string provisioningError = null)
        {
            return new UnknownDatabaseMigrationProperties(
                kind == null ? default : new ResourceType(kind),
                scope,
                provisioningState,
                migrationStatus,
                startedOn,
                endedOn,
                sourceSqlConnection,
                sourceDatabaseName,
                sourceServerName,
                migrationService,
                migrationOperationId,
                migrationFailureError,
                targetDatabaseCollation,
                provisioningError,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ErrorInfo"/>. </summary>
        /// <param name="code"> Error code. </param>
        /// <param name="message"> Error message. </param>
        /// <returns> A new <see cref="Models.ErrorInfo"/> instance for mocking. </returns>
        public static ErrorInfo ErrorInfo(string code = null, string message = null)
        {
            return new ErrorInfo(code, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataMigration.DatabaseMigrationSqlMIData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Database Migration Resource properties for SQL Managed Instance. </param>
        /// <returns> A new <see cref="DataMigration.DatabaseMigrationSqlMIData"/> instance for mocking. </returns>
        public static DatabaseMigrationSqlMIData DatabaseMigrationSqlMIData(ResourceIdentifier id = null, string name = null, Core.ResourceType resourceType = default, SystemData systemData = null, DatabaseMigrationSqlMIProperties properties = null)
        {
            return new DatabaseMigrationSqlMIData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseMigrationSqlMIProperties"/>. </summary>
        /// <param name="scope"> Resource Id of the target resource (SQL VM or SQL Managed Instance). </param>
        /// <param name="provisioningState"> Provisioning State of migration. ProvisioningState as Succeeded implies that validations have been performed and migration has started. </param>
        /// <param name="migrationStatus"> Migration status. </param>
        /// <param name="startedOn"> Database migration start time. </param>
        /// <param name="endedOn"> Database migration end time. </param>
        /// <param name="sourceSqlConnection"> Source SQL Server connection details. </param>
        /// <param name="sourceDatabaseName"> Name of the source database. </param>
        /// <param name="sourceServerName"> Name of the source sql server. </param>
        /// <param name="migrationService"> Resource Id of the Migration Service. </param>
        /// <param name="migrationOperationId"> ID tracking current migration operation. </param>
        /// <param name="migrationFailureError"> Error details in case of migration failure. </param>
        /// <param name="targetDatabaseCollation"> Database collation to be used for the target database. </param>
        /// <param name="provisioningError"> Error message for migration provisioning failure, if any. </param>
        /// <param name="migrationStatusDetails"> Detailed migration status. Not included by default. </param>
        /// <param name="backupConfiguration"> Backup configuration info. </param>
        /// <param name="offlineConfiguration"> Offline configuration. </param>
        /// <returns> A new <see cref="Models.DatabaseMigrationSqlMIProperties"/> instance for mocking. </returns>
        public static DatabaseMigrationSqlMIProperties DatabaseMigrationSqlMIProperties(string scope = null, string provisioningState = null, string migrationStatus = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, SqlConnectionInformation sourceSqlConnection = null, string sourceDatabaseName = null, string sourceServerName = null, string migrationService = null, string migrationOperationId = null, ErrorInfo migrationFailureError = null, string targetDatabaseCollation = null, string provisioningError = null, MigrationStatusDetails migrationStatusDetails = null, BackupConfiguration backupConfiguration = null, OfflineConfiguration offlineConfiguration = null)
        {
            return new DatabaseMigrationSqlMIProperties(
                ResourceType.SqlMI,
                scope,
                provisioningState,
                migrationStatus,
                startedOn,
                endedOn,
                sourceSqlConnection,
                sourceDatabaseName,
                sourceServerName,
                migrationService,
                migrationOperationId,
                migrationFailureError,
                targetDatabaseCollation,
                provisioningError,
                serializedAdditionalRawData: null,
                migrationStatusDetails,
                backupConfiguration,
                offlineConfiguration);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrationStatusDetails"/>. </summary>
        /// <param name="migrationState"> Current State of Migration. </param>
        /// <param name="fullBackupSetInfo"> Details of full backup set. </param>
        /// <param name="lastRestoredBackupSetInfo"> Last applied backup set information. </param>
        /// <param name="activeBackupSets"> Backup sets that are currently active. </param>
        /// <param name="invalidFiles"> Files that are not valid backup files. </param>
        /// <param name="blobContainerName"> Name of blob container. </param>
        /// <param name="isFullBackupRestored"> Whether full backup has been applied to the target database or not. </param>
        /// <param name="restoreBlockingReason"> Restore blocking reason, if any. </param>
        /// <param name="completeRestoreErrorMessage"> Complete restore error message, if any. </param>
        /// <param name="fileUploadBlockingErrors"> File upload blocking errors, if any. </param>
        /// <param name="currentRestoringFilename"> File name that is currently being restored. </param>
        /// <param name="lastRestoredFilename"> Last restored file name. </param>
        /// <param name="pendingLogBackupsCount"> Total pending log backups. </param>
        /// <returns> A new <see cref="Models.MigrationStatusDetails"/> instance for mocking. </returns>
        public static MigrationStatusDetails MigrationStatusDetails(string migrationState = null, SqlBackupSetInfo fullBackupSetInfo = null, SqlBackupSetInfo lastRestoredBackupSetInfo = null, IEnumerable<SqlBackupSetInfo> activeBackupSets = null, IEnumerable<string> invalidFiles = null, string blobContainerName = null, bool? isFullBackupRestored = null, string restoreBlockingReason = null, string completeRestoreErrorMessage = null, IEnumerable<string> fileUploadBlockingErrors = null, string currentRestoringFilename = null, string lastRestoredFilename = null, int? pendingLogBackupsCount = null)
        {
            activeBackupSets ??= new List<SqlBackupSetInfo>();
            invalidFiles ??= new List<string>();
            fileUploadBlockingErrors ??= new List<string>();

            return new MigrationStatusDetails(
                migrationState,
                fullBackupSetInfo,
                lastRestoredBackupSetInfo,
                activeBackupSets?.ToList(),
                invalidFiles?.ToList(),
                blobContainerName,
                isFullBackupRestored,
                restoreBlockingReason,
                completeRestoreErrorMessage,
                fileUploadBlockingErrors?.ToList(),
                currentRestoringFilename,
                lastRestoredFilename,
                pendingLogBackupsCount,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlBackupSetInfo"/>. </summary>
        /// <param name="backupSetId"> Backup set id. </param>
        /// <param name="firstLSN"> First LSN of the backup set. </param>
        /// <param name="lastLSN"> Last LSN of the backup set. </param>
        /// <param name="backupType"> Backup type. </param>
        /// <param name="listOfBackupFiles"> List of files in the backup set. </param>
        /// <param name="backupStartOn"> Backup start date. </param>
        /// <param name="backupFinishOn"> Backup end time. </param>
        /// <param name="isBackupRestored"> Whether this backup set has been restored or not. </param>
        /// <param name="hasBackupChecksums"> Has Backup Checksums. </param>
        /// <param name="familyCount"> Media family count. </param>
        /// <param name="ignoreReasons"> The reasons why the backup set is ignored. </param>
        /// <returns> A new <see cref="Models.SqlBackupSetInfo"/> instance for mocking. </returns>
        public static SqlBackupSetInfo SqlBackupSetInfo(Guid? backupSetId = null, string firstLSN = null, string lastLSN = null, string backupType = null, IEnumerable<SqlBackupFileInfo> listOfBackupFiles = null, DateTimeOffset? backupStartOn = null, DateTimeOffset? backupFinishOn = null, bool? isBackupRestored = null, bool? hasBackupChecksums = null, int? familyCount = null, IEnumerable<string> ignoreReasons = null)
        {
            listOfBackupFiles ??= new List<SqlBackupFileInfo>();
            ignoreReasons ??= new List<string>();

            return new SqlBackupSetInfo(
                backupSetId,
                firstLSN,
                lastLSN,
                backupType,
                listOfBackupFiles?.ToList(),
                backupStartOn,
                backupFinishOn,
                isBackupRestored,
                hasBackupChecksums,
                familyCount,
                ignoreReasons?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SqlBackupFileInfo"/>. </summary>
        /// <param name="fileName"> File name. </param>
        /// <param name="status"> Status of the file. (Initial, Uploading, Uploaded, Restoring, Restored or Skipped). </param>
        /// <param name="totalSize"> File size in bytes. </param>
        /// <param name="dataRead"> Bytes read. </param>
        /// <param name="dataWritten"> Bytes written. </param>
        /// <param name="copyThroughput"> Copy throughput in KBps. </param>
        /// <param name="copyDuration"> Copy Duration in seconds. </param>
        /// <param name="familySequenceNumber"> Media family sequence number. </param>
        /// <returns> A new <see cref="Models.SqlBackupFileInfo"/> instance for mocking. </returns>
        public static SqlBackupFileInfo SqlBackupFileInfo(string fileName = null, string status = null, long? totalSize = null, long? dataRead = null, long? dataWritten = null, double? copyThroughput = null, int? copyDuration = null, int? familySequenceNumber = null)
        {
            return new SqlBackupFileInfo(
                fileName,
                status,
                totalSize,
                dataRead,
                dataWritten,
                copyThroughput,
                copyDuration,
                familySequenceNumber,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SourceLocation"/>. </summary>
        /// <param name="fileShare"> Source File share. </param>
        /// <param name="azureBlob"> Source Azure Blob. </param>
        /// <param name="fileStorageType"> Backup storage Type. </param>
        /// <returns> A new <see cref="Models.SourceLocation"/> instance for mocking. </returns>
        public static SourceLocation SourceLocation(SqlFileShare fileShare = null, AzureBlob azureBlob = null, string fileStorageType = null)
        {
            return new SourceLocation(fileShare, azureBlob, fileStorageType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataMigration.DatabaseMigrationSqlVmData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> Database Migration Resource properties for SQL Virtual Machine. </param>
        /// <returns> A new <see cref="DataMigration.DatabaseMigrationSqlVmData"/> instance for mocking. </returns>
        public static DatabaseMigrationSqlVmData DatabaseMigrationSqlVmData(ResourceIdentifier id = null, string name = null, Core.ResourceType resourceType = default, SystemData systemData = null, DatabaseMigrationSqlVmProperties properties = null)
        {
            return new DatabaseMigrationSqlVmData(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseMigrationSqlVmProperties"/>. </summary>
        /// <param name="scope"> Resource Id of the target resource (SQL VM or SQL Managed Instance). </param>
        /// <param name="provisioningState"> Provisioning State of migration. ProvisioningState as Succeeded implies that validations have been performed and migration has started. </param>
        /// <param name="migrationStatus"> Migration status. </param>
        /// <param name="startedOn"> Database migration start time. </param>
        /// <param name="endedOn"> Database migration end time. </param>
        /// <param name="sourceSqlConnection"> Source SQL Server connection details. </param>
        /// <param name="sourceDatabaseName"> Name of the source database. </param>
        /// <param name="sourceServerName"> Name of the source sql server. </param>
        /// <param name="migrationService"> Resource Id of the Migration Service. </param>
        /// <param name="migrationOperationId"> ID tracking current migration operation. </param>
        /// <param name="migrationFailureError"> Error details in case of migration failure. </param>
        /// <param name="targetDatabaseCollation"> Database collation to be used for the target database. </param>
        /// <param name="provisioningError"> Error message for migration provisioning failure, if any. </param>
        /// <param name="migrationStatusDetails"> Detailed migration status. Not included by default. </param>
        /// <param name="backupConfiguration"> Backup configuration info. </param>
        /// <param name="offlineConfiguration"> Offline configuration. </param>
        /// <returns> A new <see cref="Models.DatabaseMigrationSqlVmProperties"/> instance for mocking. </returns>
        public static DatabaseMigrationSqlVmProperties DatabaseMigrationSqlVmProperties(string scope = null, string provisioningState = null, string migrationStatus = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, SqlConnectionInformation sourceSqlConnection = null, string sourceDatabaseName = null, string sourceServerName = null, string migrationService = null, string migrationOperationId = null, ErrorInfo migrationFailureError = null, string targetDatabaseCollation = null, string provisioningError = null, MigrationStatusDetails migrationStatusDetails = null, BackupConfiguration backupConfiguration = null, OfflineConfiguration offlineConfiguration = null)
        {
            return new DatabaseMigrationSqlVmProperties(
                ResourceType.SqlVm,
                scope,
                provisioningState,
                migrationStatus,
                startedOn,
                endedOn,
                sourceSqlConnection,
                sourceDatabaseName,
                sourceServerName,
                migrationService,
                migrationOperationId,
                migrationFailureError,
                targetDatabaseCollation,
                provisioningError,
                serializedAdditionalRawData: null,
                migrationStatusDetails,
                backupConfiguration,
                offlineConfiguration);
        }

        /// <summary> Initializes a new instance of <see cref="DataMigration.SqlMigrationServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Provisioning state to track the async operation status. </param>
        /// <param name="integrationRuntimeState"> Current state of the Integration runtime. </param>
        /// <returns> A new <see cref="DataMigration.SqlMigrationServiceData"/> instance for mocking. </returns>
        public static SqlMigrationServiceData SqlMigrationServiceData(ResourceIdentifier id = null, string name = null, Core.ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string provisioningState = null, string integrationRuntimeState = null)
        {
            tags ??= new Dictionary<string, string>();

            return new SqlMigrationServiceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                integrationRuntimeState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AuthenticationKeys"/>. </summary>
        /// <param name="authKey1"> The first authentication key. </param>
        /// <param name="authKey2"> The second authentication key. </param>
        /// <returns> A new <see cref="Models.AuthenticationKeys"/> instance for mocking. </returns>
        public static AuthenticationKeys AuthenticationKeys(string authKey1 = null, string authKey2 = null)
        {
            return new AuthenticationKeys(authKey1, authKey2, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseMigration"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties">
        /// Database Migration Resource properties.
        /// Please note <see cref="Models.DatabaseMigrationProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.DatabaseMigrationSqlDBProperties"/>, <see cref="Models.DatabaseMigrationSqlMIProperties"/> and <see cref="Models.DatabaseMigrationSqlVmProperties"/>.
        /// </param>
        /// <returns> A new <see cref="Models.DatabaseMigration"/> instance for mocking. </returns>
        public static DatabaseMigration DatabaseMigration(ResourceIdentifier id = null, string name = null, Core.ResourceType resourceType = default, SystemData systemData = null, DatabaseMigrationProperties properties = null)
        {
            return new DatabaseMigration(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.IntegrationRuntimeMonitoringData"/>. </summary>
        /// <param name="name"> The name of Integration Runtime. </param>
        /// <param name="nodes"> Integration Runtime node monitoring data. </param>
        /// <returns> A new <see cref="Models.IntegrationRuntimeMonitoringData"/> instance for mocking. </returns>
        public static IntegrationRuntimeMonitoringData IntegrationRuntimeMonitoringData(string name = null, IEnumerable<NodeMonitoringData> nodes = null)
        {
            nodes ??= new List<NodeMonitoringData>();

            return new IntegrationRuntimeMonitoringData(name, nodes?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NodeMonitoringData"/>. </summary>
        /// <param name="additionalProperties"> Unmatched properties from the message are deserialized in this collection. </param>
        /// <param name="nodeName"> Name of the integration runtime node. </param>
        /// <param name="availableMemoryInMB"> Available memory (MB) on the integration runtime node. </param>
        /// <param name="cpuUtilization"> CPU percentage on the integration runtime node. </param>
        /// <param name="concurrentJobsLimit"> Maximum concurrent jobs on the integration runtime node. </param>
        /// <param name="concurrentJobsRunning"> The number of jobs currently running on the integration runtime node. </param>
        /// <param name="maxConcurrentJobs"> The maximum concurrent jobs in this integration runtime. </param>
        /// <param name="sentBytes"> Sent bytes on the integration runtime node. </param>
        /// <param name="receivedBytes"> Received bytes on the integration runtime node. </param>
        /// <returns> A new <see cref="Models.NodeMonitoringData"/> instance for mocking. </returns>
        public static NodeMonitoringData NodeMonitoringData(IReadOnlyDictionary<string, BinaryData> additionalProperties = null, string nodeName = null, int? availableMemoryInMB = null, int? cpuUtilization = null, int? concurrentJobsLimit = null, int? concurrentJobsRunning = null, int? maxConcurrentJobs = null, double? sentBytes = null, double? receivedBytes = null)
        {
            additionalProperties ??= new Dictionary<string, BinaryData>();

            return new NodeMonitoringData(
                additionalProperties,
                nodeName,
                availableMemoryInMB,
                cpuUtilization,
                concurrentJobsLimit,
                concurrentJobsRunning,
                maxConcurrentJobs,
                sentBytes,
                receivedBytes,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceSku"/>. </summary>
        /// <param name="resourceType"> The type of resource the SKU applies to. </param>
        /// <param name="name"> The name of SKU. </param>
        /// <param name="tier"> Specifies the tier of DMS in a scale set. </param>
        /// <param name="size"> The Size of the SKU. </param>
        /// <param name="family"> The Family of this particular SKU. </param>
        /// <param name="kind"> The Kind of resources that are supported in this SKU. </param>
        /// <param name="capacity"> Not used. </param>
        /// <param name="locations"> The set of locations that the SKU is available. </param>
        /// <param name="apiVersions"> The api versions that support this SKU. </param>
        /// <param name="costs"> Metadata for retrieving price info. </param>
        /// <param name="capabilities"> A name value pair to describe the capability. </param>
        /// <param name="restrictions"> The restrictions because of which SKU cannot be used. This is empty if there are no restrictions. </param>
        /// <returns> A new <see cref="Models.ResourceSku"/> instance for mocking. </returns>
        public static ResourceSku ResourceSku(string resourceType = null, string name = null, string tier = null, string size = null, string family = null, string kind = null, ResourceSkuCapacity capacity = null, IEnumerable<string> locations = null, IEnumerable<string> apiVersions = null, IEnumerable<ResourceSkuCosts> costs = null, IEnumerable<ResourceSkuCapabilities> capabilities = null, IEnumerable<ResourceSkuRestrictions> restrictions = null)
        {
            locations ??= new List<string>();
            apiVersions ??= new List<string>();
            costs ??= new List<ResourceSkuCosts>();
            capabilities ??= new List<ResourceSkuCapabilities>();
            restrictions ??= new List<ResourceSkuRestrictions>();

            return new ResourceSku(
                resourceType,
                name,
                tier,
                size,
                family,
                kind,
                capacity,
                locations?.ToList(),
                apiVersions?.ToList(),
                costs?.ToList(),
                capabilities?.ToList(),
                restrictions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceSkuCapacity"/>. </summary>
        /// <param name="minimum"> The minimum capacity. </param>
        /// <param name="maximum"> The maximum capacity. </param>
        /// <param name="default"> The default capacity. </param>
        /// <param name="scaleType"> The scale type applicable to the SKU. </param>
        /// <returns> A new <see cref="Models.ResourceSkuCapacity"/> instance for mocking. </returns>
        public static ResourceSkuCapacity ResourceSkuCapacity(long? minimum = null, long? maximum = null, long? @default = null, ResourceSkuCapacityScaleType? scaleType = null)
        {
            return new ResourceSkuCapacity(minimum, maximum, @default, scaleType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceSkuCosts"/>. </summary>
        /// <param name="meterId"> Used for querying price from commerce. </param>
        /// <param name="quantity"> The multiplier is needed to extend the base metered cost. </param>
        /// <param name="extendedUnit"> An invariant to show the extended unit. </param>
        /// <returns> A new <see cref="Models.ResourceSkuCosts"/> instance for mocking. </returns>
        public static ResourceSkuCosts ResourceSkuCosts(string meterId = null, long? quantity = null, string extendedUnit = null)
        {
            return new ResourceSkuCosts(meterId, quantity, extendedUnit, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceSkuCapabilities"/>. </summary>
        /// <param name="name"> An invariant to describe the feature. </param>
        /// <param name="value"> An invariant if the feature is measured by quantity. </param>
        /// <returns> A new <see cref="Models.ResourceSkuCapabilities"/> instance for mocking. </returns>
        public static ResourceSkuCapabilities ResourceSkuCapabilities(string name = null, string value = null)
        {
            return new ResourceSkuCapabilities(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ResourceSkuRestrictions"/>. </summary>
        /// <param name="restrictionsType"> The type of restrictions. </param>
        /// <param name="values"> The value of restrictions. If the restriction type is set to location. This would be different locations where the SKU is restricted. </param>
        /// <param name="reasonCode"> The reason code for restriction. </param>
        /// <returns> A new <see cref="Models.ResourceSkuRestrictions"/> instance for mocking. </returns>
        public static ResourceSkuRestrictions ResourceSkuRestrictions(ResourceSkuRestrictionsType? restrictionsType = null, IEnumerable<string> values = null, ResourceSkuRestrictionsReasonCode? reasonCode = null)
        {
            values ??= new List<string>();

            return new ResourceSkuRestrictions(restrictionsType, values?.ToList(), reasonCode, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ODataError"/>. </summary>
        /// <param name="code"> The machine-readable description of the error, such as 'InvalidRequest' or 'InternalServerError'. </param>
        /// <param name="message"> The human-readable description of the error. </param>
        /// <param name="details"> Inner errors that caused this error. </param>
        /// <returns> A new <see cref="Models.ODataError"/> instance for mocking. </returns>
        public static ODataError ODataError(string code = null, string message = null, IEnumerable<ODataError> details = null)
        {
            details ??= new List<ODataError>();

            return new ODataError(code, message, details?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataMigration.DataMigrationServiceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> HTTP strong entity tag value. Ignored if submitted. </param>
        /// <param name="kind"> The resource kind. Only 'vm' (the default) is supported. </param>
        /// <param name="sku"> Service SKU. </param>
        /// <param name="provisioningState"> The resource's provisioning state. </param>
        /// <param name="publicKey"> The public key of the service, used to encrypt secrets sent to the service. </param>
        /// <param name="virtualSubnetId"> The ID of the Microsoft.Network/virtualNetworks/subnets resource to which the service should be joined. </param>
        /// <param name="virtualNicId"> The ID of the Microsoft.Network/networkInterfaces resource which the service have. </param>
        /// <param name="autoStopDelay"> The time delay before the service is auto-stopped when idle. </param>
        /// <param name="deleteResourcesOnStop"> Whether service resources should be deleted when stopped. (Turned on by default). </param>
        /// <returns> A new <see cref="DataMigration.DataMigrationServiceData"/> instance for mocking. </returns>
        public static DataMigrationServiceData DataMigrationServiceData(ResourceIdentifier id = null, string name = null, Core.ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, string kind = null, ServiceSku sku = null, ServiceProvisioningState? provisioningState = null, string publicKey = null, string virtualSubnetId = null, string virtualNicId = null, string autoStopDelay = null, bool? deleteResourcesOnStop = null)
        {
            tags ??= new Dictionary<string, string>();

            return new DataMigrationServiceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                kind,
                sku,
                provisioningState,
                publicKey,
                virtualSubnetId,
                virtualNicId,
                autoStopDelay,
                deleteResourcesOnStop,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataMigrationServiceStatusResponse"/>. </summary>
        /// <param name="agentVersion"> The DMS instance agent version. </param>
        /// <param name="agentConfiguration"> Agent Configuration. </param>
        /// <param name="status"> The machine-readable status, such as 'Initializing', 'Offline', 'Online', 'Deploying', 'Deleting', 'Stopped', 'Stopping', 'Starting', 'FailedToStart', 'FailedToStop' or 'Failed'. </param>
        /// <param name="vmSize"> The services virtual machine size, such as 'Standard_D2_v2'. </param>
        /// <param name="supportedTaskTypes"> The list of supported task types. </param>
        /// <returns> A new <see cref="Models.DataMigrationServiceStatusResponse"/> instance for mocking. </returns>
        public static DataMigrationServiceStatusResponse DataMigrationServiceStatusResponse(string agentVersion = null, BinaryData agentConfiguration = null, string status = null, string vmSize = null, IEnumerable<string> supportedTaskTypes = null)
        {
            supportedTaskTypes ??= new List<string>();

            return new DataMigrationServiceStatusResponse(
                agentVersion,
                agentConfiguration,
                status,
                vmSize,
                supportedTaskTypes?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableServiceSku"/>. </summary>
        /// <param name="resourceType"> The resource type, including the provider namespace. </param>
        /// <param name="sku"> SKU name, tier, etc. </param>
        /// <param name="capacity"> A description of the scaling capacities of the SKU. </param>
        /// <returns> A new <see cref="Models.AvailableServiceSku"/> instance for mocking. </returns>
        public static AvailableServiceSku AvailableServiceSku(string resourceType = null, AvailableServiceSkuSku sku = null, AvailableServiceSkuCapacity capacity = null)
        {
            return new AvailableServiceSku(resourceType, sku, capacity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableServiceSkuSku"/>. </summary>
        /// <param name="name"> The name of the SKU. </param>
        /// <param name="family"> SKU family. </param>
        /// <param name="size"> SKU size. </param>
        /// <param name="tier"> The tier of the SKU, such as "Basic", "General Purpose", or "Business Critical". </param>
        /// <returns> A new <see cref="Models.AvailableServiceSkuSku"/> instance for mocking. </returns>
        public static AvailableServiceSkuSku AvailableServiceSkuSku(string name = null, string family = null, string size = null, string tier = null)
        {
            return new AvailableServiceSkuSku(name, family, size, tier, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AvailableServiceSkuCapacity"/>. </summary>
        /// <param name="minimum"> The minimum capacity, usually 0 or 1. </param>
        /// <param name="maximum"> The maximum capacity. </param>
        /// <param name="default"> The default capacity. </param>
        /// <param name="scaleType"> The scalability approach. </param>
        /// <returns> A new <see cref="Models.AvailableServiceSkuCapacity"/> instance for mocking. </returns>
        public static AvailableServiceSkuCapacity AvailableServiceSkuCapacity(int? minimum = null, int? maximum = null, int? @default = null, ServiceScalability? scaleType = null)
        {
            return new AvailableServiceSkuCapacity(minimum, maximum, @default, scaleType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataMigration.ProjectTaskData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> HTTP strong entity tag value. This is ignored if submitted. </param>
        /// <param name="properties">
        /// Custom task properties
        /// Please note <see cref="Models.ProjectTaskProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ConnectToMongoDBTaskProperties"/>, <see cref="Models.ConnectToSourceMySqlTaskProperties"/>, <see cref="Models.ConnectToSourceOracleSyncTaskProperties"/>, <see cref="Models.ConnectToSourcePostgreSqlSyncTaskProperties"/>, <see cref="Models.ConnectToSourceSqlServerTaskProperties"/>, <see cref="Models.ConnectToSourceSqlServerSyncTaskProperties"/>, <see cref="Models.ConnectToTargetAzureDBForMySqlTaskProperties"/>, <see cref="Models.ConnectToTargetAzureDBForPostgreSqlSyncTaskProperties"/>, <see cref="Models.ConnectToTargetSqlMITaskProperties"/>, <see cref="Models.ConnectToTargetSqlMISyncTaskProperties"/>, <see cref="Models.ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskProperties"/>, <see cref="Models.ConnectToTargetSqlDBTaskProperties"/>, <see cref="Models.ConnectToTargetSqlDBSyncTaskProperties"/>, <see cref="Models.GetTdeCertificatesSqlTaskProperties"/>, <see cref="Models.GetUserTablesSqlSyncTaskProperties"/>, <see cref="Models.GetUserTablesSqlTaskProperties"/>, <see cref="Models.GetUserTablesMySqlTaskProperties"/>, <see cref="Models.GetUserTablesOracleTaskProperties"/>, <see cref="Models.GetUserTablesPostgreSqlTaskProperties"/>, <see cref="Models.MigrateMongoDBTaskProperties"/>, <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskProperties"/>, <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskProperties"/>, <see cref="Models.MigrateOracleAzureDBForPostgreSqlSyncTaskProperties"/>, <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskProperties"/>, <see cref="Models.MigrateSqlServerSqlDBSyncTaskProperties"/>, <see cref="Models.MigrateSqlServerSqlMITaskProperties"/>, <see cref="Models.MigrateSqlServerSqlMISyncTaskProperties"/>, <see cref="Models.MigrateSqlServerSqlDBTaskProperties"/>, <see cref="Models.MigrateSsisTaskProperties"/>, <see cref="Models.MigrateSchemaSqlServerSqlDBTaskProperties"/>, <see cref="Models.CheckOciDriverTaskProperties"/>, <see cref="Models.InstallOciDriverTaskProperties"/>, <see cref="Models.UploadOciDriverTaskProperties"/>, <see cref="Models.ValidateMongoDBTaskProperties"/>, <see cref="Models.ValidateOracleAzureDBForPostgreSqlSyncTaskProperties"/>, <see cref="Models.ValidateMigrationInputSqlServerSqlMITaskProperties"/>, <see cref="Models.ValidateMigrationInputSqlServerSqlMISyncTaskProperties"/> and <see cref="Models.ValidateMigrationInputSqlServerSqlDBSyncTaskProperties"/>.
        /// </param>
        /// <returns> A new <see cref="DataMigration.ProjectTaskData"/> instance for mocking. </returns>
        public static ProjectTaskData ProjectTaskData(ResourceIdentifier id = null, string name = null, Core.ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, ProjectTaskProperties properties = null)
        {
            return new ProjectTaskData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProjectTaskProperties"/>. </summary>
        /// <param name="taskType"> Task type. </param>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <returns> A new <see cref="Models.ProjectTaskProperties"/> instance for mocking. </returns>
        public static ProjectTaskProperties ProjectTaskProperties(string taskType = null, IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();

            return new UnknownProjectTaskProperties(
                taskType == null ? default : new TaskType(taskType),
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CommandProperties"/>. </summary>
        /// <param name="commandType"> Command type. </param>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the command. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.CommandProperties"/> instance for mocking. </returns>
        public static CommandProperties CommandProperties(string commandType = null, IEnumerable<ODataError> errors = null, CommandState? state = null)
        {
            errors ??= new List<ODataError>();

            return new UnknownCommandProperties(commandType == null ? default : new CommandType(commandType), errors?.ToList(), state, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NameAvailabilityResponse"/>. </summary>
        /// <param name="nameAvailable"> If true, the name is valid and available. If false, 'reason' describes why not. </param>
        /// <param name="reason"> The reason why the name is not available, if nameAvailable is false. </param>
        /// <param name="message"> The localized reason why the name is not available, if nameAvailable is false. </param>
        /// <returns> A new <see cref="Models.NameAvailabilityResponse"/> instance for mocking. </returns>
        public static NameAvailabilityResponse NameAvailabilityResponse(bool? nameAvailable = null, NameCheckFailureReason? reason = null, string message = null)
        {
            return new NameAvailabilityResponse(nameAvailable, reason, message, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataMigration.ProjectData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> HTTP strong entity tag value. This is ignored if submitted. </param>
        /// <param name="sourcePlatform"> Source platform for the project. </param>
        /// <param name="azureAuthenticationInfo"> Field that defines the Azure active directory application info, used to connect to the target Azure resource. </param>
        /// <param name="targetPlatform"> Target platform for the project. </param>
        /// <param name="createdOn"> UTC Date and time when project was created. </param>
        /// <param name="sourceConnectionInfo">
        /// Information for connecting to source
        /// Please note <see cref="ConnectionInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MISqlConnectionInfo"/>, <see cref="MongoDBConnectionInfo"/>, <see cref="MySqlConnectionInfo"/>, <see cref="OracleConnectionInfo"/>, <see cref="PostgreSqlConnectionInfo"/> and <see cref="SqlConnectionInfo"/>.
        /// </param>
        /// <param name="targetConnectionInfo">
        /// Information for connecting to target
        /// Please note <see cref="ConnectionInfo"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MISqlConnectionInfo"/>, <see cref="MongoDBConnectionInfo"/>, <see cref="MySqlConnectionInfo"/>, <see cref="OracleConnectionInfo"/>, <see cref="PostgreSqlConnectionInfo"/> and <see cref="SqlConnectionInfo"/>.
        /// </param>
        /// <param name="databasesInfo"> List of DatabaseInfo. </param>
        /// <param name="provisioningState"> The project's provisioning state. </param>
        /// <returns> A new <see cref="DataMigration.ProjectData"/> instance for mocking. </returns>
        public static ProjectData ProjectData(ResourceIdentifier id = null, string name = null, Core.ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, ProjectSourcePlatform? sourcePlatform = null, AzureActiveDirectoryApp azureAuthenticationInfo = null, ProjectTargetPlatform? targetPlatform = null, DateTimeOffset? createdOn = null, ConnectionInfo sourceConnectionInfo = null, ConnectionInfo targetConnectionInfo = null, IEnumerable<DatabaseInfo> databasesInfo = null, ProjectProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            databasesInfo ??= new List<DatabaseInfo>();

            return new ProjectData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                sourcePlatform,
                azureAuthenticationInfo,
                targetPlatform,
                createdOn,
                sourceConnectionInfo,
                targetConnectionInfo,
                databasesInfo?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.Quota"/>. </summary>
        /// <param name="currentValue"> The current value of the quota. If null or missing, the current value cannot be determined in the context of the request. </param>
        /// <param name="id"> The resource ID of the quota object. </param>
        /// <param name="limit"> The maximum value of the quota. If null or missing, the quota has no maximum, in which case it merely tracks usage. </param>
        /// <param name="name"> The name of the quota. </param>
        /// <param name="unit"> The unit for the quota, such as Count, Bytes, BytesPerSecond, etc. </param>
        /// <returns> A new <see cref="Models.Quota"/> instance for mocking. </returns>
        public static Quota Quota(double? currentValue = null, string id = null, double? limit = null, QuotaName name = null, string unit = null)
        {
            return new Quota(
                currentValue,
                id,
                limit,
                name,
                unit,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QuotaName"/>. </summary>
        /// <param name="localizedValue"> The localized name of the quota. </param>
        /// <param name="value"> The unlocalized name (or ID) of the quota. </param>
        /// <returns> A new <see cref="Models.QuotaName"/> instance for mocking. </returns>
        public static QuotaName QuotaName(string localizedValue = null, string value = null)
        {
            return new QuotaName(localizedValue, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="DataMigration.ProjectFileData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> HTTP strong entity tag value. This is ignored if submitted. </param>
        /// <param name="properties"> Custom file properties. </param>
        /// <returns> A new <see cref="DataMigration.ProjectFileData"/> instance for mocking. </returns>
        public static ProjectFileData ProjectFileData(ResourceIdentifier id = null, string name = null, Core.ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, ProjectFileProperties properties = null)
        {
            return new ProjectFileData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ProjectFileProperties"/>. </summary>
        /// <param name="extension"> Optional File extension. If submitted it should not have a leading period and must match the extension from filePath. </param>
        /// <param name="filePath"> Relative path of this file resource. This property can be set when creating or updating the file resource. </param>
        /// <param name="lastModified"> Modification DateTime. </param>
        /// <param name="mediaType"> File content type. This property can be modified to reflect the file content type. </param>
        /// <param name="size"> File size. </param>
        /// <returns> A new <see cref="Models.ProjectFileProperties"/> instance for mocking. </returns>
        public static ProjectFileProperties ProjectFileProperties(string extension = null, string filePath = null, DateTimeOffset? lastModified = null, string mediaType = null, long? size = null)
        {
            return new ProjectFileProperties(
                extension,
                filePath,
                lastModified,
                mediaType,
                size,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.FileStorageInfo"/>. </summary>
        /// <param name="uri"> A URI that can be used to access the file content. </param>
        /// <param name="headers"> Dictionary of &lt;string&gt;. </param>
        /// <returns> A new <see cref="Models.FileStorageInfo"/> instance for mocking. </returns>
        public static FileStorageInfo FileStorageInfo(Uri uri = null, IReadOnlyDictionary<string, string> headers = null)
        {
            headers ??= new Dictionary<string, string>();

            return new FileStorageInfo(uri, headers, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSyncCompleteCommandProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the command. This is ignored if submitted. </param>
        /// <param name="input"> Command input. </param>
        /// <param name="output"> Command output. This is ignored if submitted. </param>
        /// <param name="commandId"> Command id. </param>
        /// <returns> A new <see cref="Models.MigrateSyncCompleteCommandProperties"/> instance for mocking. </returns>
        public static MigrateSyncCompleteCommandProperties MigrateSyncCompleteCommandProperties(IEnumerable<ODataError> errors = null, CommandState? state = null, MigrateSyncCompleteCommandInput input = null, MigrateSyncCompleteCommandOutput output = null, string commandId = null)
        {
            errors ??= new List<ODataError>();

            return new MigrateSyncCompleteCommandProperties(
                CommandType.MigrateSyncCompleteDatabase,
                errors?.ToList(),
                state,
                serializedAdditionalRawData: null,
                input,
                output,
                commandId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSyncCompleteCommandOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="errors"> List of errors that happened during the command execution. </param>
        /// <returns> A new <see cref="Models.MigrateSyncCompleteCommandOutput"/> instance for mocking. </returns>
        public static MigrateSyncCompleteCommandOutput MigrateSyncCompleteCommandOutput(string id = null, IEnumerable<ReportableException> errors = null)
        {
            errors ??= new List<ReportableException>();

            return new MigrateSyncCompleteCommandOutput(id, errors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ReportableException"/>. </summary>
        /// <param name="message"> Error message. </param>
        /// <param name="actionableMessage"> Actionable steps for this exception. </param>
        /// <param name="filePath"> The path to the file where exception occurred. </param>
        /// <param name="lineNumber"> The line number where exception occurred. </param>
        /// <param name="hResult"> Coded numerical value that is assigned to a specific exception. </param>
        /// <param name="stackTrace"> Stack trace. </param>
        /// <returns> A new <see cref="Models.ReportableException"/> instance for mocking. </returns>
        public static ReportableException ReportableException(string message = null, string actionableMessage = null, string filePath = null, string lineNumber = null, int? hResult = null, string stackTrace = null)
        {
            return new ReportableException(
                message,
                actionableMessage,
                filePath,
                lineNumber,
                hResult,
                stackTrace,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMISyncCompleteCommandProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the command. This is ignored if submitted. </param>
        /// <param name="inputSourceDatabaseName"> Command input. </param>
        /// <param name="outputErrors"> Command output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.MigrateMISyncCompleteCommandProperties"/> instance for mocking. </returns>
        public static MigrateMISyncCompleteCommandProperties MigrateMISyncCompleteCommandProperties(IEnumerable<ODataError> errors = null, CommandState? state = null, string inputSourceDatabaseName = null, IEnumerable<ReportableException> outputErrors = null)
        {
            errors ??= new List<ODataError>();
            outputErrors ??= new List<ReportableException>();

            return new MigrateMISyncCompleteCommandProperties(
                CommandType.MigrateSqlServerAzureDBSqlMIComplete,
                errors?.ToList(),
                state,
                serializedAdditionalRawData: null,
                inputSourceDatabaseName != null ? new MigrateMISyncCompleteCommandInput(inputSourceDatabaseName, serializedAdditionalRawData: null) : null,
                outputErrors != null ? new MigrateMISyncCompleteCommandOutput(outputErrors?.ToList(), serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BackupSetInfo"/>. </summary>
        /// <param name="backupSetId"> Id for the set of backup files. </param>
        /// <param name="firstLsn"> First log sequence number of the backup file. </param>
        /// <param name="lastLsn"> Last log sequence number of the backup file. </param>
        /// <param name="lastModifiedOn"> Last modified time of the backup file in share location. </param>
        /// <param name="backupType"> Enum of the different backup types. </param>
        /// <param name="listOfBackupFiles"> List of files in the backup set. </param>
        /// <param name="databaseName"> Name of the database to which the backup set belongs. </param>
        /// <param name="backupStartOn"> Date and time that the backup operation began. </param>
        /// <param name="backupFinishedOn"> Date and time that the backup operation finished. </param>
        /// <param name="isBackupRestored"> Whether the backup set is restored or not. </param>
        /// <returns> A new <see cref="Models.BackupSetInfo"/> instance for mocking. </returns>
        public static BackupSetInfo BackupSetInfo(string backupSetId = null, string firstLsn = null, string lastLsn = null, DateTimeOffset? lastModifiedOn = null, BackupType? backupType = null, IEnumerable<BackupFileInfo> listOfBackupFiles = null, string databaseName = null, DateTimeOffset? backupStartOn = null, DateTimeOffset? backupFinishedOn = null, bool? isBackupRestored = null)
        {
            listOfBackupFiles ??= new List<BackupFileInfo>();

            return new BackupSetInfo(
                backupSetId,
                firstLsn,
                lastLsn,
                lastModifiedOn,
                backupType,
                listOfBackupFiles?.ToList(),
                databaseName,
                backupStartOn,
                backupFinishedOn,
                isBackupRestored,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.BackupFileInfo"/>. </summary>
        /// <param name="fileLocation"> Location of the backup file in shared folder. </param>
        /// <param name="familySequenceNumber"> Sequence number of the backup file in the backup set. </param>
        /// <param name="status"> Status of the backup file during migration. </param>
        /// <returns> A new <see cref="Models.BackupFileInfo"/> instance for mocking. </returns>
        public static BackupFileInfo BackupFileInfo(string fileLocation = null, int? familySequenceNumber = null, BackupFileStatus? status = null)
        {
            return new BackupFileInfo(fileLocation, familySequenceNumber, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.OrphanedUserInfo"/>. </summary>
        /// <param name="name"> Name of the orphaned user. </param>
        /// <param name="databaseName"> Parent database of the user. </param>
        /// <returns> A new <see cref="Models.OrphanedUserInfo"/> instance for mocking. </returns>
        public static OrphanedUserInfo OrphanedUserInfo(string name = null, string databaseName = null)
        {
            return new OrphanedUserInfo(name, databaseName, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceSqlServerTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Type of result - database level or task level. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceSqlServerTaskOutput"/> instance for mocking. </returns>
        public static ConnectToSourceSqlServerTaskOutput ConnectToSourceSqlServerTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownConnectToSourceSqlServerTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceSqlServerTaskOutputTaskLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databases"> Source databases as a map from database name to database id. </param>
        /// <param name="logins"> Source logins as a map from login name to login id. </param>
        /// <param name="agentJobs"> Source agent jobs as a map from agent job name to id. </param>
        /// <param name="databaseTdeCertificateMapping"> Mapping from database name to TDE certificate name, if applicable. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServerBrandVersion"> Source server brand version. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceSqlServerTaskOutputTaskLevel"/> instance for mocking. </returns>
        public static ConnectToSourceSqlServerTaskOutputTaskLevel ConnectToSourceSqlServerTaskOutputTaskLevel(string id = null, string databases = null, string logins = null, string agentJobs = null, string databaseTdeCertificateMapping = null, string sourceServerVersion = null, string sourceServerBrandVersion = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new ConnectToSourceSqlServerTaskOutputTaskLevel(
                id,
                "TaskLevelOutput",
                serializedAdditionalRawData: null,
                databases,
                logins,
                agentJobs,
                databaseTdeCertificateMapping,
                sourceServerVersion,
                sourceServerBrandVersion,
                validationErrors?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceSqlServerTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="name"> Database name. </param>
        /// <param name="sizeMB"> Size of the file in megabytes. </param>
        /// <param name="databaseFiles"> The list of database files. </param>
        /// <param name="compatibilityLevel"> SQL Server compatibility level of database. </param>
        /// <param name="databaseState"> State of the database. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceSqlServerTaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static ConnectToSourceSqlServerTaskOutputDatabaseLevel ConnectToSourceSqlServerTaskOutputDatabaseLevel(string id = null, string name = null, double? sizeMB = null, IEnumerable<DatabaseFileInfo> databaseFiles = null, DatabaseCompatLevel? compatibilityLevel = null, DatabaseState? databaseState = null)
        {
            databaseFiles ??= new List<DatabaseFileInfo>();

            return new ConnectToSourceSqlServerTaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                name,
                sizeMB,
                databaseFiles?.ToList(),
                compatibilityLevel,
                databaseState);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseFileInfo"/>. </summary>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="id"> Unique identifier for database file. </param>
        /// <param name="logicalName"> Logical name of the file. </param>
        /// <param name="physicalFullName"> Operating-system full path of the file. </param>
        /// <param name="restoreFullName"> Suggested full path of the file for restoring. </param>
        /// <param name="fileType"> Database file type. </param>
        /// <param name="sizeMB"> Size of the file in megabytes. </param>
        /// <returns> A new <see cref="Models.DatabaseFileInfo"/> instance for mocking. </returns>
        public static DatabaseFileInfo DatabaseFileInfo(string databaseName = null, string id = null, string logicalName = null, string physicalFullName = null, string restoreFullName = null, DatabaseFileType? fileType = null, double? sizeMB = null)
        {
            return new DatabaseFileInfo(
                databaseName,
                id,
                logicalName,
                physicalFullName,
                restoreFullName,
                fileType,
                sizeMB,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceSqlServerTaskOutputLoginLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="name"> Login name. </param>
        /// <param name="loginType"> The type of login. </param>
        /// <param name="defaultDatabase"> The default database for the login. </param>
        /// <param name="isEnabled"> The state of the login. </param>
        /// <param name="migrationEligibility"> Information about eligibility of login for migration. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceSqlServerTaskOutputLoginLevel"/> instance for mocking. </returns>
        public static ConnectToSourceSqlServerTaskOutputLoginLevel ConnectToSourceSqlServerTaskOutputLoginLevel(string id = null, string name = null, LoginType? loginType = null, string defaultDatabase = null, bool? isEnabled = null, MigrationEligibilityInfo migrationEligibility = null)
        {
            return new ConnectToSourceSqlServerTaskOutputLoginLevel(
                id,
                "LoginLevelOutput",
                serializedAdditionalRawData: null,
                name,
                loginType,
                defaultDatabase,
                isEnabled,
                migrationEligibility);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrationEligibilityInfo"/>. </summary>
        /// <param name="isEligibleForMigration"> Whether object is eligible for migration or not. </param>
        /// <param name="validationMessages"> Information about eligibility failure for the server object. </param>
        /// <returns> A new <see cref="Models.MigrationEligibilityInfo"/> instance for mocking. </returns>
        public static MigrationEligibilityInfo MigrationEligibilityInfo(bool? isEligibleForMigration = null, IEnumerable<string> validationMessages = null)
        {
            validationMessages ??= new List<string>();

            return new MigrationEligibilityInfo(isEligibleForMigration, validationMessages?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceSqlServerTaskOutputAgentJobLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="name"> Agent Job name. </param>
        /// <param name="jobCategory"> The type of Agent Job. </param>
        /// <param name="isEnabled"> The state of the original Agent Job. </param>
        /// <param name="jobOwner"> The owner of the Agent Job. </param>
        /// <param name="lastExecutedOn"> UTC Date and time when the Agent Job was last executed. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <param name="migrationEligibility"> Information about eligibility of agent job for migration. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceSqlServerTaskOutputAgentJobLevel"/> instance for mocking. </returns>
        public static ConnectToSourceSqlServerTaskOutputAgentJobLevel ConnectToSourceSqlServerTaskOutputAgentJobLevel(string id = null, string name = null, string jobCategory = null, bool? isEnabled = null, string jobOwner = null, DateTimeOffset? lastExecutedOn = null, IEnumerable<ReportableException> validationErrors = null, MigrationEligibilityInfo migrationEligibility = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new ConnectToSourceSqlServerTaskOutputAgentJobLevel(
                id,
                "AgentJobLevelOutput",
                serializedAdditionalRawData: null,
                name,
                jobCategory,
                isEnabled,
                jobOwner,
                lastExecutedOn,
                validationErrors?.ToList(),
                migrationEligibility);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourcePostgreSqlSyncTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="sourceServerVersion"> Version of the source server. </param>
        /// <param name="databases"> List of databases on source server. </param>
        /// <param name="sourceServerBrandVersion"> Source server brand version. </param>
        /// <param name="validationErrors"> Validation errors associated with the task. </param>
        /// <returns> A new <see cref="Models.ConnectToSourcePostgreSqlSyncTaskOutput"/> instance for mocking. </returns>
        public static ConnectToSourcePostgreSqlSyncTaskOutput ConnectToSourcePostgreSqlSyncTaskOutput(string id = null, string sourceServerVersion = null, IEnumerable<string> databases = null, string sourceServerBrandVersion = null, IEnumerable<ReportableException> validationErrors = null)
        {
            databases ??= new List<string>();
            validationErrors ??= new List<ReportableException>();

            return new ConnectToSourcePostgreSqlSyncTaskOutput(
                id,
                sourceServerVersion,
                databases?.ToList(),
                sourceServerBrandVersion,
                validationErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetAzureDBForMySqlTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="serverVersion"> Version of the target server. </param>
        /// <param name="databases"> List of databases on target server. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="validationErrors"> Validation errors associated with the task. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetAzureDBForMySqlTaskOutput"/> instance for mocking. </returns>
        public static ConnectToTargetAzureDBForMySqlTaskOutput ConnectToTargetAzureDBForMySqlTaskOutput(string id = null, string serverVersion = null, IEnumerable<string> databases = null, string targetServerBrandVersion = null, IEnumerable<ReportableException> validationErrors = null)
        {
            databases ??= new List<string>();
            validationErrors ??= new List<ReportableException>();

            return new ConnectToTargetAzureDBForMySqlTaskOutput(
                id,
                serverVersion,
                databases?.ToList(),
                targetServerBrandVersion,
                validationErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetSqlDBTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databases"> Source databases as a map from database name to database id. </param>
        /// <param name="targetServerVersion"> Version of the target server. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetSqlDBTaskOutput"/> instance for mocking. </returns>
        public static ConnectToTargetSqlDBTaskOutput ConnectToTargetSqlDBTaskOutput(string id = null, string databases = null, string targetServerVersion = null, string targetServerBrandVersion = null)
        {
            return new ConnectToTargetSqlDBTaskOutput(id, databases, targetServerVersion, targetServerBrandVersion, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetSqlMISyncTaskOutput"/>. </summary>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetSqlMISyncTaskOutput"/> instance for mocking. </returns>
        public static ConnectToTargetSqlMISyncTaskOutput ConnectToTargetSqlMISyncTaskOutput(string targetServerVersion = null, string targetServerBrandVersion = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new ConnectToTargetSqlMISyncTaskOutput(targetServerVersion, targetServerBrandVersion, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetSqlMITaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="logins"> List of logins on the target server. </param>
        /// <param name="agentJobs"> List of agent jobs on the target server. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetSqlMITaskOutput"/> instance for mocking. </returns>
        public static ConnectToTargetSqlMITaskOutput ConnectToTargetSqlMITaskOutput(string id = null, string targetServerVersion = null, string targetServerBrandVersion = null, IEnumerable<string> logins = null, IEnumerable<string> agentJobs = null, IEnumerable<ReportableException> validationErrors = null)
        {
            logins ??= new List<string>();
            agentJobs ??= new List<string>();
            validationErrors ??= new List<ReportableException>();

            return new ConnectToTargetSqlMITaskOutput(
                id,
                targetServerVersion,
                targetServerBrandVersion,
                logins?.ToList(),
                agentJobs?.ToList(),
                validationErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetAzureDBForPostgreSqlSyncTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="targetServerVersion"> Version of the target server. </param>
        /// <param name="databases"> List of databases on target server. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="validationErrors"> Validation errors associated with the task. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetAzureDBForPostgreSqlSyncTaskOutput"/> instance for mocking. </returns>
        public static ConnectToTargetAzureDBForPostgreSqlSyncTaskOutput ConnectToTargetAzureDBForPostgreSqlSyncTaskOutput(string id = null, string targetServerVersion = null, IEnumerable<string> databases = null, string targetServerBrandVersion = null, IEnumerable<ReportableException> validationErrors = null)
        {
            databases ??= new List<string>();
            validationErrors ??= new List<ReportableException>();

            return new ConnectToTargetAzureDBForPostgreSqlSyncTaskOutput(
                id,
                targetServerVersion,
                databases?.ToList(),
                targetServerBrandVersion,
                validationErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesMySqlTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databasesToTables"> Mapping from database name to list of tables. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.GetUserTablesMySqlTaskOutput"/> instance for mocking. </returns>
        public static GetUserTablesMySqlTaskOutput GetUserTablesMySqlTaskOutput(string id = null, string databasesToTables = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new GetUserTablesMySqlTaskOutput(id, databasesToTables, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseTable"/>. </summary>
        /// <param name="hasRows"> Indicates whether table is empty or not. </param>
        /// <param name="name"> Schema-qualified name of the table. </param>
        /// <returns> A new <see cref="Models.DatabaseTable"/> instance for mocking. </returns>
        public static DatabaseTable DatabaseTable(bool? hasRows = null, string name = null)
        {
            return new DatabaseTable(hasRows, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetTdeCertificatesSqlTaskOutput"/>. </summary>
        /// <param name="base64EncodedCertificates"> Mapping from certificate name to base 64 encoded format. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.GetTdeCertificatesSqlTaskOutput"/> instance for mocking. </returns>
        public static GetTdeCertificatesSqlTaskOutput GetTdeCertificatesSqlTaskOutput(string base64EncodedCertificates = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new GetTdeCertificatesSqlTaskOutput(base64EncodedCertificates, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesSqlSyncTaskOutput"/>. </summary>
        /// <param name="databasesToSourceTables"> Mapping from database name to list of source tables. </param>
        /// <param name="databasesToTargetTables"> Mapping from database name to list of target tables. </param>
        /// <param name="tableValidationErrors"> Mapping from database name to list of validation errors. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.GetUserTablesSqlSyncTaskOutput"/> instance for mocking. </returns>
        public static GetUserTablesSqlSyncTaskOutput GetUserTablesSqlSyncTaskOutput(string databasesToSourceTables = null, string databasesToTargetTables = null, string tableValidationErrors = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new GetUserTablesSqlSyncTaskOutput(databasesToSourceTables, databasesToTargetTables, tableValidationErrors, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesSqlTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databasesToTables"> Mapping from database name to list of tables. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.GetUserTablesSqlTaskOutput"/> instance for mocking. </returns>
        public static GetUserTablesSqlTaskOutput GetUserTablesSqlTaskOutput(string id = null, string databasesToTables = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new GetUserTablesSqlTaskOutput(id, databasesToTables, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSchemaSqlServerSqlDBTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel"/>, <see cref="Models.MigrateSchemaSqlTaskOutputError"/>, <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutputMigrationLevel"/> and <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutputError"/>.
        /// </param>
        /// <param name="createdOn"> DateTime in UTC when the task was created. </param>
        /// <param name="taskId"> Task id. </param>
        /// <param name="isCloneable"> whether the task can be cloned or not. </param>
        /// <returns> A new <see cref="Models.MigrateSchemaSqlServerSqlDBTaskProperties"/> instance for mocking. </returns>
        public static MigrateSchemaSqlServerSqlDBTaskProperties MigrateSchemaSqlServerSqlDBTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateSchemaSqlServerSqlDBTaskInput input = null, IEnumerable<MigrateSchemaSqlServerSqlDBTaskOutput> output = null, string createdOn = null, string taskId = null, bool? isCloneable = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigrateSchemaSqlServerSqlDBTaskOutput>();

            return new MigrateSchemaSqlServerSqlDBTaskProperties(
                TaskType.MigrateSchemaSqlServerSqlDB,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList(),
                createdOn,
                taskId,
                isCloneable);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutput"/> instance for mocking. </returns>
        public static MigrateSchemaSqlServerSqlDBTaskOutput MigrateSchemaSqlServerSqlDBTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigrateSchemaSqlServerSqlDBTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="state"> Overall state of the schema migration. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServerBrandVersion"> Source server brand version. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <returns> A new <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigrateSchemaSqlServerSqlDBTaskOutputMigrationLevel MigrateSchemaSqlServerSqlDBTaskOutputMigrationLevel(string id = null, MigrationState? state = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string sourceServerVersion = null, string sourceServerBrandVersion = null, string targetServerVersion = null, string targetServerBrandVersion = null)
        {
            return new MigrateSchemaSqlServerSqlDBTaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                state,
                startedOn,
                endedOn,
                sourceServerVersion,
                sourceServerBrandVersion,
                targetServerVersion,
                targetServerBrandVersion);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databaseName"> The name of the database. </param>
        /// <param name="state"> State of the schema migration for this database. </param>
        /// <param name="stage"> Schema migration stage for this database. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="databaseErrorResultPrefix"> Prefix string to use for querying errors for this database. </param>
        /// <param name="schemaErrorResultPrefix"> Prefix string to use for querying schema errors for this database. </param>
        /// <param name="numberOfSuccessfulOperations"> Number of successful operations for this database. </param>
        /// <param name="numberOfFailedOperations"> Number of failed operations for this database. </param>
        /// <param name="fileId"> Identifier for the file resource containing the schema of this database. </param>
        /// <returns> A new <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel(string id = null, string databaseName = null, MigrationState? state = null, SchemaMigrationStage? stage = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string databaseErrorResultPrefix = null, string schemaErrorResultPrefix = null, long? numberOfSuccessfulOperations = null, long? numberOfFailedOperations = null, string fileId = null)
        {
            return new MigrateSchemaSqlServerSqlDBTaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                databaseName,
                state,
                stage,
                startedOn,
                endedOn,
                databaseErrorResultPrefix,
                schemaErrorResultPrefix,
                numberOfSuccessfulOperations,
                numberOfFailedOperations,
                fileId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="commandText"> Schema command which failed. </param>
        /// <param name="errorText"> Reason of failure. </param>
        /// <returns> A new <see cref="Models.MigrateSchemaSqlServerSqlDBTaskOutputError"/> instance for mocking. </returns>
        public static MigrateSchemaSqlServerSqlDBTaskOutputError MigrateSchemaSqlServerSqlDBTaskOutputError(string id = null, string commandText = null, string errorText = null)
        {
            return new MigrateSchemaSqlServerSqlDBTaskOutputError(id, "SchemaErrorOutput", serializedAdditionalRawData: null, commandText, errorText);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSchemaSqlTaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="error"> Migration error. </param>
        /// <returns> A new <see cref="Models.MigrateSchemaSqlTaskOutputError"/> instance for mocking. </returns>
        public static MigrateSchemaSqlTaskOutputError MigrateSchemaSqlTaskOutputError(string id = null, ReportableException error = null)
        {
            return new MigrateSchemaSqlTaskOutputError(id, "ErrorOutput", serializedAdditionalRawData: null, error);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutput"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlSyncTaskOutput MigrateMySqlAzureDBForMySqlSyncTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigrateMySqlAzureDBForMySqlSyncTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServer"> Source server name. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServer"> Target server name. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlSyncTaskOutputMigrationLevel MigrateMySqlAzureDBForMySqlSyncTaskOutputMigrationLevel(string id = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string sourceServerVersion = null, string sourceServer = null, string targetServerVersion = null, string targetServer = null)
        {
            return new MigrateMySqlAzureDBForMySqlSyncTaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                startedOn,
                endedOn,
                sourceServerVersion,
                sourceServer,
                targetServerVersion,
                targetServer);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="migrationState"> Migration state that this database is in. </param>
        /// <param name="incomingChanges"> Number of incoming changes. </param>
        /// <param name="appliedChanges"> Number of applied changes. </param>
        /// <param name="cdcInsertCounter"> Number of cdc inserts. </param>
        /// <param name="cdcDeleteCounter"> Number of cdc deletes. </param>
        /// <param name="cdcUpdateCounter"> Number of cdc updates. </param>
        /// <param name="fullLoadCompletedTables"> Number of tables completed in full load. </param>
        /// <param name="fullLoadLoadingTables"> Number of tables loading in full load. </param>
        /// <param name="fullLoadQueuedTables"> Number of tables queued in full load. </param>
        /// <param name="fullLoadErroredTables"> Number of tables errored in full load. </param>
        /// <param name="initializationCompleted"> Indicates if initial load (full load) has been completed. </param>
        /// <param name="latency"> CDC apply latency. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseLevel MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseLevel(string id = null, string databaseName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, SyncDatabaseMigrationReportingState? migrationState = null, long? incomingChanges = null, long? appliedChanges = null, long? cdcInsertCounter = null, long? cdcDeleteCounter = null, long? cdcUpdateCounter = null, long? fullLoadCompletedTables = null, long? fullLoadLoadingTables = null, long? fullLoadQueuedTables = null, long? fullLoadErroredTables = null, bool? initializationCompleted = null, long? latency = null)
        {
            return new MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                databaseName,
                startedOn,
                endedOn,
                migrationState,
                incomingChanges,
                appliedChanges,
                cdcInsertCounter,
                cdcDeleteCounter,
                cdcUpdateCounter,
                fullLoadCompletedTables,
                fullLoadLoadingTables,
                fullLoadQueuedTables,
                fullLoadErroredTables,
                initializationCompleted,
                latency);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputTableLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="tableName"> Name of the table. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="cdcInsertCounter"> Number of applied inserts. </param>
        /// <param name="cdcUpdateCounter"> Number of applied updates. </param>
        /// <param name="cdcDeleteCounter"> Number of applied deletes. </param>
        /// <param name="fullLoadEstFinishOn"> Estimate to finish full load. </param>
        /// <param name="fullLoadStartedOn"> Full load start time. </param>
        /// <param name="fullLoadEndedOn"> Full load end time. </param>
        /// <param name="fullLoadTotalRows"> Number of rows applied in full load. </param>
        /// <param name="state"> Current state of the table migration. </param>
        /// <param name="totalChangesApplied"> Total number of applied changes. </param>
        /// <param name="dataErrorsCounter"> Number of data errors occurred. </param>
        /// <param name="lastModifiedOn"> Last modified time on target. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputTableLevel"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlSyncTaskOutputTableLevel MigrateMySqlAzureDBForMySqlSyncTaskOutputTableLevel(string id = null, string tableName = null, string databaseName = null, string cdcInsertCounter = null, string cdcUpdateCounter = null, string cdcDeleteCounter = null, DateTimeOffset? fullLoadEstFinishOn = null, DateTimeOffset? fullLoadStartedOn = null, DateTimeOffset? fullLoadEndedOn = null, long? fullLoadTotalRows = null, SyncTableMigrationState? state = null, long? totalChangesApplied = null, long? dataErrorsCounter = null, DateTimeOffset? lastModifiedOn = null)
        {
            return new MigrateMySqlAzureDBForMySqlSyncTaskOutputTableLevel(
                id,
                "TableLevelOutput",
                serializedAdditionalRawData: null,
                tableName,
                databaseName,
                cdcInsertCounter,
                cdcUpdateCounter,
                cdcDeleteCounter,
                fullLoadEstFinishOn,
                fullLoadStartedOn,
                fullLoadEndedOn,
                fullLoadTotalRows,
                state,
                totalChangesApplied,
                dataErrorsCounter,
                lastModifiedOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="error"> Migration error. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputError"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlSyncTaskOutputError MigrateMySqlAzureDBForMySqlSyncTaskOutputError(string id = null, ReportableException error = null)
        {
            return new MigrateMySqlAzureDBForMySqlSyncTaskOutputError(id, "ErrorOutput", serializedAdditionalRawData: null, error);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="errorMessage"> Error message. </param>
        /// <param name="events"> List of error events. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseError"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseError MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseError(string id = null, string errorMessage = null, IEnumerable<SyncMigrationDatabaseErrorEvent> events = null)
        {
            events ??= new List<SyncMigrationDatabaseErrorEvent>();

            return new MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseError(id, "DatabaseLevelErrorOutput", serializedAdditionalRawData: null, errorMessage, events?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.SyncMigrationDatabaseErrorEvent"/>. </summary>
        /// <param name="timestampString"> String value of timestamp. </param>
        /// <param name="eventTypeString"> Event type. </param>
        /// <param name="eventText"> Event text. </param>
        /// <returns> A new <see cref="Models.SyncMigrationDatabaseErrorEvent"/> instance for mocking. </returns>
        public static SyncMigrationDatabaseErrorEvent SyncMigrationDatabaseErrorEvent(string timestampString = null, string eventTypeString = null, string eventText = null)
        {
            return new SyncMigrationDatabaseErrorEvent(timestampString, eventTypeString, eventText, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskInput"/>. </summary>
        /// <param name="selectedDatabases"> Databases to migrate. </param>
        /// <param name="targetConnectionInfo"> Connection information for target Azure Database for PostgreSQL. </param>
        /// <param name="sourceConnectionInfo"> Connection information for source PostgreSQL. </param>
        /// <param name="encryptedKeyForSecureFields"> encrypted key for secure fields. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <returns> A new <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskInput"/> instance for mocking. </returns>
        public static MigratePostgreSqlAzureDBForPostgreSqlSyncTaskInput MigratePostgreSqlAzureDBForPostgreSqlSyncTaskInput(IEnumerable<MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput> selectedDatabases = null, PostgreSqlConnectionInfo targetConnectionInfo = null, PostgreSqlConnectionInfo sourceConnectionInfo = null, string encryptedKeyForSecureFields = null, DateTimeOffset? startedOn = null)
        {
            selectedDatabases ??= new List<MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput>();

            return new MigratePostgreSqlAzureDBForPostgreSqlSyncTaskInput(
                selectedDatabases?.ToList(),
                targetConnectionInfo,
                sourceConnectionInfo,
                encryptedKeyForSecureFields,
                startedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput"/>. </summary>
        /// <param name="name"> Name of the database. </param>
        /// <param name="id"> Result identifier. </param>
        /// <param name="targetDatabaseName"> Name of target database. Note: Target database will be truncated before starting migration. </param>
        /// <param name="migrationSetting"> Migration settings which tune the migration behavior. </param>
        /// <param name="sourceSetting"> Source settings to tune source endpoint migration behavior. </param>
        /// <param name="targetSetting"> Target settings to tune target endpoint migration behavior. </param>
        /// <param name="selectedTables"> Tables selected for migration. </param>
        /// <returns> A new <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput"/> instance for mocking. </returns>
        public static MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput(string name = null, string id = null, string targetDatabaseName = null, IDictionary<string, BinaryData> migrationSetting = null, IDictionary<string, string> sourceSetting = null, IDictionary<string, string> targetSetting = null, IEnumerable<MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseTableInput> selectedTables = null)
        {
            migrationSetting ??= new Dictionary<string, BinaryData>();
            sourceSetting ??= new Dictionary<string, string>();
            targetSetting ??= new Dictionary<string, string>();
            selectedTables ??= new List<MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseTableInput>();

            return new MigratePostgreSqlAzureDBForPostgreSqlSyncDatabaseInput(
                name,
                id,
                targetDatabaseName,
                migrationSetting,
                sourceSetting,
                targetSetting,
                selectedTables?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutput"/> instance for mocking. </returns>
        public static MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutput MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServer"> Source server name. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServer"> Target server name. </param>
        /// <param name="sourceServerType"> Source server type. </param>
        /// <param name="targetServerType"> Target server type. </param>
        /// <param name="state"> Migration status. </param>
        /// <param name="databaseCount"> Number of databases to include. </param>
        /// <returns> A new <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputMigrationLevel MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputMigrationLevel(string id = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string sourceServerVersion = null, string sourceServer = null, string targetServerVersion = null, string targetServer = null, ScenarioSource? sourceServerType = null, ScenarioTarget? targetServerType = null, ReplicateMigrationState? state = null, float? databaseCount = null)
        {
            return new MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                startedOn,
                endedOn,
                sourceServerVersion,
                sourceServer,
                targetServerVersion,
                targetServer,
                sourceServerType,
                targetServerType,
                state,
                databaseCount);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="migrationState"> Migration state that this database is in. </param>
        /// <param name="incomingChanges"> Number of incoming changes. </param>
        /// <param name="appliedChanges"> Number of applied changes. </param>
        /// <param name="cdcInsertCounter"> Number of cdc inserts. </param>
        /// <param name="cdcDeleteCounter"> Number of cdc deletes. </param>
        /// <param name="cdcUpdateCounter"> Number of cdc updates. </param>
        /// <param name="fullLoadCompletedTables"> Number of tables completed in full load. </param>
        /// <param name="fullLoadLoadingTables"> Number of tables loading in full load. </param>
        /// <param name="fullLoadQueuedTables"> Number of tables queued in full load. </param>
        /// <param name="fullLoadErroredTables"> Number of tables errored in full load. </param>
        /// <param name="initializationCompleted"> Indicates if initial load (full load) has been completed. </param>
        /// <param name="latency"> CDC apply latency. </param>
        /// <returns> A new <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseLevel MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseLevel(string id = null, string databaseName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, SyncDatabaseMigrationReportingState? migrationState = null, long? incomingChanges = null, long? appliedChanges = null, long? cdcInsertCounter = null, long? cdcDeleteCounter = null, long? cdcUpdateCounter = null, long? fullLoadCompletedTables = null, long? fullLoadLoadingTables = null, long? fullLoadQueuedTables = null, long? fullLoadErroredTables = null, bool? initializationCompleted = null, long? latency = null)
        {
            return new MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                databaseName,
                startedOn,
                endedOn,
                migrationState,
                incomingChanges,
                appliedChanges,
                cdcInsertCounter,
                cdcDeleteCounter,
                cdcUpdateCounter,
                fullLoadCompletedTables,
                fullLoadLoadingTables,
                fullLoadQueuedTables,
                fullLoadErroredTables,
                initializationCompleted,
                latency);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputTableLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="tableName"> Name of the table. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="cdcInsertCounter"> Number of applied inserts. </param>
        /// <param name="cdcUpdateCounter"> Number of applied updates. </param>
        /// <param name="cdcDeleteCounter"> Number of applied deletes. </param>
        /// <param name="fullLoadEstFinishOn"> Estimate to finish full load. </param>
        /// <param name="fullLoadStartedOn"> Full load start time. </param>
        /// <param name="fullLoadEndedOn"> Full load end time. </param>
        /// <param name="fullLoadTotalRows"> Number of rows applied in full load. </param>
        /// <param name="state"> Current state of the table migration. </param>
        /// <param name="totalChangesApplied"> Total number of applied changes. </param>
        /// <param name="dataErrorsCounter"> Number of data errors occurred. </param>
        /// <param name="lastModifiedOn"> Last modified time on target. </param>
        /// <returns> A new <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputTableLevel"/> instance for mocking. </returns>
        public static MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputTableLevel MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputTableLevel(string id = null, string tableName = null, string databaseName = null, long? cdcInsertCounter = null, long? cdcUpdateCounter = null, long? cdcDeleteCounter = null, DateTimeOffset? fullLoadEstFinishOn = null, DateTimeOffset? fullLoadStartedOn = null, DateTimeOffset? fullLoadEndedOn = null, long? fullLoadTotalRows = null, SyncTableMigrationState? state = null, long? totalChangesApplied = null, long? dataErrorsCounter = null, DateTimeOffset? lastModifiedOn = null)
        {
            return new MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputTableLevel(
                id,
                "TableLevelOutput",
                serializedAdditionalRawData: null,
                tableName,
                databaseName,
                cdcInsertCounter,
                cdcUpdateCounter,
                cdcDeleteCounter,
                fullLoadEstFinishOn,
                fullLoadStartedOn,
                fullLoadEndedOn,
                fullLoadTotalRows,
                state,
                totalChangesApplied,
                dataErrorsCounter,
                lastModifiedOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="error"> Migration error. </param>
        /// <param name="events"> List of error events. </param>
        /// <returns> A new <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputError"/> instance for mocking. </returns>
        public static MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputError MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputError(string id = null, ReportableException error = null, IEnumerable<SyncMigrationDatabaseErrorEvent> events = null)
        {
            events ??= new List<SyncMigrationDatabaseErrorEvent>();

            return new MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputError(id, "ErrorOutput", serializedAdditionalRawData: null, error, events?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="errorMessage"> Error message. </param>
        /// <param name="events"> List of error events. </param>
        /// <returns> A new <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseError"/> instance for mocking. </returns>
        public static MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseError MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseError(string id = null, string errorMessage = null, IEnumerable<SyncMigrationDatabaseErrorEvent> events = null)
        {
            events ??= new List<SyncMigrationDatabaseErrorEvent>();

            return new MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseError(id, "DatabaseLevelErrorOutput", serializedAdditionalRawData: null, errorMessage, events?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutput"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBSyncTaskOutput MigrateSqlServerSqlDBSyncTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigrateSqlServerSqlDBSyncTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServer"> Source server name. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServer"> Target server name. </param>
        /// <param name="databaseCount"> Count of databases. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBSyncTaskOutputMigrationLevel MigrateSqlServerSqlDBSyncTaskOutputMigrationLevel(string id = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string sourceServerVersion = null, string sourceServer = null, string targetServerVersion = null, string targetServer = null, int? databaseCount = null)
        {
            return new MigrateSqlServerSqlDBSyncTaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                startedOn,
                endedOn,
                sourceServerVersion,
                sourceServer,
                targetServerVersion,
                targetServer,
                databaseCount);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="migrationState"> Migration state that this database is in. </param>
        /// <param name="incomingChanges"> Number of incoming changes. </param>
        /// <param name="appliedChanges"> Number of applied changes. </param>
        /// <param name="cdcInsertCounter"> Number of cdc inserts. </param>
        /// <param name="cdcDeleteCounter"> Number of cdc deletes. </param>
        /// <param name="cdcUpdateCounter"> Number of cdc updates. </param>
        /// <param name="fullLoadCompletedTables"> Number of tables completed in full load. </param>
        /// <param name="fullLoadLoadingTables"> Number of tables loading in full load. </param>
        /// <param name="fullLoadQueuedTables"> Number of tables queued in full load. </param>
        /// <param name="fullLoadErroredTables"> Number of tables errored in full load. </param>
        /// <param name="initializationCompleted"> Indicates if initial load (full load) has been completed. </param>
        /// <param name="latency"> CDC apply latency. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBSyncTaskOutputDatabaseLevel MigrateSqlServerSqlDBSyncTaskOutputDatabaseLevel(string id = null, string databaseName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, SyncDatabaseMigrationReportingState? migrationState = null, long? incomingChanges = null, long? appliedChanges = null, long? cdcInsertCounter = null, long? cdcDeleteCounter = null, long? cdcUpdateCounter = null, long? fullLoadCompletedTables = null, long? fullLoadLoadingTables = null, long? fullLoadQueuedTables = null, long? fullLoadErroredTables = null, bool? initializationCompleted = null, long? latency = null)
        {
            return new MigrateSqlServerSqlDBSyncTaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                databaseName,
                startedOn,
                endedOn,
                migrationState,
                incomingChanges,
                appliedChanges,
                cdcInsertCounter,
                cdcDeleteCounter,
                cdcUpdateCounter,
                fullLoadCompletedTables,
                fullLoadLoadingTables,
                fullLoadQueuedTables,
                fullLoadErroredTables,
                initializationCompleted,
                latency);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputTableLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="tableName"> Name of the table. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="cdcInsertCounter"> Number of applied inserts. </param>
        /// <param name="cdcUpdateCounter"> Number of applied updates. </param>
        /// <param name="cdcDeleteCounter"> Number of applied deletes. </param>
        /// <param name="fullLoadEstFinishOn"> Estimate to finish full load. </param>
        /// <param name="fullLoadStartedOn"> Full load start time. </param>
        /// <param name="fullLoadEndedOn"> Full load end time. </param>
        /// <param name="fullLoadTotalRows"> Number of rows applied in full load. </param>
        /// <param name="state"> Current state of the table migration. </param>
        /// <param name="totalChangesApplied"> Total number of applied changes. </param>
        /// <param name="dataErrorsCounter"> Number of data errors occurred. </param>
        /// <param name="lastModifiedOn"> Last modified time on target. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputTableLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBSyncTaskOutputTableLevel MigrateSqlServerSqlDBSyncTaskOutputTableLevel(string id = null, string tableName = null, string databaseName = null, long? cdcInsertCounter = null, long? cdcUpdateCounter = null, long? cdcDeleteCounter = null, DateTimeOffset? fullLoadEstFinishOn = null, DateTimeOffset? fullLoadStartedOn = null, DateTimeOffset? fullLoadEndedOn = null, long? fullLoadTotalRows = null, SyncTableMigrationState? state = null, long? totalChangesApplied = null, long? dataErrorsCounter = null, DateTimeOffset? lastModifiedOn = null)
        {
            return new MigrateSqlServerSqlDBSyncTaskOutputTableLevel(
                id,
                "TableLevelOutput",
                serializedAdditionalRawData: null,
                tableName,
                databaseName,
                cdcInsertCounter,
                cdcUpdateCounter,
                cdcDeleteCounter,
                fullLoadEstFinishOn,
                fullLoadStartedOn,
                fullLoadEndedOn,
                fullLoadTotalRows,
                state,
                totalChangesApplied,
                dataErrorsCounter,
                lastModifiedOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="error"> Migration error. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputError"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBSyncTaskOutputError MigrateSqlServerSqlDBSyncTaskOutputError(string id = null, ReportableException error = null)
        {
            return new MigrateSqlServerSqlDBSyncTaskOutputError(id, "ErrorOutput", serializedAdditionalRawData: null, error);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputDatabaseError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="errorMessage"> Error message. </param>
        /// <param name="events"> List of error events. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputDatabaseError"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBSyncTaskOutputDatabaseError MigrateSqlServerSqlDBSyncTaskOutputDatabaseError(string id = null, string errorMessage = null, IEnumerable<SyncMigrationDatabaseErrorEvent> events = null)
        {
            events ??= new List<SyncMigrationDatabaseErrorEvent>();

            return new MigrateSqlServerSqlDBSyncTaskOutputDatabaseError(id, "DatabaseLevelErrorOutput", serializedAdditionalRawData: null, errorMessage, events?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBTaskOutput"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBTaskOutput MigrateSqlServerSqlDBTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigrateSqlServerSqlDBTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBTaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="durationInSeconds"> Duration of task execution in seconds. </param>
        /// <param name="status"> Current status of migration. </param>
        /// <param name="statusMessage"> Migration status message. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="databases"> Selected databases as a map from database name to database id. </param>
        /// <param name="databaseSummary"> Summary of database results in the migration. </param>
        /// <param name="migrationValidationResult"> Migration Validation Results. </param>
        /// <param name="migrationReportResult"> Migration Report Result, provides unique url for downloading your migration report. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServerBrandVersion"> Source server brand version. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBTaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBTaskOutputMigrationLevel MigrateSqlServerSqlDBTaskOutputMigrationLevel(string id = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, long? durationInSeconds = null, MigrationStatus? status = null, string statusMessage = null, string message = null, string databases = null, string databaseSummary = null, MigrationValidationResult migrationValidationResult = null, MigrationReportResult migrationReportResult = null, string sourceServerVersion = null, string sourceServerBrandVersion = null, string targetServerVersion = null, string targetServerBrandVersion = null, IEnumerable<ReportableException> exceptionsAndWarnings = null)
        {
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateSqlServerSqlDBTaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                startedOn,
                endedOn,
                durationInSeconds,
                status,
                statusMessage,
                message,
                databases,
                databaseSummary,
                migrationValidationResult,
                migrationReportResult,
                sourceServerVersion,
                sourceServerBrandVersion,
                targetServerVersion,
                targetServerBrandVersion,
                exceptionsAndWarnings?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrationValidationResult"/>. </summary>
        /// <param name="id"> Migration validation result identifier. </param>
        /// <param name="migrationId"> Migration Identifier. </param>
        /// <param name="summaryResults"> Validation summary results for each database. </param>
        /// <param name="status"> Current status of validation at the migration level. Status from the database validation result status will be aggregated here. </param>
        /// <returns> A new <see cref="Models.MigrationValidationResult"/> instance for mocking. </returns>
        public static MigrationValidationResult MigrationValidationResult(string id = null, string migrationId = null, IReadOnlyDictionary<string, MigrationValidationDatabaseSummaryResult> summaryResults = null, ValidationStatus? status = null)
        {
            summaryResults ??= new Dictionary<string, MigrationValidationDatabaseSummaryResult>();

            return new MigrationValidationResult(id, migrationId, summaryResults, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrationValidationDatabaseSummaryResult"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="migrationId"> Migration Identifier. </param>
        /// <param name="sourceDatabaseName"> Name of the source database. </param>
        /// <param name="targetDatabaseName"> Name of the target database. </param>
        /// <param name="startedOn"> Validation start time. </param>
        /// <param name="endedOn"> Validation end time. </param>
        /// <param name="status"> Current status of validation at the database level. </param>
        /// <returns> A new <see cref="Models.MigrationValidationDatabaseSummaryResult"/> instance for mocking. </returns>
        public static MigrationValidationDatabaseSummaryResult MigrationValidationDatabaseSummaryResult(string id = null, string migrationId = null, string sourceDatabaseName = null, string targetDatabaseName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, ValidationStatus? status = null)
        {
            return new MigrationValidationDatabaseSummaryResult(
                id,
                migrationId,
                sourceDatabaseName,
                targetDatabaseName,
                startedOn,
                endedOn,
                status,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrationReportResult"/>. </summary>
        /// <param name="id"> Migration validation result identifier. </param>
        /// <param name="reportUri"> The url of the report. </param>
        /// <returns> A new <see cref="Models.MigrationReportResult"/> instance for mocking. </returns>
        public static MigrationReportResult MigrationReportResult(string id = null, Uri reportUri = null)
        {
            return new MigrationReportResult(id, reportUri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databaseName"> Name of the item. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="stage"> Migration stage that this database is in. </param>
        /// <param name="statusMessage"> Status message. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="numberOfObjects"> Number of objects. </param>
        /// <param name="numberOfObjectsCompleted"> Number of successfully completed objects. </param>
        /// <param name="errorCount"> Number of database/object errors. </param>
        /// <param name="errorPrefix"> Wildcard string prefix to use for querying all errors of the item. </param>
        /// <param name="resultPrefix"> Wildcard string prefix to use for querying all sub-tem results of the item. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        /// <param name="objectSummary"> Summary of object results in the migration. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBTaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBTaskOutputDatabaseLevel MigrateSqlServerSqlDBTaskOutputDatabaseLevel(string id = null, string databaseName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, MigrationState? state = null, DatabaseMigrationStage? stage = null, string statusMessage = null, string message = null, long? numberOfObjects = null, long? numberOfObjectsCompleted = null, long? errorCount = null, string errorPrefix = null, string resultPrefix = null, IEnumerable<ReportableException> exceptionsAndWarnings = null, string objectSummary = null)
        {
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateSqlServerSqlDBTaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                databaseName,
                startedOn,
                endedOn,
                state,
                stage,
                statusMessage,
                message,
                numberOfObjects,
                numberOfObjectsCompleted,
                errorCount,
                errorPrefix,
                resultPrefix,
                exceptionsAndWarnings?.ToList(),
                objectSummary);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBTaskOutputTableLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="objectName"> Name of the item. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="statusMessage"> Status message. </param>
        /// <param name="itemsCount"> Number of items. </param>
        /// <param name="itemsCompletedCount"> Number of successfully completed items. </param>
        /// <param name="errorPrefix"> Wildcard string prefix to use for querying all errors of the item. </param>
        /// <param name="resultPrefix"> Wildcard string prefix to use for querying all sub-tem results of the item. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBTaskOutputTableLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBTaskOutputTableLevel MigrateSqlServerSqlDBTaskOutputTableLevel(string id = null, string objectName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, MigrationState? state = null, string statusMessage = null, long? itemsCount = null, long? itemsCompletedCount = null, string errorPrefix = null, string resultPrefix = null)
        {
            return new MigrateSqlServerSqlDBTaskOutputTableLevel(
                id,
                "TableLevelOutput",
                serializedAdditionalRawData: null,
                objectName,
                startedOn,
                endedOn,
                state,
                statusMessage,
                itemsCount,
                itemsCompletedCount,
                errorPrefix,
                resultPrefix);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBTaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="error"> Migration error. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBTaskOutputError"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBTaskOutputError MigrateSqlServerSqlDBTaskOutputError(string id = null, ReportableException error = null)
        {
            return new MigrateSqlServerSqlDBTaskOutputError(id, "ErrorOutput", serializedAdditionalRawData: null, error);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBTaskOutputValidationResult"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="migrationId"> Migration Identifier. </param>
        /// <param name="summaryResults"> Validation summary results for each database. </param>
        /// <param name="status"> Current status of validation at the migration level. Status from the database validation result status will be aggregated here. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBTaskOutputValidationResult"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBTaskOutputValidationResult MigrateSqlServerSqlDBTaskOutputValidationResult(string id = null, string migrationId = null, IReadOnlyDictionary<string, MigrationValidationDatabaseSummaryResult> summaryResults = null, ValidationStatus? status = null)
        {
            summaryResults ??= new Dictionary<string, MigrationValidationDatabaseSummaryResult>();

            return new MigrateSqlServerSqlDBTaskOutputValidationResult(
                id,
                "MigrationValidationOutput",
                serializedAdditionalRawData: null,
                migrationId,
                summaryResults,
                status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBTaskOutputDatabaseLevelValidationResult"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="migrationId"> Migration Identifier. </param>
        /// <param name="sourceDatabaseName"> Name of the source database. </param>
        /// <param name="targetDatabaseName"> Name of the target database. </param>
        /// <param name="startedOn"> Validation start time. </param>
        /// <param name="endedOn"> Validation end time. </param>
        /// <param name="dataIntegrityValidationResult"> Provides data integrity validation result between the source and target tables that are migrated. </param>
        /// <param name="schemaValidationResult"> Provides schema comparison result between source and target database. </param>
        /// <param name="queryAnalysisValidationResult"> Results of some of the query execution result between source and target database. </param>
        /// <param name="status"> Current status of validation at the database level. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBTaskOutputDatabaseLevelValidationResult"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBTaskOutputDatabaseLevelValidationResult MigrateSqlServerSqlDBTaskOutputDatabaseLevelValidationResult(string id = null, string migrationId = null, string sourceDatabaseName = null, string targetDatabaseName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, DataIntegrityValidationResult dataIntegrityValidationResult = null, SchemaComparisonValidationResult schemaValidationResult = null, QueryAnalysisValidationResult queryAnalysisValidationResult = null, ValidationStatus? status = null)
        {
            return new MigrateSqlServerSqlDBTaskOutputDatabaseLevelValidationResult(
                id,
                "MigrationDatabaseLevelValidationOutput",
                serializedAdditionalRawData: null,
                migrationId,
                sourceDatabaseName,
                targetDatabaseName,
                startedOn,
                endedOn,
                dataIntegrityValidationResult,
                schemaValidationResult,
                queryAnalysisValidationResult,
                status);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataIntegrityValidationResult"/>. </summary>
        /// <param name="failedObjects"> List of failed table names of source and target pair. </param>
        /// <param name="validationErrors"> List of errors that happened while performing data integrity validation. </param>
        /// <returns> A new <see cref="Models.DataIntegrityValidationResult"/> instance for mocking. </returns>
        public static DataIntegrityValidationResult DataIntegrityValidationResult(IReadOnlyDictionary<string, string> failedObjects = null, ValidationError validationErrors = null)
        {
            failedObjects ??= new Dictionary<string, string>();

            return new DataIntegrityValidationResult(failedObjects, validationErrors, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidationError"/>. </summary>
        /// <param name="text"> Error Text. </param>
        /// <param name="severity"> Severity of the error. </param>
        /// <returns> A new <see cref="Models.ValidationError"/> instance for mocking. </returns>
        public static ValidationError ValidationError(string text = null, Severity? severity = null)
        {
            return new ValidationError(text, severity, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SchemaComparisonValidationResult"/>. </summary>
        /// <param name="schemaDifferences"> List of schema differences between the source and target databases. </param>
        /// <param name="validationErrors"> List of errors that happened while performing schema compare validation. </param>
        /// <param name="sourceDatabaseObjectCount"> Count of source database objects. </param>
        /// <param name="targetDatabaseObjectCount"> Count of target database objects. </param>
        /// <returns> A new <see cref="Models.SchemaComparisonValidationResult"/> instance for mocking. </returns>
        public static SchemaComparisonValidationResult SchemaComparisonValidationResult(SchemaComparisonValidationResultType schemaDifferences = null, ValidationError validationErrors = null, IReadOnlyDictionary<string, long> sourceDatabaseObjectCount = null, IReadOnlyDictionary<string, long> targetDatabaseObjectCount = null)
        {
            sourceDatabaseObjectCount ??= new Dictionary<string, long>();
            targetDatabaseObjectCount ??= new Dictionary<string, long>();

            return new SchemaComparisonValidationResult(schemaDifferences, validationErrors, sourceDatabaseObjectCount, targetDatabaseObjectCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SchemaComparisonValidationResultType"/>. </summary>
        /// <param name="objectName"> Name of the object that has the difference. </param>
        /// <param name="objectType"> Type of the object that has the difference. e.g (Table/View/StoredProcedure). </param>
        /// <param name="updateAction"> Update action type with respect to target. </param>
        /// <returns> A new <see cref="Models.SchemaComparisonValidationResultType"/> instance for mocking. </returns>
        public static SchemaComparisonValidationResultType SchemaComparisonValidationResultType(string objectName = null, ObjectType? objectType = null, UpdateActionType? updateAction = null)
        {
            return new SchemaComparisonValidationResultType(objectName, objectType, updateAction, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QueryAnalysisValidationResult"/>. </summary>
        /// <param name="queryResults"> List of queries executed and it's execution results in source and target. </param>
        /// <param name="validationErrors"> Errors that are part of the execution. </param>
        /// <returns> A new <see cref="Models.QueryAnalysisValidationResult"/> instance for mocking. </returns>
        public static QueryAnalysisValidationResult QueryAnalysisValidationResult(QueryExecutionResult queryResults = null, ValidationError validationErrors = null)
        {
            return new QueryAnalysisValidationResult(queryResults, validationErrors, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.QueryExecutionResult"/>. </summary>
        /// <param name="queryText"> Query text retrieved from the source server. </param>
        /// <param name="statementsInBatch"> Total no. of statements in the batch. </param>
        /// <param name="sourceResult"> Query analysis result from the source. </param>
        /// <param name="targetResult"> Query analysis result from the target. </param>
        /// <returns> A new <see cref="Models.QueryExecutionResult"/> instance for mocking. </returns>
        public static QueryExecutionResult QueryExecutionResult(string queryText = null, long? statementsInBatch = null, ExecutionStatistics sourceResult = null, ExecutionStatistics targetResult = null)
        {
            return new QueryExecutionResult(queryText, statementsInBatch, sourceResult, targetResult, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ExecutionStatistics"/>. </summary>
        /// <param name="executionCount"> No. of query executions. </param>
        /// <param name="cpuTimeMs"> CPU Time in millisecond(s) for the query execution. </param>
        /// <param name="elapsedTimeMs"> Time taken in millisecond(s) for executing the query. </param>
        /// <param name="waitStats"> Dictionary of sql query execution wait types and the respective statistics. </param>
        /// <param name="hasErrors"> Indicates whether the query resulted in an error. </param>
        /// <param name="sqlErrors"> List of sql Errors. </param>
        /// <returns> A new <see cref="Models.ExecutionStatistics"/> instance for mocking. </returns>
        public static ExecutionStatistics ExecutionStatistics(long? executionCount = null, float? cpuTimeMs = null, float? elapsedTimeMs = null, IReadOnlyDictionary<string, WaitStatistics> waitStats = null, bool? hasErrors = null, IEnumerable<string> sqlErrors = null)
        {
            waitStats ??= new Dictionary<string, WaitStatistics>();
            sqlErrors ??= new List<string>();

            return new ExecutionStatistics(
                executionCount,
                cpuTimeMs,
                elapsedTimeMs,
                waitStats,
                hasErrors,
                sqlErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.WaitStatistics"/>. </summary>
        /// <param name="waitType"> Type of the Wait. </param>
        /// <param name="waitTimeMs"> Total wait time in millisecond(s). </param>
        /// <param name="waitCount"> Total no. of waits. </param>
        /// <returns> A new <see cref="Models.WaitStatistics"/> instance for mocking. </returns>
        public static WaitStatistics WaitStatistics(string waitType = null, float? waitTimeMs = null, long? waitCount = null)
        {
            return new WaitStatistics(waitType, waitTimeMs, waitCount, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMISyncTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMISyncTaskOutput"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMISyncTaskOutput MigrateSqlServerSqlMISyncTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigrateSqlServerSqlMISyncTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMISyncTaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databaseCount"> Count of databases. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="sourceServerName"> Source server name. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServerBrandVersion"> Source server brand version. </param>
        /// <param name="targetServerName"> Target server name. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="databaseErrorCount"> Number of database level errors. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMISyncTaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMISyncTaskOutputMigrationLevel MigrateSqlServerSqlMISyncTaskOutputMigrationLevel(string id = null, int? databaseCount = null, MigrationState? state = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string sourceServerName = null, string sourceServerVersion = null, string sourceServerBrandVersion = null, string targetServerName = null, string targetServerVersion = null, string targetServerBrandVersion = null, int? databaseErrorCount = null)
        {
            return new MigrateSqlServerSqlMISyncTaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                databaseCount,
                state,
                startedOn,
                endedOn,
                sourceServerName,
                sourceServerVersion,
                sourceServerBrandVersion,
                targetServerName,
                targetServerVersion,
                targetServerBrandVersion,
                databaseErrorCount);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="sourceDatabaseName"> Name of the database. </param>
        /// <param name="migrationState"> Current state of database. </param>
        /// <param name="startedOn"> Database migration start time. </param>
        /// <param name="endedOn"> Database migration end time. </param>
        /// <param name="fullBackupSetInfo"> Details of full backup set. </param>
        /// <param name="lastRestoredBackupSetInfo"> Last applied backup set information. </param>
        /// <param name="activeBackupSets"> Backup sets that are currently active (Either being uploaded or getting restored). </param>
        /// <param name="containerName"> Name of container created in the Azure Storage account where backups are copied to. </param>
        /// <param name="errorPrefix"> prefix string to use for querying errors for this database. </param>
        /// <param name="isFullBackupRestored"> Whether full backup has been applied to the target database or not. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel(string id = null, string sourceDatabaseName = null, DatabaseMigrationState? migrationState = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, BackupSetInfo fullBackupSetInfo = null, BackupSetInfo lastRestoredBackupSetInfo = null, IEnumerable<BackupSetInfo> activeBackupSets = null, string containerName = null, string errorPrefix = null, bool? isFullBackupRestored = null, IEnumerable<ReportableException> exceptionsAndWarnings = null)
        {
            activeBackupSets ??= new List<BackupSetInfo>();
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                sourceDatabaseName,
                migrationState,
                startedOn,
                endedOn,
                fullBackupSetInfo,
                lastRestoredBackupSetInfo,
                activeBackupSets?.ToList(),
                containerName,
                errorPrefix,
                isFullBackupRestored,
                exceptionsAndWarnings?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMISyncTaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="error"> Migration error. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMISyncTaskOutputError"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMISyncTaskOutputError MigrateSqlServerSqlMISyncTaskOutputError(string id = null, ReportableException error = null)
        {
            return new MigrateSqlServerSqlMISyncTaskOutputError(id, "ErrorOutput", serializedAdditionalRawData: null, error);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMITaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMITaskOutput"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMITaskOutput MigrateSqlServerSqlMITaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigrateSqlServerSqlMITaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMITaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="status"> Current status of migration. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="agentJobs"> Selected agent jobs as a map from name to id. </param>
        /// <param name="logins"> Selected logins as a map from name to id. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="serverRoleResults"> Map of server role migration results. </param>
        /// <param name="orphanedUsersInfo"> List of orphaned users. </param>
        /// <param name="databases"> Selected databases as a map from database name to database id. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServerBrandVersion"> Source server brand version. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMITaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMITaskOutputMigrationLevel MigrateSqlServerSqlMITaskOutputMigrationLevel(string id = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, MigrationStatus? status = null, MigrationState? state = null, string agentJobs = null, string logins = null, string message = null, string serverRoleResults = null, IEnumerable<OrphanedUserInfo> orphanedUsersInfo = null, string databases = null, string sourceServerVersion = null, string sourceServerBrandVersion = null, string targetServerVersion = null, string targetServerBrandVersion = null, IEnumerable<ReportableException> exceptionsAndWarnings = null)
        {
            orphanedUsersInfo ??= new List<OrphanedUserInfo>();
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateSqlServerSqlMITaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                startedOn,
                endedOn,
                status,
                state,
                agentJobs,
                logins,
                message,
                serverRoleResults,
                orphanedUsersInfo?.ToList(),
                databases,
                sourceServerVersion,
                sourceServerBrandVersion,
                targetServerVersion,
                targetServerBrandVersion,
                exceptionsAndWarnings?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMITaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="sizeMB"> Size of the database in megabytes. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="stage"> Current stage of migration. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMITaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMITaskOutputDatabaseLevel MigrateSqlServerSqlMITaskOutputDatabaseLevel(string id = null, string databaseName = null, double? sizeMB = null, MigrationState? state = null, DatabaseMigrationStage? stage = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string message = null, IEnumerable<ReportableException> exceptionsAndWarnings = null)
        {
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateSqlServerSqlMITaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                databaseName,
                sizeMB,
                state,
                stage,
                startedOn,
                endedOn,
                message,
                exceptionsAndWarnings?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMITaskOutputAgentJobLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="name"> Agent Job name. </param>
        /// <param name="isEnabled"> The state of the original Agent Job. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="exceptionsAndWarnings"> Migration errors and warnings per job. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMITaskOutputAgentJobLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMITaskOutputAgentJobLevel MigrateSqlServerSqlMITaskOutputAgentJobLevel(string id = null, string name = null, bool? isEnabled = null, MigrationState? state = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string message = null, IEnumerable<ReportableException> exceptionsAndWarnings = null)
        {
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateSqlServerSqlMITaskOutputAgentJobLevel(
                id,
                "AgentJobLevelOutput",
                serializedAdditionalRawData: null,
                name,
                isEnabled,
                state,
                startedOn,
                endedOn,
                message,
                exceptionsAndWarnings?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMITaskOutputLoginLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="loginName"> Login name. </param>
        /// <param name="state"> Current state of login. </param>
        /// <param name="stage"> Current stage of login. </param>
        /// <param name="startedOn"> Login migration start time. </param>
        /// <param name="endedOn"> Login migration end time. </param>
        /// <param name="message"> Login migration progress message. </param>
        /// <param name="exceptionsAndWarnings"> Login migration errors and warnings per login. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMITaskOutputLoginLevel"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMITaskOutputLoginLevel MigrateSqlServerSqlMITaskOutputLoginLevel(string id = null, string loginName = null, MigrationState? state = null, LoginMigrationStage? stage = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string message = null, IEnumerable<ReportableException> exceptionsAndWarnings = null)
        {
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateSqlServerSqlMITaskOutputLoginLevel(
                id,
                "LoginLevelOutput",
                serializedAdditionalRawData: null,
                loginName,
                state,
                stage,
                startedOn,
                endedOn,
                message,
                exceptionsAndWarnings?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMITaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="error"> Migration error. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMITaskOutputError"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMITaskOutputError MigrateSqlServerSqlMITaskOutputError(string id = null, ReportableException error = null)
        {
            return new MigrateSqlServerSqlMITaskOutputError(id, "ErrorOutput", serializedAdditionalRawData: null, error);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSsisTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigrateSsisTaskOutput"/> instance for mocking. </returns>
        public static MigrateSsisTaskOutput MigrateSsisTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigrateSsisTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSsisTaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="status"> Current status of migration. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServerBrandVersion"> Source server brand version. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        /// <param name="stage"> Stage of SSIS migration. </param>
        /// <returns> A new <see cref="Models.MigrateSsisTaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigrateSsisTaskOutputMigrationLevel MigrateSsisTaskOutputMigrationLevel(string id = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, MigrationStatus? status = null, string message = null, string sourceServerVersion = null, string sourceServerBrandVersion = null, string targetServerVersion = null, string targetServerBrandVersion = null, IEnumerable<ReportableException> exceptionsAndWarnings = null, SsisMigrationStage? stage = null)
        {
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateSsisTaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                startedOn,
                endedOn,
                status,
                message,
                sourceServerVersion,
                sourceServerBrandVersion,
                targetServerVersion,
                targetServerBrandVersion,
                exceptionsAndWarnings?.ToList(),
                stage);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSsisTaskOutputProjectLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="folderName"> Name of the folder. </param>
        /// <param name="projectName"> Name of the project. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="stage"> Stage of SSIS migration. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        /// <returns> A new <see cref="Models.MigrateSsisTaskOutputProjectLevel"/> instance for mocking. </returns>
        public static MigrateSsisTaskOutputProjectLevel MigrateSsisTaskOutputProjectLevel(string id = null, string folderName = null, string projectName = null, MigrationState? state = null, SsisMigrationStage? stage = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string message = null, IEnumerable<ReportableException> exceptionsAndWarnings = null)
        {
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateSsisTaskOutputProjectLevel(
                id,
                "SsisProjectLevelOutput",
                serializedAdditionalRawData: null,
                folderName,
                projectName,
                state,
                stage,
                startedOn,
                endedOn,
                message,
                exceptionsAndWarnings?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBCancelCommand"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the command. This is ignored if submitted. </param>
        /// <param name="inputObjectName"> Command input. </param>
        /// <returns> A new <see cref="Models.MongoDBCancelCommand"/> instance for mocking. </returns>
        public static MongoDBCancelCommand MongoDBCancelCommand(IEnumerable<ODataError> errors = null, CommandState? state = null, string inputObjectName = null)
        {
            errors ??= new List<ODataError>();

            return new MongoDBCancelCommand(CommandType.Cancel, errors?.ToList(), state, serializedAdditionalRawData: null, inputObjectName != null ? new MongoDBCommandInput(inputObjectName, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBClusterInfo"/>. </summary>
        /// <param name="databases"> A list of non-system databases in the cluster. </param>
        /// <param name="supportsSharding"> Whether the cluster supports sharded collections. </param>
        /// <param name="clusterType"> The type of data source. </param>
        /// <param name="version"> The version of the data source in the form x.y.z (e.g. 3.6.7). Not used if Type is BlobContainer. </param>
        /// <returns> A new <see cref="Models.MongoDBClusterInfo"/> instance for mocking. </returns>
        public static MongoDBClusterInfo MongoDBClusterInfo(IEnumerable<MongoDBDatabaseInfo> databases = null, bool supportsSharding = default, MongoDBClusterType clusterType = default, string version = null)
        {
            databases ??= new List<MongoDBDatabaseInfo>();

            return new MongoDBClusterInfo(databases?.ToList(), supportsSharding, clusterType, version, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBDatabaseInfo"/>. </summary>
        /// <param name="averageDocumentSize"> The average document size, or -1 if the average size is unknown. </param>
        /// <param name="dataSize"> The estimated total data size, in bytes, or -1 if the size is unknown. </param>
        /// <param name="documentCount"> The estimated total number of documents, or -1 if the document count is unknown. </param>
        /// <param name="name"> The unqualified name of the database or collection. </param>
        /// <param name="qualifiedName"> The qualified name of the database or collection. For a collection, this is the database-qualified name. </param>
        /// <param name="collections"> A list of supported collections in a MongoDB database. </param>
        /// <param name="supportsSharding"> Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if necessary. </param>
        /// <returns> A new <see cref="Models.MongoDBDatabaseInfo"/> instance for mocking. </returns>
        public static MongoDBDatabaseInfo MongoDBDatabaseInfo(long averageDocumentSize = default, long dataSize = default, long documentCount = default, string name = null, string qualifiedName = null, IEnumerable<MongoDBCollectionInfo> collections = null, bool supportsSharding = default)
        {
            collections ??= new List<MongoDBCollectionInfo>();

            return new MongoDBDatabaseInfo(
                averageDocumentSize,
                dataSize,
                documentCount,
                name,
                qualifiedName,
                serializedAdditionalRawData: null,
                collections?.ToList(),
                supportsSharding);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBCollectionInfo"/>. </summary>
        /// <param name="averageDocumentSize"> The average document size, or -1 if the average size is unknown. </param>
        /// <param name="dataSize"> The estimated total data size, in bytes, or -1 if the size is unknown. </param>
        /// <param name="documentCount"> The estimated total number of documents, or -1 if the document count is unknown. </param>
        /// <param name="name"> The unqualified name of the database or collection. </param>
        /// <param name="qualifiedName"> The qualified name of the database or collection. For a collection, this is the database-qualified name. </param>
        /// <param name="databaseName"> The name of the database containing the collection. </param>
        /// <param name="isCapped"> Whether the collection is a capped collection (i.e. whether it has a fixed size and acts like a circular buffer). </param>
        /// <param name="isSystemCollection"> Whether the collection is system collection. </param>
        /// <param name="isView"> Whether the collection is a view of another collection. </param>
        /// <param name="shardKey"> The shard key on the collection, or null if the collection is not sharded. </param>
        /// <param name="supportsSharding"> Whether the database has sharding enabled. Note that the migration task will enable sharding on the target if necessary. </param>
        /// <param name="viewOf"> The name of the collection that this is a view of, if IsView is true. </param>
        /// <returns> A new <see cref="Models.MongoDBCollectionInfo"/> instance for mocking. </returns>
        public static MongoDBCollectionInfo MongoDBCollectionInfo(long averageDocumentSize = default, long dataSize = default, long documentCount = default, string name = null, string qualifiedName = null, string databaseName = null, bool isCapped = default, bool isSystemCollection = default, bool isView = default, MongoDBShardKeyInfo shardKey = null, bool supportsSharding = default, string viewOf = null)
        {
            return new MongoDBCollectionInfo(
                averageDocumentSize,
                dataSize,
                documentCount,
                name,
                qualifiedName,
                serializedAdditionalRawData: null,
                databaseName,
                isCapped,
                isSystemCollection,
                isView,
                shardKey,
                supportsSharding,
                viewOf);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBShardKeyInfo"/>. </summary>
        /// <param name="fields"> The fields within the shard key. </param>
        /// <param name="isUnique"> Whether the shard key is unique. </param>
        /// <returns> A new <see cref="Models.MongoDBShardKeyInfo"/> instance for mocking. </returns>
        public static MongoDBShardKeyInfo MongoDBShardKeyInfo(IEnumerable<MongoDBShardKeyField> fields = null, bool isUnique = default)
        {
            fields ??= new List<MongoDBShardKeyField>();

            return new MongoDBShardKeyInfo(fields?.ToList(), isUnique, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBObjectInfo"/>. </summary>
        /// <param name="averageDocumentSize"> The average document size, or -1 if the average size is unknown. </param>
        /// <param name="dataSize"> The estimated total data size, in bytes, or -1 if the size is unknown. </param>
        /// <param name="documentCount"> The estimated total number of documents, or -1 if the document count is unknown. </param>
        /// <param name="name"> The unqualified name of the database or collection. </param>
        /// <param name="qualifiedName"> The qualified name of the database or collection. For a collection, this is the database-qualified name. </param>
        /// <returns> A new <see cref="Models.MongoDBObjectInfo"/> instance for mocking. </returns>
        public static MongoDBObjectInfo MongoDBObjectInfo(long averageDocumentSize = default, long dataSize = default, long documentCount = default, string name = null, string qualifiedName = null)
        {
            return new MongoDBObjectInfo(
                averageDocumentSize,
                dataSize,
                documentCount,
                name,
                qualifiedName,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBCollectionProgress"/>. </summary>
        /// <param name="bytesCopied"> The number of document bytes copied during the Copying stage. </param>
        /// <param name="documentsCopied"> The number of documents copied during the Copying stage. </param>
        /// <param name="elapsedTime"> The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format). </param>
        /// <param name="errors"> The errors and warnings that have occurred for the current object. The keys are the error codes. </param>
        /// <param name="eventsPending"> The number of oplog events awaiting replay. </param>
        /// <param name="eventsReplayed"> The number of oplog events replayed so far. </param>
        /// <param name="lastEventOn"> The timestamp of the last oplog event received, or null if no oplog event has been received yet. </param>
        /// <param name="lastReplayOn"> The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet. </param>
        /// <param name="name"> The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="qualifiedName"> The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="state"></param>
        /// <param name="totalBytes"> The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown. </param>
        /// <param name="totalDocuments"> The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown. </param>
        /// <returns> A new <see cref="Models.MongoDBCollectionProgress"/> instance for mocking. </returns>
        public static MongoDBCollectionProgress MongoDBCollectionProgress(long bytesCopied = default, long documentsCopied = default, string elapsedTime = null, IReadOnlyDictionary<string, MongoDBError> errors = null, long eventsPending = default, long eventsReplayed = default, DateTimeOffset? lastEventOn = null, DateTimeOffset? lastReplayOn = null, string name = null, string qualifiedName = null, MongoDBMigrationState state = default, long totalBytes = default, long totalDocuments = default)
        {
            errors ??= new Dictionary<string, MongoDBError>();

            return new MongoDBCollectionProgress(
                bytesCopied,
                documentsCopied,
                elapsedTime,
                errors,
                eventsPending,
                eventsReplayed,
                lastEventOn,
                lastReplayOn,
                name,
                qualifiedName,
                MongoDBProgressResultType.Collection,
                state,
                totalBytes,
                totalDocuments,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBProgress"/>. </summary>
        /// <param name="bytesCopied"> The number of document bytes copied during the Copying stage. </param>
        /// <param name="documentsCopied"> The number of documents copied during the Copying stage. </param>
        /// <param name="elapsedTime"> The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format). </param>
        /// <param name="errors"> The errors and warnings that have occurred for the current object. The keys are the error codes. </param>
        /// <param name="eventsPending"> The number of oplog events awaiting replay. </param>
        /// <param name="eventsReplayed"> The number of oplog events replayed so far. </param>
        /// <param name="lastEventOn"> The timestamp of the last oplog event received, or null if no oplog event has been received yet. </param>
        /// <param name="lastReplayOn"> The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet. </param>
        /// <param name="name"> The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="qualifiedName"> The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="resultType"> The type of progress object. </param>
        /// <param name="state"></param>
        /// <param name="totalBytes"> The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown. </param>
        /// <param name="totalDocuments"> The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown. </param>
        /// <returns> A new <see cref="Models.MongoDBProgress"/> instance for mocking. </returns>
        public static MongoDBProgress MongoDBProgress(long bytesCopied = default, long documentsCopied = default, string elapsedTime = null, IReadOnlyDictionary<string, MongoDBError> errors = null, long eventsPending = default, long eventsReplayed = default, DateTimeOffset? lastEventOn = null, DateTimeOffset? lastReplayOn = null, string name = null, string qualifiedName = null, string resultType = null, MongoDBMigrationState state = default, long totalBytes = default, long totalDocuments = default)
        {
            errors ??= new Dictionary<string, MongoDBError>();

            return new UnknownMongoDBProgress(
                bytesCopied,
                documentsCopied,
                elapsedTime,
                errors,
                eventsPending,
                eventsReplayed,
                lastEventOn,
                lastReplayOn,
                name,
                qualifiedName,
                resultType == null ? default : new MongoDBProgressResultType(resultType),
                state,
                totalBytes,
                totalDocuments,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBError"/>. </summary>
        /// <param name="code"> The non-localized, machine-readable code that describes the error or warning. </param>
        /// <param name="count"> The number of times the error or warning has occurred. </param>
        /// <param name="message"> The localized, human-readable message that describes the error or warning. </param>
        /// <param name="errorType"> The type of error or warning. </param>
        /// <returns> A new <see cref="Models.MongoDBError"/> instance for mocking. </returns>
        public static MongoDBError MongoDBError(string code = null, int? count = null, string message = null, MongoDBErrorType? errorType = null)
        {
            return new MongoDBError(code, count, message, errorType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBDatabaseProgress"/>. </summary>
        /// <param name="bytesCopied"> The number of document bytes copied during the Copying stage. </param>
        /// <param name="documentsCopied"> The number of documents copied during the Copying stage. </param>
        /// <param name="elapsedTime"> The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format). </param>
        /// <param name="errors"> The errors and warnings that have occurred for the current object. The keys are the error codes. </param>
        /// <param name="eventsPending"> The number of oplog events awaiting replay. </param>
        /// <param name="eventsReplayed"> The number of oplog events replayed so far. </param>
        /// <param name="lastEventOn"> The timestamp of the last oplog event received, or null if no oplog event has been received yet. </param>
        /// <param name="lastReplayOn"> The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet. </param>
        /// <param name="name"> The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="qualifiedName"> The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="state"></param>
        /// <param name="totalBytes"> The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown. </param>
        /// <param name="totalDocuments"> The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown. </param>
        /// <param name="collections"> The progress of the collections in the database. The keys are the unqualified names of the collections. </param>
        /// <returns> A new <see cref="Models.MongoDBDatabaseProgress"/> instance for mocking. </returns>
        public static MongoDBDatabaseProgress MongoDBDatabaseProgress(long bytesCopied = default, long documentsCopied = default, string elapsedTime = null, IReadOnlyDictionary<string, MongoDBError> errors = null, long eventsPending = default, long eventsReplayed = default, DateTimeOffset? lastEventOn = null, DateTimeOffset? lastReplayOn = null, string name = null, string qualifiedName = null, MongoDBMigrationState state = default, long totalBytes = default, long totalDocuments = default, IReadOnlyDictionary<string, MongoDBCollectionProgress> collections = null)
        {
            errors ??= new Dictionary<string, MongoDBError>();
            collections ??= new Dictionary<string, MongoDBCollectionProgress>();

            return new MongoDBDatabaseProgress(
                bytesCopied,
                documentsCopied,
                elapsedTime,
                errors,
                eventsPending,
                eventsReplayed,
                lastEventOn,
                lastReplayOn,
                name,
                qualifiedName,
                MongoDBProgressResultType.Database,
                state,
                totalBytes,
                totalDocuments,
                serializedAdditionalRawData: null,
                collections);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBFinishCommand"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the command. This is ignored if submitted. </param>
        /// <param name="input"> Command input. </param>
        /// <returns> A new <see cref="Models.MongoDBFinishCommand"/> instance for mocking. </returns>
        public static MongoDBFinishCommand MongoDBFinishCommand(IEnumerable<ODataError> errors = null, CommandState? state = null, MongoDBFinishCommandInput input = null)
        {
            errors ??= new List<ODataError>();

            return new MongoDBFinishCommand(CommandType.Finish, errors?.ToList(), state, serializedAdditionalRawData: null, input);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBMigrationProgress"/>. </summary>
        /// <param name="bytesCopied"> The number of document bytes copied during the Copying stage. </param>
        /// <param name="documentsCopied"> The number of documents copied during the Copying stage. </param>
        /// <param name="elapsedTime"> The elapsed time in the format [ddd.]hh:mm:ss[.fffffff] (i.e. TimeSpan format). </param>
        /// <param name="errors"> The errors and warnings that have occurred for the current object. The keys are the error codes. </param>
        /// <param name="eventsPending"> The number of oplog events awaiting replay. </param>
        /// <param name="eventsReplayed"> The number of oplog events replayed so far. </param>
        /// <param name="lastEventOn"> The timestamp of the last oplog event received, or null if no oplog event has been received yet. </param>
        /// <param name="lastReplayOn"> The timestamp of the last oplog event replayed, or null if no oplog event has been replayed yet. </param>
        /// <param name="name"> The name of the progress object. For a collection, this is the unqualified collection name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="qualifiedName"> The qualified name of the progress object. For a collection, this is the database-qualified name. For a database, this is the database name. For the overall migration, this is null. </param>
        /// <param name="state"></param>
        /// <param name="totalBytes"> The total number of document bytes on the source at the beginning of the Copying stage, or -1 if the total size was unknown. </param>
        /// <param name="totalDocuments"> The total number of documents on the source at the beginning of the Copying stage, or -1 if the total count was unknown. </param>
        /// <param name="databases"> The progress of the databases in the migration. The keys are the names of the databases. </param>
        /// <returns> A new <see cref="Models.MongoDBMigrationProgress"/> instance for mocking. </returns>
        public static MongoDBMigrationProgress MongoDBMigrationProgress(long bytesCopied = default, long documentsCopied = default, string elapsedTime = null, IReadOnlyDictionary<string, MongoDBError> errors = null, long eventsPending = default, long eventsReplayed = default, DateTimeOffset? lastEventOn = null, DateTimeOffset? lastReplayOn = null, string name = null, string qualifiedName = null, MongoDBMigrationState state = default, long totalBytes = default, long totalDocuments = default, IReadOnlyDictionary<string, MongoDBDatabaseProgress> databases = null)
        {
            errors ??= new Dictionary<string, MongoDBError>();
            databases ??= new Dictionary<string, MongoDBDatabaseProgress>();

            return new MongoDBMigrationProgress(
                bytesCopied,
                documentsCopied,
                elapsedTime,
                errors,
                eventsPending,
                eventsReplayed,
                lastEventOn,
                lastReplayOn,
                name,
                qualifiedName,
                MongoDBProgressResultType.Migration,
                state,
                totalBytes,
                totalDocuments,
                serializedAdditionalRawData: null,
                databases);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MongoDBRestartCommand"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the command. This is ignored if submitted. </param>
        /// <param name="inputObjectName"> Command input. </param>
        /// <returns> A new <see cref="Models.MongoDBRestartCommand"/> instance for mocking. </returns>
        public static MongoDBRestartCommand MongoDBRestartCommand(IEnumerable<ODataError> errors = null, CommandState? state = null, string inputObjectName = null)
        {
            errors ??= new List<ODataError>();

            return new MongoDBRestartCommand(CommandType.Restart, errors?.ToList(), state, serializedAdditionalRawData: null, inputObjectName != null ? new MongoDBCommandInput(inputObjectName, serializedAdditionalRawData: null) : null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceOracleSyncTaskOutput"/>. </summary>
        /// <param name="sourceServerVersion"> Version of the source server. </param>
        /// <param name="databases"> List of schemas on source server. </param>
        /// <param name="sourceServerBrandVersion"> Source server brand version. </param>
        /// <param name="validationErrors"> Validation errors associated with the task. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceOracleSyncTaskOutput"/> instance for mocking. </returns>
        public static ConnectToSourceOracleSyncTaskOutput ConnectToSourceOracleSyncTaskOutput(string sourceServerVersion = null, IEnumerable<string> databases = null, string sourceServerBrandVersion = null, IEnumerable<ReportableException> validationErrors = null)
        {
            databases ??= new List<string>();
            validationErrors ??= new List<ReportableException>();

            return new ConnectToSourceOracleSyncTaskOutput(sourceServerVersion, databases?.ToList(), sourceServerBrandVersion, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutput"/>. </summary>
        /// <param name="targetServerVersion"> Version of the target server. </param>
        /// <param name="databases"> List of databases on target server. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="validationErrors"> Validation errors associated with the task. </param>
        /// <param name="databaseSchemaMap"> Mapping of schemas per database. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutput"/> instance for mocking. </returns>
        public static ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutput ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutput(string targetServerVersion = null, IEnumerable<string> databases = null, string targetServerBrandVersion = null, IEnumerable<ReportableException> validationErrors = null, IEnumerable<ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem> databaseSchemaMap = null)
        {
            databases ??= new List<string>();
            validationErrors ??= new List<ReportableException>();
            databaseSchemaMap ??= new List<ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem>();

            return new ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutput(
                targetServerVersion,
                databases?.ToList(),
                targetServerBrandVersion,
                validationErrors?.ToList(),
                databaseSchemaMap?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem"/>. </summary>
        /// <param name="database"></param>
        /// <param name="schemas"></param>
        /// <returns> A new <see cref="Models.ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem"/> instance for mocking. </returns>
        public static ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem(string database = null, IEnumerable<string> schemas = null)
        {
            schemas ??= new List<string>();

            return new ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutputDatabaseSchemaMapItem(database, schemas?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesOracleTaskOutput"/>. </summary>
        /// <param name="schemaName"> The schema this result is for. </param>
        /// <param name="tables"> List of valid tables found for this schema. </param>
        /// <param name="validationErrors"> Validation errors associated with the task. </param>
        /// <returns> A new <see cref="Models.GetUserTablesOracleTaskOutput"/> instance for mocking. </returns>
        public static GetUserTablesOracleTaskOutput GetUserTablesOracleTaskOutput(string schemaName = null, IEnumerable<DatabaseTable> tables = null, IEnumerable<ReportableException> validationErrors = null)
        {
            tables ??= new List<DatabaseTable>();
            validationErrors ??= new List<ReportableException>();

            return new GetUserTablesOracleTaskOutput(schemaName, tables?.ToList(), validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesPostgreSqlTaskOutput"/>. </summary>
        /// <param name="databaseName"> The database this result is for. </param>
        /// <param name="tables"> List of valid tables found for this database. </param>
        /// <param name="validationErrors"> Validation errors associated with the task. </param>
        /// <returns> A new <see cref="Models.GetUserTablesPostgreSqlTaskOutput"/> instance for mocking. </returns>
        public static GetUserTablesPostgreSqlTaskOutput GetUserTablesPostgreSqlTaskOutput(string databaseName = null, IEnumerable<DatabaseTable> tables = null, IEnumerable<ReportableException> validationErrors = null)
        {
            tables ??= new List<DatabaseTable>();
            validationErrors ??= new List<ReportableException>();

            return new GetUserTablesPostgreSqlTaskOutput(databaseName, tables?.ToList(), validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateOracleAzureDBPostgreSqlSyncTaskOutput"/>. </summary>
        /// <param name="validationErrors"> Errors associated with a selected database object. </param>
        /// <returns> A new <see cref="Models.ValidateOracleAzureDBPostgreSqlSyncTaskOutput"/> instance for mocking. </returns>
        public static ValidateOracleAzureDBPostgreSqlSyncTaskOutput ValidateOracleAzureDBPostgreSqlSyncTaskOutput(IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new ValidateOracleAzureDBPostgreSqlSyncTaskOutput(validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutput"/> instance for mocking. </returns>
        public static MigrateOracleAzureDBPostgreSqlSyncTaskOutput MigrateOracleAzureDBPostgreSqlSyncTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigrateOracleAzureDBPostgreSqlSyncTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServer"> Source server name. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServer"> Target server name. </param>
        /// <returns> A new <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigrateOracleAzureDBPostgreSqlSyncTaskOutputMigrationLevel MigrateOracleAzureDBPostgreSqlSyncTaskOutputMigrationLevel(string id = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, string sourceServerVersion = null, string sourceServer = null, string targetServerVersion = null, string targetServer = null)
        {
            return new MigrateOracleAzureDBPostgreSqlSyncTaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                startedOn,
                endedOn,
                sourceServerVersion,
                sourceServer,
                targetServerVersion,
                targetServer);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="migrationState"> Migration state that this database is in. </param>
        /// <param name="incomingChanges"> Number of incoming changes. </param>
        /// <param name="appliedChanges"> Number of applied changes. </param>
        /// <param name="cdcInsertCounter"> Number of cdc inserts. </param>
        /// <param name="cdcDeleteCounter"> Number of cdc deletes. </param>
        /// <param name="cdcUpdateCounter"> Number of cdc updates. </param>
        /// <param name="fullLoadCompletedTables"> Number of tables completed in full load. </param>
        /// <param name="fullLoadLoadingTables"> Number of tables loading in full load. </param>
        /// <param name="fullLoadQueuedTables"> Number of tables queued in full load. </param>
        /// <param name="fullLoadErroredTables"> Number of tables errored in full load. </param>
        /// <param name="initializationCompleted"> Indicates if initial load (full load) has been completed. </param>
        /// <param name="latency"> CDC apply latency. </param>
        /// <returns> A new <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseLevel MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseLevel(string id = null, string databaseName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, SyncDatabaseMigrationReportingState? migrationState = null, long? incomingChanges = null, long? appliedChanges = null, long? cdcInsertCounter = null, long? cdcDeleteCounter = null, long? cdcUpdateCounter = null, long? fullLoadCompletedTables = null, long? fullLoadLoadingTables = null, long? fullLoadQueuedTables = null, long? fullLoadErroredTables = null, bool? initializationCompleted = null, long? latency = null)
        {
            return new MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                databaseName,
                startedOn,
                endedOn,
                migrationState,
                incomingChanges,
                appliedChanges,
                cdcInsertCounter,
                cdcDeleteCounter,
                cdcUpdateCounter,
                fullLoadCompletedTables,
                fullLoadLoadingTables,
                fullLoadQueuedTables,
                fullLoadErroredTables,
                initializationCompleted,
                latency);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputTableLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="tableName"> Name of the table. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="cdcInsertCounter"> Number of applied inserts. </param>
        /// <param name="cdcUpdateCounter"> Number of applied updates. </param>
        /// <param name="cdcDeleteCounter"> Number of applied deletes. </param>
        /// <param name="fullLoadEstFinishOn"> Estimate to finish full load. </param>
        /// <param name="fullLoadStartedOn"> Full load start time. </param>
        /// <param name="fullLoadEndedOn"> Full load end time. </param>
        /// <param name="fullLoadTotalRows"> Number of rows applied in full load. </param>
        /// <param name="state"> Current state of the table migration. </param>
        /// <param name="totalChangesApplied"> Total number of applied changes. </param>
        /// <param name="dataErrorsCounter"> Number of data errors occurred. </param>
        /// <param name="lastModifiedOn"> Last modified time on target. </param>
        /// <returns> A new <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputTableLevel"/> instance for mocking. </returns>
        public static MigrateOracleAzureDBPostgreSqlSyncTaskOutputTableLevel MigrateOracleAzureDBPostgreSqlSyncTaskOutputTableLevel(string id = null, string tableName = null, string databaseName = null, long? cdcInsertCounter = null, long? cdcUpdateCounter = null, long? cdcDeleteCounter = null, DateTimeOffset? fullLoadEstFinishOn = null, DateTimeOffset? fullLoadStartedOn = null, DateTimeOffset? fullLoadEndedOn = null, long? fullLoadTotalRows = null, SyncTableMigrationState? state = null, long? totalChangesApplied = null, long? dataErrorsCounter = null, DateTimeOffset? lastModifiedOn = null)
        {
            return new MigrateOracleAzureDBPostgreSqlSyncTaskOutputTableLevel(
                id,
                "TableLevelOutput",
                serializedAdditionalRawData: null,
                tableName,
                databaseName,
                cdcInsertCounter,
                cdcUpdateCounter,
                cdcDeleteCounter,
                fullLoadEstFinishOn,
                fullLoadStartedOn,
                fullLoadEndedOn,
                fullLoadTotalRows,
                state,
                totalChangesApplied,
                dataErrorsCounter,
                lastModifiedOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="error"> Migration error. </param>
        /// <returns> A new <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputError"/> instance for mocking. </returns>
        public static MigrateOracleAzureDBPostgreSqlSyncTaskOutputError MigrateOracleAzureDBPostgreSqlSyncTaskOutputError(string id = null, ReportableException error = null)
        {
            return new MigrateOracleAzureDBPostgreSqlSyncTaskOutputError(id, "ErrorOutput", serializedAdditionalRawData: null, error);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="errorMessage"> Error message. </param>
        /// <param name="events"> List of error events. </param>
        /// <returns> A new <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseError"/> instance for mocking. </returns>
        public static MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseError MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseError(string id = null, string errorMessage = null, IEnumerable<SyncMigrationDatabaseErrorEvent> events = null)
        {
            events ??= new List<SyncMigrationDatabaseErrorEvent>();

            return new MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseError(id, "DatabaseLevelErrorOutput", serializedAdditionalRawData: null, errorMessage, events?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.OracleOciDriverInfo"/>. </summary>
        /// <param name="driverName"> The name of the driver package. </param>
        /// <param name="driverSize"> The size in bytes of the driver package. </param>
        /// <param name="archiveChecksum"> The MD5 Base64 encoded checksum for the driver package. </param>
        /// <param name="oracleChecksum"> The checksum for the driver package provided by Oracle. </param>
        /// <param name="assemblyVersion"> Version listed in the OCI assembly 'oci.dll'. </param>
        /// <param name="supportedOracleVersions"> List of Oracle database versions supported by this driver. Only major minor of the version is listed. </param>
        /// <returns> A new <see cref="Models.OracleOciDriverInfo"/> instance for mocking. </returns>
        public static OracleOciDriverInfo OracleOciDriverInfo(string driverName = null, string driverSize = null, string archiveChecksum = null, string oracleChecksum = null, string assemblyVersion = null, IEnumerable<string> supportedOracleVersions = null)
        {
            supportedOracleVersions ??= new List<string>();

            return new OracleOciDriverInfo(
                driverName,
                driverSize,
                archiveChecksum,
                oracleChecksum,
                assemblyVersion,
                supportedOracleVersions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CheckOciDriverTaskOutput"/>. </summary>
        /// <param name="installedDriver"> Information about the installed driver if found and valid. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.CheckOciDriverTaskOutput"/> instance for mocking. </returns>
        public static CheckOciDriverTaskOutput CheckOciDriverTaskOutput(OracleOciDriverInfo installedDriver = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new CheckOciDriverTaskOutput(installedDriver, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.UploadOciDriverTaskOutput"/>. </summary>
        /// <param name="driverPackageName"> The name of the driver package that was validated and uploaded. </param>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.UploadOciDriverTaskOutput"/> instance for mocking. </returns>
        public static UploadOciDriverTaskOutput UploadOciDriverTaskOutput(string driverPackageName = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new UploadOciDriverTaskOutput(driverPackageName, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.InstallOciDriverTaskOutput"/>. </summary>
        /// <param name="validationErrors"> Validation errors. </param>
        /// <returns> A new <see cref="Models.InstallOciDriverTaskOutput"/> instance for mocking. </returns>
        public static InstallOciDriverTaskOutput InstallOciDriverTaskOutput(IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new InstallOciDriverTaskOutput(validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.CheckOciDriverTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="inputServerVersion"> Input for the service task to check for OCI drivers. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.CheckOciDriverTaskProperties"/> instance for mocking. </returns>
        public static CheckOciDriverTaskProperties CheckOciDriverTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, string inputServerVersion = null, IEnumerable<CheckOciDriverTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<CheckOciDriverTaskOutput>();

            return new CheckOciDriverTaskProperties(
                TaskType.ServiceCheckOci,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                inputServerVersion != null ? new CheckOciDriverTaskInput(inputServerVersion, serializedAdditionalRawData: null) : null,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.UploadOciDriverTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="inputDriverShare"> Input for the service task to upload an OCI driver. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.UploadOciDriverTaskProperties"/> instance for mocking. </returns>
        public static UploadOciDriverTaskProperties UploadOciDriverTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, FileShare inputDriverShare = null, IEnumerable<UploadOciDriverTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<UploadOciDriverTaskOutput>();

            return new UploadOciDriverTaskProperties(
                TaskType.ServiceUploadOci,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                inputDriverShare != null ? new UploadOciDriverTaskInput(inputDriverShare, serializedAdditionalRawData: null) : null,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.InstallOciDriverTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="inputDriverPackageName"> Input for the service task to install an OCI driver. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.InstallOciDriverTaskProperties"/> instance for mocking. </returns>
        public static InstallOciDriverTaskProperties InstallOciDriverTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, string inputDriverPackageName = null, IEnumerable<InstallOciDriverTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<InstallOciDriverTaskOutput>();

            return new InstallOciDriverTaskProperties(
                TaskType.ServiceInstallOci,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                inputDriverPackageName != null ? new InstallOciDriverTaskInput(inputDriverPackageName, serializedAdditionalRawData: null) : null,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToMongoDBTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Describes a connection to a MongoDB data source. </param>
        /// <param name="output"> An array containing a single MongoDbClusterInfo object. </param>
        /// <returns> A new <see cref="Models.ConnectToMongoDBTaskProperties"/> instance for mocking. </returns>
        public static ConnectToMongoDBTaskProperties ConnectToMongoDBTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MongoDBConnectionInfo input = null, IEnumerable<MongoDBClusterInfo> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MongoDBClusterInfo>();

            return new ConnectToMongoDBTaskProperties(
                TaskType.ConnectMongoDB,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceSqlServerTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.ConnectToSourceSqlServerTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ConnectToSourceSqlServerTaskOutputAgentJobLevel"/>, <see cref="Models.ConnectToSourceSqlServerTaskOutputDatabaseLevel"/>, <see cref="Models.ConnectToSourceSqlServerTaskOutputLoginLevel"/> and <see cref="Models.ConnectToSourceSqlServerTaskOutputTaskLevel"/>.
        /// </param>
        /// <param name="taskId"> Task id. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceSqlServerTaskProperties"/> instance for mocking. </returns>
        public static ConnectToSourceSqlServerTaskProperties ConnectToSourceSqlServerTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ConnectToSourceSqlServerTaskInput input = null, IEnumerable<ConnectToSourceSqlServerTaskOutput> output = null, string taskId = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToSourceSqlServerTaskOutput>();

            return new ConnectToSourceSqlServerTaskProperties(
                TaskType.ConnectToSourceSqlServer,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList(),
                taskId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceSqlServerSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.ConnectToSourceSqlServerTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.ConnectToSourceSqlServerTaskOutputAgentJobLevel"/>, <see cref="Models.ConnectToSourceSqlServerTaskOutputDatabaseLevel"/>, <see cref="Models.ConnectToSourceSqlServerTaskOutputLoginLevel"/> and <see cref="Models.ConnectToSourceSqlServerTaskOutputTaskLevel"/>.
        /// </param>
        /// <returns> A new <see cref="Models.ConnectToSourceSqlServerSyncTaskProperties"/> instance for mocking. </returns>
        public static ConnectToSourceSqlServerSyncTaskProperties ConnectToSourceSqlServerSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ConnectToSourceSqlServerTaskInput input = null, IEnumerable<ConnectToSourceSqlServerTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToSourceSqlServerTaskOutput>();

            return new ConnectToSourceSqlServerSyncTaskProperties(
                TaskType.ConnectToSourceSqlServerSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourcePostgreSqlSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="inputSourceConnectionInfo"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ConnectToSourcePostgreSqlSyncTaskProperties"/> instance for mocking. </returns>
        public static ConnectToSourcePostgreSqlSyncTaskProperties ConnectToSourcePostgreSqlSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, PostgreSqlConnectionInfo inputSourceConnectionInfo = null, IEnumerable<ConnectToSourcePostgreSqlSyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToSourcePostgreSqlSyncTaskOutput>();

            return new ConnectToSourcePostgreSqlSyncTaskProperties(
                TaskType.ConnectToSourcePostgreSqlSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                inputSourceConnectionInfo != null ? new ConnectToSourcePostgreSqlSyncTaskInput(inputSourceConnectionInfo, serializedAdditionalRawData: null) : null,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceMySqlTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceMySqlTaskProperties"/> instance for mocking. </returns>
        public static ConnectToSourceMySqlTaskProperties ConnectToSourceMySqlTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ConnectToSourceMySqlTaskInput input = null, IEnumerable<ConnectToSourceNonSqlTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToSourceNonSqlTaskOutput>();

            return new ConnectToSourceMySqlTaskProperties(
                TaskType.ConnectToSourceMySql,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceNonSqlTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="sourceServerBrandVersion"> Server brand version. </param>
        /// <param name="serverProperties"> Server properties. </param>
        /// <param name="databases"> List of databases on the server. </param>
        /// <param name="validationErrors"> Validation errors associated with the task. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceNonSqlTaskOutput"/> instance for mocking. </returns>
        public static ConnectToSourceNonSqlTaskOutput ConnectToSourceNonSqlTaskOutput(string id = null, string sourceServerBrandVersion = null, ServerProperties serverProperties = null, IEnumerable<string> databases = null, IEnumerable<ReportableException> validationErrors = null)
        {
            databases ??= new List<string>();
            validationErrors ??= new List<ReportableException>();

            return new ConnectToSourceNonSqlTaskOutput(
                id,
                sourceServerBrandVersion,
                serverProperties,
                databases?.ToList(),
                validationErrors?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ServerProperties"/>. </summary>
        /// <param name="serverPlatform"> Name of the server platform. </param>
        /// <param name="serverName"> Name of the server. </param>
        /// <param name="serverVersion"> Version of the database server. </param>
        /// <param name="serverEdition"> Edition of the database server. </param>
        /// <param name="serverOperatingSystemVersion"> Version of the operating system. </param>
        /// <param name="serverDatabaseCount"> Number of databases in the server. </param>
        /// <returns> A new <see cref="Models.ServerProperties"/> instance for mocking. </returns>
        public static ServerProperties ServerProperties(string serverPlatform = null, string serverName = null, string serverVersion = null, string serverEdition = null, string serverOperatingSystemVersion = null, int? serverDatabaseCount = null)
        {
            return new ServerProperties(
                serverPlatform,
                serverName,
                serverVersion,
                serverEdition,
                serverOperatingSystemVersion,
                serverDatabaseCount,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToSourceOracleSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="inputSourceConnectionInfo"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ConnectToSourceOracleSyncTaskProperties"/> instance for mocking. </returns>
        public static ConnectToSourceOracleSyncTaskProperties ConnectToSourceOracleSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, OracleConnectionInfo inputSourceConnectionInfo = null, IEnumerable<ConnectToSourceOracleSyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToSourceOracleSyncTaskOutput>();

            return new ConnectToSourceOracleSyncTaskProperties(
                TaskType.ConnectToSourceOracleSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                inputSourceConnectionInfo != null ? new ConnectToSourceOracleSyncTaskInput(inputSourceConnectionInfo, serializedAdditionalRawData: null) : null,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetSqlDBTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <param name="createdOn"> DateTime in UTC when the task was created. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetSqlDBTaskProperties"/> instance for mocking. </returns>
        public static ConnectToTargetSqlDBTaskProperties ConnectToTargetSqlDBTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ConnectToTargetSqlDBTaskInput input = null, IEnumerable<ConnectToTargetSqlDBTaskOutput> output = null, string createdOn = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToTargetSqlDBTaskOutput>();

            return new ConnectToTargetSqlDBTaskProperties(
                TaskType.ConnectToTargetSqlDB,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList(),
                createdOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetSqlDBSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetSqlDBSyncTaskProperties"/> instance for mocking. </returns>
        public static ConnectToTargetSqlDBSyncTaskProperties ConnectToTargetSqlDBSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ConnectToTargetSqlDBSyncTaskInput input = null, IEnumerable<ConnectToTargetSqlDBTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToTargetSqlDBTaskOutput>();

            return new ConnectToTargetSqlDBSyncTaskProperties(
                TaskType.ConnectToTargetSqlDBSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetAzureDBForPostgreSqlSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetAzureDBForPostgreSqlSyncTaskProperties"/> instance for mocking. </returns>
        public static ConnectToTargetAzureDBForPostgreSqlSyncTaskProperties ConnectToTargetAzureDBForPostgreSqlSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ConnectToTargetAzureDBForPostgreSqlSyncTaskInput input = null, IEnumerable<ConnectToTargetAzureDBForPostgreSqlSyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToTargetAzureDBForPostgreSqlSyncTaskOutput>();

            return new ConnectToTargetAzureDBForPostgreSqlSyncTaskProperties(
                TaskType.ConnectToTargetAzureDBForPostgreSqlSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="inputTargetConnectionInfo"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskProperties"/> instance for mocking. </returns>
        public static ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskProperties ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, PostgreSqlConnectionInfo inputTargetConnectionInfo = null, IEnumerable<ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskOutput>();

            return new ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskProperties(
                TaskType.ConnectToTargetOracleAzureDBForPostgreSqlSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                inputTargetConnectionInfo != null ? new ConnectToTargetOracleAzureDBForPostgreSqlSyncTaskInput(inputTargetConnectionInfo, serializedAdditionalRawData: null) : null,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesSqlTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <param name="taskId"> Task id. </param>
        /// <returns> A new <see cref="Models.GetUserTablesSqlTaskProperties"/> instance for mocking. </returns>
        public static GetUserTablesSqlTaskProperties GetUserTablesSqlTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, GetUserTablesSqlTaskInput input = null, IEnumerable<GetUserTablesSqlTaskOutput> output = null, string taskId = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<GetUserTablesSqlTaskOutput>();

            return new GetUserTablesSqlTaskProperties(
                TaskType.GetUserTablesSql,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList(),
                taskId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesSqlSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.GetUserTablesSqlSyncTaskProperties"/> instance for mocking. </returns>
        public static GetUserTablesSqlSyncTaskProperties GetUserTablesSqlSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, GetUserTablesSqlSyncTaskInput input = null, IEnumerable<GetUserTablesSqlSyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<GetUserTablesSqlSyncTaskOutput>();

            return new GetUserTablesSqlSyncTaskProperties(
                TaskType.GetUserTablesAzureSqlDBSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesOracleTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.GetUserTablesOracleTaskProperties"/> instance for mocking. </returns>
        public static GetUserTablesOracleTaskProperties GetUserTablesOracleTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, GetUserTablesOracleTaskInput input = null, IEnumerable<GetUserTablesOracleTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<GetUserTablesOracleTaskOutput>();

            return new GetUserTablesOracleTaskProperties(
                TaskType.GetUserTablesOracle,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesPostgreSqlTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.GetUserTablesPostgreSqlTaskProperties"/> instance for mocking. </returns>
        public static GetUserTablesPostgreSqlTaskProperties GetUserTablesPostgreSqlTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, GetUserTablesPostgreSqlTaskInput input = null, IEnumerable<GetUserTablesPostgreSqlTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<GetUserTablesPostgreSqlTaskOutput>();

            return new GetUserTablesPostgreSqlTaskProperties(
                TaskType.GetUserTablesPostgreSql,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetUserTablesMySqlTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.GetUserTablesMySqlTaskProperties"/> instance for mocking. </returns>
        public static GetUserTablesMySqlTaskProperties GetUserTablesMySqlTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, GetUserTablesMySqlTaskInput input = null, IEnumerable<GetUserTablesMySqlTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<GetUserTablesMySqlTaskOutput>();

            return new GetUserTablesMySqlTaskProperties(
                TaskType.GetUserTablesMySql,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetSqlMITaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetSqlMITaskProperties"/> instance for mocking. </returns>
        public static ConnectToTargetSqlMITaskProperties ConnectToTargetSqlMITaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ConnectToTargetSqlMITaskInput input = null, IEnumerable<ConnectToTargetSqlMITaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToTargetSqlMITaskOutput>();

            return new ConnectToTargetSqlMITaskProperties(
                TaskType.ConnectToTargetAzureSqlDBMI,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetSqlMISyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetSqlMISyncTaskProperties"/> instance for mocking. </returns>
        public static ConnectToTargetSqlMISyncTaskProperties ConnectToTargetSqlMISyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ConnectToTargetSqlMISyncTaskInput input = null, IEnumerable<ConnectToTargetSqlMISyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToTargetSqlMISyncTaskOutput>();

            return new ConnectToTargetSqlMISyncTaskProperties(
                TaskType.ConnectToTargetAzureSqlDBMISyncLRS,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ConnectToTargetAzureDBForMySqlTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ConnectToTargetAzureDBForMySqlTaskProperties"/> instance for mocking. </returns>
        public static ConnectToTargetAzureDBForMySqlTaskProperties ConnectToTargetAzureDBForMySqlTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ConnectToTargetAzureDBForMySqlTaskInput input = null, IEnumerable<ConnectToTargetAzureDBForMySqlTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ConnectToTargetAzureDBForMySqlTaskOutput>();

            return new ConnectToTargetAzureDBForMySqlTaskProperties(
                TaskType.ConnectToTargetAzureDBForMySql,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMongoDBTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Describes how a MongoDB data migration should be performed. </param>
        /// <param name="output">
        /// Please note <see cref="Models.MongoDBProgress"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCollectionProgress"/>, <see cref="Models.MongoDBDatabaseProgress"/> and <see cref="Models.MongoDBMigrationProgress"/>.
        /// </param>
        /// <returns> A new <see cref="Models.MigrateMongoDBTaskProperties"/> instance for mocking. </returns>
        public static MigrateMongoDBTaskProperties MigrateMongoDBTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MongoDBMigrationSettings input = null, IEnumerable<MongoDBProgress> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MongoDBProgress>();

            return new MigrateMongoDBTaskProperties(
                TaskType.MigrateMongoDB,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMITaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigrateSqlServerSqlMITaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigrateSqlServerSqlMITaskOutputAgentJobLevel"/>, <see cref="Models.MigrateSqlServerSqlMITaskOutputDatabaseLevel"/>, <see cref="Models.MigrateSqlServerSqlMITaskOutputError"/>, <see cref="Models.MigrateSqlServerSqlMITaskOutputLoginLevel"/> and <see cref="Models.MigrateSqlServerSqlMITaskOutputMigrationLevel"/>.
        /// </param>
        /// <param name="taskId"> task id. </param>
        /// <param name="createdOn"> DateTime in UTC when the task was created. </param>
        /// <param name="parentTaskId"> parent task id. </param>
        /// <param name="isCloneable"> whether the task can be cloned or not. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMITaskProperties"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMITaskProperties MigrateSqlServerSqlMITaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateSqlServerSqlMITaskInput input = null, IEnumerable<MigrateSqlServerSqlMITaskOutput> output = null, string taskId = null, string createdOn = null, string parentTaskId = null, bool? isCloneable = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigrateSqlServerSqlMITaskOutput>();

            return new MigrateSqlServerSqlMITaskProperties(
                TaskType.MigrateSqlServerAzureSqlDBMI,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList(),
                taskId,
                createdOn,
                parentTaskId,
                isCloneable);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlMISyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigrateSqlServerSqlMISyncTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigrateSqlServerSqlMISyncTaskOutputDatabaseLevel"/>, <see cref="Models.MigrateSqlServerSqlMISyncTaskOutputError"/> and <see cref="Models.MigrateSqlServerSqlMISyncTaskOutputMigrationLevel"/>.
        /// </param>
        /// <param name="createdOn"> DateTime in UTC when the task was created. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlMISyncTaskProperties"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlMISyncTaskProperties MigrateSqlServerSqlMISyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateSqlServerSqlMISyncTaskInput input = null, IEnumerable<MigrateSqlServerSqlMISyncTaskOutput> output = null, string createdOn = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigrateSqlServerSqlMISyncTaskOutput>();

            return new MigrateSqlServerSqlMISyncTaskProperties(
                TaskType.MigrateSqlServerAzureSqlDBMISyncLRS,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList(),
                createdOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigrateSqlServerSqlDBTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigrateSqlServerSqlDBTaskOutputDatabaseLevel"/>, <see cref="Models.MigrateSqlServerSqlDBTaskOutputError"/>, <see cref="Models.MigrateSqlServerSqlDBTaskOutputDatabaseLevelValidationResult"/>, <see cref="Models.MigrateSqlServerSqlDBTaskOutputMigrationLevel"/>, <see cref="Models.MigrateSqlServerSqlDBTaskOutputValidationResult"/> and <see cref="Models.MigrateSqlServerSqlDBTaskOutputTableLevel"/>.
        /// </param>
        /// <param name="taskId"> task id. </param>
        /// <param name="isCloneable"> whether the task can be cloned or not. </param>
        /// <param name="createdOn"> DateTime in UTC when the task was created. </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBTaskProperties"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBTaskProperties MigrateSqlServerSqlDBTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateSqlServerSqlDBTaskInput input = null, IEnumerable<MigrateSqlServerSqlDBTaskOutput> output = null, string taskId = null, bool? isCloneable = null, string createdOn = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigrateSqlServerSqlDBTaskOutput>();

            return new MigrateSqlServerSqlDBTaskProperties(
                TaskType.MigrateSqlServerSqlDB,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList(),
                taskId,
                isCloneable,
                createdOn);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSqlServerSqlDBSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputDatabaseError"/>, <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputDatabaseLevel"/>, <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputError"/>, <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputMigrationLevel"/> and <see cref="Models.MigrateSqlServerSqlDBSyncTaskOutputTableLevel"/>.
        /// </param>
        /// <returns> A new <see cref="Models.MigrateSqlServerSqlDBSyncTaskProperties"/> instance for mocking. </returns>
        public static MigrateSqlServerSqlDBSyncTaskProperties MigrateSqlServerSqlDBSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateSqlServerSqlDBSyncTaskInput input = null, IEnumerable<MigrateSqlServerSqlDBSyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigrateSqlServerSqlDBSyncTaskOutput>();

            return new MigrateSqlServerSqlDBSyncTaskProperties(
                TaskType.MigrateSqlServerAzureSqlDBSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseError"/>, <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputDatabaseLevel"/>, <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputError"/>, <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputMigrationLevel"/> and <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskOutputTableLevel"/>.
        /// </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlSyncTaskProperties"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlSyncTaskProperties MigrateMySqlAzureDBForMySqlSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateMySqlAzureDBForMySqlSyncTaskInput input = null, IEnumerable<MigrateMySqlAzureDBForMySqlSyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigrateMySqlAzureDBForMySqlSyncTaskOutput>();

            return new MigrateMySqlAzureDBForMySqlSyncTaskProperties(
                TaskType.MigrateMySqlAzureDBForMySqlSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputDatabaseLevel"/>, <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputError"/>, <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputMigrationLevel"/> and <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputTableLevel"/>.
        /// </param>
        /// <param name="isCloneable"> whether the task can be cloned or not. </param>
        /// <param name="taskId"> Task id. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskProperties"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlOfflineTaskProperties MigrateMySqlAzureDBForMySqlOfflineTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateMySqlAzureDBForMySqlOfflineTaskInput input = null, IEnumerable<MigrateMySqlAzureDBForMySqlOfflineTaskOutput> output = null, bool? isCloneable = null, string taskId = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigrateMySqlAzureDBForMySqlOfflineTaskOutput>();

            return new MigrateMySqlAzureDBForMySqlOfflineTaskProperties(
                TaskType.MigrateMySqlAzureDBForMySql,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList(),
                isCloneable,
                taskId);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="resultType"> Result type. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutput"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlOfflineTaskOutput MigrateMySqlAzureDBForMySqlOfflineTaskOutput(string id = null, string resultType = null)
        {
            return new UnknownMigrateMySqlAzureDBForMySqlOfflineTaskOutput(id, resultType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseError"/>, <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputDatabaseLevel"/>, <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputError"/>, <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputMigrationLevel"/> and <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutputTableLevel"/>.
        /// </param>
        /// <param name="taskId"> task id. </param>
        /// <param name="createdOn"> DateTime in UTC when the task was created. </param>
        /// <param name="isCloneable"> whether the task can be cloned or not. </param>
        /// <returns> A new <see cref="Models.MigratePostgreSqlAzureDBForPostgreSqlSyncTaskProperties"/> instance for mocking. </returns>
        public static MigratePostgreSqlAzureDBForPostgreSqlSyncTaskProperties MigratePostgreSqlAzureDBForPostgreSqlSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigratePostgreSqlAzureDBForPostgreSqlSyncTaskInput input = null, IEnumerable<MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutput> output = null, string taskId = null, string createdOn = null, bool? isCloneable = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigratePostgreSqlAzureDBForPostgreSqlSyncTaskOutput>();

            return new MigratePostgreSqlAzureDBForPostgreSqlSyncTaskProperties(
                TaskType.MigratePostgreSqlAzureDBForPostgreSqlSyncV2,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList(),
                taskId,
                createdOn,
                isCloneable);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateOracleAzureDBForPostgreSqlSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseError"/>, <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputDatabaseLevel"/>, <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputError"/>, <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputMigrationLevel"/> and <see cref="Models.MigrateOracleAzureDBPostgreSqlSyncTaskOutputTableLevel"/>.
        /// </param>
        /// <returns> A new <see cref="Models.MigrateOracleAzureDBForPostgreSqlSyncTaskProperties"/> instance for mocking. </returns>
        public static MigrateOracleAzureDBForPostgreSqlSyncTaskProperties MigrateOracleAzureDBForPostgreSqlSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateOracleAzureDBPostgreSqlSyncTaskInput input = null, IEnumerable<MigrateOracleAzureDBPostgreSqlSyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigrateOracleAzureDBPostgreSqlSyncTaskOutput>();

            return new MigrateOracleAzureDBForPostgreSqlSyncTaskProperties(
                TaskType.MigrateOracleAzureDBForPostgreSqlSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateMigrationInputSqlServerSqlDBSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ValidateMigrationInputSqlServerSqlDBSyncTaskProperties"/> instance for mocking. </returns>
        public static ValidateMigrationInputSqlServerSqlDBSyncTaskProperties ValidateMigrationInputSqlServerSqlDBSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ValidateSyncMigrationInputSqlServerTaskInput input = null, IEnumerable<ValidateSyncMigrationInputSqlServerTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ValidateSyncMigrationInputSqlServerTaskOutput>();

            return new ValidateMigrationInputSqlServerSqlDBSyncTaskProperties(
                TaskType.ValidateMigrationInputSqlServerSqlDBSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateSyncMigrationInputSqlServerTaskOutput"/>. </summary>
        /// <param name="id"> Database identifier. </param>
        /// <param name="name"> Name of database. </param>
        /// <param name="validationErrors"> Errors associated with a selected database object. </param>
        /// <returns> A new <see cref="Models.ValidateSyncMigrationInputSqlServerTaskOutput"/> instance for mocking. </returns>
        public static ValidateSyncMigrationInputSqlServerTaskOutput ValidateSyncMigrationInputSqlServerTaskOutput(string id = null, string name = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new ValidateSyncMigrationInputSqlServerTaskOutput(id, name, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateMigrationInputSqlServerSqlMITaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ValidateMigrationInputSqlServerSqlMITaskProperties"/> instance for mocking. </returns>
        public static ValidateMigrationInputSqlServerSqlMITaskProperties ValidateMigrationInputSqlServerSqlMITaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ValidateMigrationInputSqlServerSqlMITaskInput input = null, IEnumerable<ValidateMigrationInputSqlServerSqlMITaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ValidateMigrationInputSqlServerSqlMITaskOutput>();

            return new ValidateMigrationInputSqlServerSqlMITaskProperties(
                TaskType.ValidateMigrationInputSqlServerAzureSqlDBMI,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateMigrationInputSqlServerSqlMITaskOutput"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="name"> Name of database. </param>
        /// <param name="restoreDatabaseNameErrors"> Errors associated with the RestoreDatabaseName. </param>
        /// <param name="backupFolderErrors"> Errors associated with the BackupFolder path. </param>
        /// <param name="backupShareCredentialsErrors"> Errors associated with backup share user name and password credentials. </param>
        /// <param name="backupStorageAccountErrors"> Errors associated with the storage account provided. </param>
        /// <param name="existingBackupErrors"> Errors associated with existing backup files. </param>
        /// <param name="databaseBackupInfo"> Information about backup files when existing backup mode is used. </param>
        /// <returns> A new <see cref="Models.ValidateMigrationInputSqlServerSqlMITaskOutput"/> instance for mocking. </returns>
        public static ValidateMigrationInputSqlServerSqlMITaskOutput ValidateMigrationInputSqlServerSqlMITaskOutput(string id = null, string name = null, IEnumerable<ReportableException> restoreDatabaseNameErrors = null, IEnumerable<ReportableException> backupFolderErrors = null, IEnumerable<ReportableException> backupShareCredentialsErrors = null, IEnumerable<ReportableException> backupStorageAccountErrors = null, IEnumerable<ReportableException> existingBackupErrors = null, DatabaseBackupInfo databaseBackupInfo = null)
        {
            restoreDatabaseNameErrors ??= new List<ReportableException>();
            backupFolderErrors ??= new List<ReportableException>();
            backupShareCredentialsErrors ??= new List<ReportableException>();
            backupStorageAccountErrors ??= new List<ReportableException>();
            existingBackupErrors ??= new List<ReportableException>();

            return new ValidateMigrationInputSqlServerSqlMITaskOutput(
                id,
                name,
                restoreDatabaseNameErrors?.ToList(),
                backupFolderErrors?.ToList(),
                backupShareCredentialsErrors?.ToList(),
                backupStorageAccountErrors?.ToList(),
                existingBackupErrors?.ToList(),
                databaseBackupInfo,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DatabaseBackupInfo"/>. </summary>
        /// <param name="databaseName"> Database name. </param>
        /// <param name="backupType"> Backup Type. </param>
        /// <param name="backupFiles"> The list of backup files for the current database. </param>
        /// <param name="position"> Position of current database backup in the file. </param>
        /// <param name="isDamaged"> Database was damaged when backed up, but the backup operation was requested to continue despite errors. </param>
        /// <param name="isCompressed"> Whether the backup set is compressed. </param>
        /// <param name="familyCount"> Number of files in the backup set. </param>
        /// <param name="backupFinishOn"> Date and time when the backup operation finished. </param>
        /// <returns> A new <see cref="Models.DatabaseBackupInfo"/> instance for mocking. </returns>
        public static DatabaseBackupInfo DatabaseBackupInfo(string databaseName = null, BackupType? backupType = null, IEnumerable<string> backupFiles = null, int? position = null, bool? isDamaged = null, bool? isCompressed = null, int? familyCount = null, DateTimeOffset? backupFinishOn = null)
        {
            backupFiles ??= new List<string>();

            return new DatabaseBackupInfo(
                databaseName,
                backupType,
                backupFiles?.ToList(),
                position,
                isDamaged,
                isCompressed,
                familyCount,
                backupFinishOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateMigrationInputSqlServerSqlMISyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.ValidateMigrationInputSqlServerSqlMISyncTaskProperties"/> instance for mocking. </returns>
        public static ValidateMigrationInputSqlServerSqlMISyncTaskProperties ValidateMigrationInputSqlServerSqlMISyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, ValidateMigrationInputSqlServerSqlMISyncTaskInput input = null, IEnumerable<ValidateMigrationInputSqlServerSqlMISyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ValidateMigrationInputSqlServerSqlMISyncTaskOutput>();

            return new ValidateMigrationInputSqlServerSqlMISyncTaskProperties(
                TaskType.ValidateMigrationInputSqlServerAzureSqlDBMISyncLRS,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateMigrationInputSqlServerSqlMISyncTaskOutput"/>. </summary>
        /// <param name="id"> Database identifier. </param>
        /// <param name="name"> Name of database. </param>
        /// <param name="validationErrors"> Errors associated with a selected database object. </param>
        /// <returns> A new <see cref="Models.ValidateMigrationInputSqlServerSqlMISyncTaskOutput"/> instance for mocking. </returns>
        public static ValidateMigrationInputSqlServerSqlMISyncTaskOutput ValidateMigrationInputSqlServerSqlMISyncTaskOutput(string id = null, string name = null, IEnumerable<ReportableException> validationErrors = null)
        {
            validationErrors ??= new List<ReportableException>();

            return new ValidateMigrationInputSqlServerSqlMISyncTaskOutput(id, name, validationErrors?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateMongoDBTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Describes how a MongoDB data migration should be performed. </param>
        /// <param name="output"> An array containing a single MongoDbMigrationProgress object. </param>
        /// <returns> A new <see cref="Models.ValidateMongoDBTaskProperties"/> instance for mocking. </returns>
        public static ValidateMongoDBTaskProperties ValidateMongoDBTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MongoDBMigrationSettings input = null, IEnumerable<MongoDBMigrationProgress> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MongoDBMigrationProgress>();

            return new ValidateMongoDBTaskProperties(
                TaskType.ValidateMongoDB,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.ValidateOracleAzureDBForPostgreSqlSyncTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Input for the task that migrates Oracle databases to Azure Database for PostgreSQL for online migrations. </param>
        /// <param name="output"> An array containing a single validation error response object. </param>
        /// <returns> A new <see cref="Models.ValidateOracleAzureDBForPostgreSqlSyncTaskProperties"/> instance for mocking. </returns>
        public static ValidateOracleAzureDBForPostgreSqlSyncTaskProperties ValidateOracleAzureDBForPostgreSqlSyncTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateOracleAzureDBPostgreSqlSyncTaskInput input = null, IEnumerable<ValidateOracleAzureDBPostgreSqlSyncTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<ValidateOracleAzureDBPostgreSqlSyncTaskOutput>();

            return new ValidateOracleAzureDBForPostgreSqlSyncTaskProperties(
                TaskType.ValidateOracleAzureDBPostgreSqlSync,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.GetTdeCertificatesSqlTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output"> Task output. This is ignored if submitted. </param>
        /// <returns> A new <see cref="Models.GetTdeCertificatesSqlTaskProperties"/> instance for mocking. </returns>
        public static GetTdeCertificatesSqlTaskProperties GetTdeCertificatesSqlTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, GetTdeCertificatesSqlTaskInput input = null, IEnumerable<GetTdeCertificatesSqlTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<GetTdeCertificatesSqlTaskOutput>();

            return new GetTdeCertificatesSqlTaskProperties(
                TaskType.GetTDECertificatesSql,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateSsisTaskProperties"/>. </summary>
        /// <param name="errors"> Array of errors. This is ignored if submitted. </param>
        /// <param name="state"> The state of the task. This is ignored if submitted. </param>
        /// <param name="commands">
        /// Array of command properties.
        /// Please note <see cref="Models.CommandProperties"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MongoDBCancelCommand"/>, <see cref="Models.MongoDBFinishCommand"/>, <see cref="Models.MigrateMISyncCompleteCommandProperties"/>, <see cref="Models.MigrateSyncCompleteCommandProperties"/> and <see cref="Models.MongoDBRestartCommand"/>.
        /// </param>
        /// <param name="clientData"> Key value pairs of client data to attach meta data information to task. </param>
        /// <param name="input"> Task input. </param>
        /// <param name="output">
        /// Task output. This is ignored if submitted.
        /// Please note <see cref="Models.MigrateSsisTaskOutput"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="Models.MigrateSsisTaskOutputMigrationLevel"/> and <see cref="Models.MigrateSsisTaskOutputProjectLevel"/>.
        /// </param>
        /// <returns> A new <see cref="Models.MigrateSsisTaskProperties"/> instance for mocking. </returns>
        public static MigrateSsisTaskProperties MigrateSsisTaskProperties(IEnumerable<ODataError> errors = null, TaskState? state = null, IEnumerable<CommandProperties> commands = null, IDictionary<string, string> clientData = null, MigrateSsisTaskInput input = null, IEnumerable<MigrateSsisTaskOutput> output = null)
        {
            errors ??= new List<ODataError>();
            commands ??= new List<CommandProperties>();
            clientData ??= new Dictionary<string, string>();
            output ??= new List<MigrateSsisTaskOutput>();

            return new MigrateSsisTaskProperties(
                TaskType.MigrateSsis,
                errors?.ToList(),
                state,
                commands?.ToList(),
                clientData,
                serializedAdditionalRawData: null,
                input,
                output?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputMigrationLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="durationInSeconds"> Duration of task execution in seconds. </param>
        /// <param name="status"> Current status of migration. </param>
        /// <param name="statusMessage"> Migration status message. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="databases"> Selected databases as a map from database name to database id. </param>
        /// <param name="databaseSummary"> Summary of database results in the migration. </param>
        /// <param name="migrationReportResult"> Migration Report Result, provides unique url for downloading your migration report. </param>
        /// <param name="sourceServerVersion"> Source server version. </param>
        /// <param name="sourceServerBrandVersion"> Source server brand version. </param>
        /// <param name="targetServerVersion"> Target server version. </param>
        /// <param name="targetServerBrandVersion"> Target server brand version. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        /// <param name="lastStorageUpdate"> Last time the storage was updated. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputMigrationLevel"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlOfflineTaskOutputMigrationLevel MigrateMySqlAzureDBForMySqlOfflineTaskOutputMigrationLevel(string id = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, long? durationInSeconds = null, MigrationStatus? status = null, string statusMessage = null, string message = null, string databases = null, string databaseSummary = null, MigrationReportResult migrationReportResult = null, string sourceServerVersion = null, string sourceServerBrandVersion = null, string targetServerVersion = null, string targetServerBrandVersion = null, IEnumerable<ReportableException> exceptionsAndWarnings = null, DateTimeOffset? lastStorageUpdate = null)
        {
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateMySqlAzureDBForMySqlOfflineTaskOutputMigrationLevel(
                id,
                "MigrationLevelOutput",
                serializedAdditionalRawData: null,
                startedOn,
                endedOn,
                durationInSeconds,
                status,
                statusMessage,
                message,
                databases,
                databaseSummary,
                migrationReportResult,
                sourceServerVersion,
                sourceServerBrandVersion,
                targetServerVersion,
                targetServerBrandVersion,
                exceptionsAndWarnings?.ToList(),
                lastStorageUpdate);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputDatabaseLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="databaseName"> Name of the database. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="stage"> Migration stage that this database is in. </param>
        /// <param name="statusMessage"> Status message. </param>
        /// <param name="message"> Migration progress message. </param>
        /// <param name="numberOfObjects"> Number of objects. </param>
        /// <param name="numberOfObjectsCompleted"> Number of successfully completed objects. </param>
        /// <param name="errorCount"> Number of database/object errors. </param>
        /// <param name="errorPrefix"> Wildcard string prefix to use for querying all errors of the item. </param>
        /// <param name="resultPrefix"> Wildcard string prefix to use for querying all sub-tem results of the item. </param>
        /// <param name="exceptionsAndWarnings"> Migration exceptions and warnings. </param>
        /// <param name="lastStorageUpdate"> Last time the storage was updated. </param>
        /// <param name="objectSummary"> Summary of object results in the migration. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputDatabaseLevel"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlOfflineTaskOutputDatabaseLevel MigrateMySqlAzureDBForMySqlOfflineTaskOutputDatabaseLevel(string id = null, string databaseName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, MigrationState? state = null, DatabaseMigrationStage? stage = null, string statusMessage = null, string message = null, long? numberOfObjects = null, long? numberOfObjectsCompleted = null, long? errorCount = null, string errorPrefix = null, string resultPrefix = null, IEnumerable<ReportableException> exceptionsAndWarnings = null, DateTimeOffset? lastStorageUpdate = null, string objectSummary = null)
        {
            exceptionsAndWarnings ??= new List<ReportableException>();

            return new MigrateMySqlAzureDBForMySqlOfflineTaskOutputDatabaseLevel(
                id,
                "DatabaseLevelOutput",
                serializedAdditionalRawData: null,
                databaseName,
                startedOn,
                endedOn,
                state,
                stage,
                statusMessage,
                message,
                numberOfObjects,
                numberOfObjectsCompleted,
                errorCount,
                errorPrefix,
                resultPrefix,
                exceptionsAndWarnings?.ToList(),
                lastStorageUpdate,
                objectSummary);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputTableLevel"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="objectName"> Name of the item. </param>
        /// <param name="startedOn"> Migration start time. </param>
        /// <param name="endedOn"> Migration end time. </param>
        /// <param name="state"> Current state of migration. </param>
        /// <param name="statusMessage"> Status message. </param>
        /// <param name="itemsCount"> Number of items. </param>
        /// <param name="itemsCompletedCount"> Number of successfully completed items. </param>
        /// <param name="errorPrefix"> Wildcard string prefix to use for querying all errors of the item. </param>
        /// <param name="resultPrefix"> Wildcard string prefix to use for querying all sub-tem results of the item. </param>
        /// <param name="lastStorageUpdate"> Last time the storage was updated. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputTableLevel"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlOfflineTaskOutputTableLevel MigrateMySqlAzureDBForMySqlOfflineTaskOutputTableLevel(string id = null, string objectName = null, DateTimeOffset? startedOn = null, DateTimeOffset? endedOn = null, MigrationState? state = null, string statusMessage = null, long? itemsCount = null, long? itemsCompletedCount = null, string errorPrefix = null, string resultPrefix = null, DateTimeOffset? lastStorageUpdate = null)
        {
            return new MigrateMySqlAzureDBForMySqlOfflineTaskOutputTableLevel(
                id,
                "TableLevelOutput",
                serializedAdditionalRawData: null,
                objectName,
                startedOn,
                endedOn,
                state,
                statusMessage,
                itemsCount,
                itemsCompletedCount,
                errorPrefix,
                resultPrefix,
                lastStorageUpdate);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputError"/>. </summary>
        /// <param name="id"> Result identifier. </param>
        /// <param name="error"> Migration error. </param>
        /// <returns> A new <see cref="Models.MigrateMySqlAzureDBForMySqlOfflineTaskOutputError"/> instance for mocking. </returns>
        public static MigrateMySqlAzureDBForMySqlOfflineTaskOutputError MigrateMySqlAzureDBForMySqlOfflineTaskOutputError(string id = null, ReportableException error = null)
        {
            return new MigrateMySqlAzureDBForMySqlOfflineTaskOutputError(id, "ErrorOutput", serializedAdditionalRawData: null, error);
        }
    }
}
