// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataMigration.Models;

namespace Azure.ResourceManager.DataMigration.Samples
{
    public partial class Sample_ServiceProjectTaskResource
    {
        // Tasks_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_TasksGet()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/Tasks_Get.json
            // this example is just showing the usage of "Tasks_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceProjectTaskResource created on azure
            // for more information of creating ServiceProjectTaskResource, please refer to the document of ServiceProjectTaskResource
            string subscriptionId = "fc04246f-04c5-437e-ac5e-206a19e7193f";
            string groupName = "DmsSdkRg";
            string serviceName = "DmsSdkService";
            string projectName = "DmsSdkProject";
            string taskName = "DmsSdkTask";
            ResourceIdentifier serviceProjectTaskResourceId = ServiceProjectTaskResource.CreateResourceIdentifier(subscriptionId, groupName, serviceName, projectName, taskName);
            ServiceProjectTaskResource serviceProjectTask = client.GetServiceProjectTaskResource(serviceProjectTaskResourceId);

            // invoke the operation
            ServiceProjectTaskResource result = await serviceProjectTask.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ProjectTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Delete
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_TasksDelete()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/Tasks_Delete.json
            // this example is just showing the usage of "Tasks_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceProjectTaskResource created on azure
            // for more information of creating ServiceProjectTaskResource, please refer to the document of ServiceProjectTaskResource
            string subscriptionId = "fc04246f-04c5-437e-ac5e-206a19e7193f";
            string groupName = "DmsSdkRg";
            string serviceName = "DmsSdkService";
            string projectName = "DmsSdkProject";
            string taskName = "DmsSdkTask";
            ResourceIdentifier serviceProjectTaskResourceId = ServiceProjectTaskResource.CreateResourceIdentifier(subscriptionId, groupName, serviceName, projectName, taskName);
            ServiceProjectTaskResource serviceProjectTask = client.GetServiceProjectTaskResource(serviceProjectTaskResourceId);

            // invoke the operation
            await serviceProjectTask.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Tasks_Update
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_TasksUpdate()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/Tasks_Update.json
            // this example is just showing the usage of "Tasks_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceProjectTaskResource created on azure
            // for more information of creating ServiceProjectTaskResource, please refer to the document of ServiceProjectTaskResource
            string subscriptionId = "fc04246f-04c5-437e-ac5e-206a19e7193f";
            string groupName = "DmsSdkRg";
            string serviceName = "DmsSdkService";
            string projectName = "DmsSdkProject";
            string taskName = "DmsSdkTask";
            ResourceIdentifier serviceProjectTaskResourceId = ServiceProjectTaskResource.CreateResourceIdentifier(subscriptionId, groupName, serviceName, projectName, taskName);
            ServiceProjectTaskResource serviceProjectTask = client.GetServiceProjectTaskResource(serviceProjectTaskResourceId);

            // invoke the operation
            ProjectTaskData data = new ProjectTaskData()
            {
                Properties = new ConnectToTargetSqlDBTaskProperties()
                {
                    Input = new ConnectToTargetSqlDBTaskInput(new SqlConnectionInfo("ssma-test-server.database.windows.net")
                    {
                        Authentication = AuthenticationType.SqlAuthentication,
                        EncryptConnection = true,
                        TrustServerCertificate = true,
                        UserName = "testuser",
                        Password = "testpassword",
                    }),
                },
            };
            ServiceProjectTaskResource result = await serviceProjectTask.UpdateAsync(data);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ProjectTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Cancel
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Cancel_TasksCancel()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/Tasks_Cancel.json
            // this example is just showing the usage of "Tasks_Cancel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceProjectTaskResource created on azure
            // for more information of creating ServiceProjectTaskResource, please refer to the document of ServiceProjectTaskResource
            string subscriptionId = "fc04246f-04c5-437e-ac5e-206a19e7193f";
            string groupName = "DmsSdkRg";
            string serviceName = "DmsSdkService";
            string projectName = "DmsSdkProject";
            string taskName = "DmsSdkTask";
            ResourceIdentifier serviceProjectTaskResourceId = ServiceProjectTaskResource.CreateResourceIdentifier(subscriptionId, groupName, serviceName, projectName, taskName);
            ServiceProjectTaskResource serviceProjectTask = client.GetServiceProjectTaskResource(serviceProjectTaskResourceId);

            // invoke the operation
            ServiceProjectTaskResource result = await serviceProjectTask.CancelAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            ProjectTaskData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Tasks_Command
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Command_TasksCommand()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/Tasks_Command.json
            // this example is just showing the usage of "Tasks_Command" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ServiceProjectTaskResource created on azure
            // for more information of creating ServiceProjectTaskResource, please refer to the document of ServiceProjectTaskResource
            string subscriptionId = "fc04246f-04c5-437e-ac5e-206a19e7193f";
            string groupName = "DmsSdkRg";
            string serviceName = "DmsSdkService";
            string projectName = "DmsSdkProject";
            string taskName = "DmsSdkTask";
            ResourceIdentifier serviceProjectTaskResourceId = ServiceProjectTaskResource.CreateResourceIdentifier(subscriptionId, groupName, serviceName, projectName, taskName);
            ServiceProjectTaskResource serviceProjectTask = client.GetServiceProjectTaskResource(serviceProjectTaskResourceId);

            // invoke the operation
            CommandProperties commandProperties = new MigrateSyncCompleteCommandProperties()
            {
                Input = new MigrateSyncCompleteCommandInput("TestDatabase"),
            };
            CommandProperties result = await serviceProjectTask.CommandAsync(commandProperties);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
