// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataMigration.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.DataMigration.Samples
{
    public partial class Sample_DatabaseMigrationSqlMICollection
    {
        // Get Sql MI database Migration with the expand parameter.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSqlMIDatabaseMigrationWithTheExpandParameter()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlMiGetDatabaseMigrationExpanded.json
            // this example is just showing the usage of "DatabaseMigrationsSqlMi_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this DatabaseMigrationSqlMIResource
            DatabaseMigrationSqlMICollection collection = resourceGroupResource.GetDatabaseMigrationSqlMIs();

            // invoke the operation
            string managedInstanceName = "managedInstance1";
            string targetDBName = "db1";
            string expand = "MigrationStatusDetails";
            DatabaseMigrationSqlMIResource result = await collection.GetAsync(managedInstanceName, targetDBName, expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseMigrationSqlMIData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Sql MI database Migration with the expand parameter.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetSqlMIDatabaseMigrationWithTheExpandParameter()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlMiGetDatabaseMigrationExpanded.json
            // this example is just showing the usage of "DatabaseMigrationsSqlMi_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this DatabaseMigrationSqlMIResource
            DatabaseMigrationSqlMICollection collection = resourceGroupResource.GetDatabaseMigrationSqlMIs();

            // invoke the operation
            string managedInstanceName = "managedInstance1";
            string targetDBName = "db1";
            string expand = "MigrationStatusDetails";
            bool result = await collection.ExistsAsync(managedInstanceName, targetDBName, expand: expand);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Sql MI database Migration with the expand parameter.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetSqlMIDatabaseMigrationWithTheExpandParameter()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlMiGetDatabaseMigrationExpanded.json
            // this example is just showing the usage of "DatabaseMigrationsSqlMi_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this DatabaseMigrationSqlMIResource
            DatabaseMigrationSqlMICollection collection = resourceGroupResource.GetDatabaseMigrationSqlMIs();

            // invoke the operation
            string managedInstanceName = "managedInstance1";
            string targetDBName = "db1";
            string expand = "MigrationStatusDetails";
            NullableResponse<DatabaseMigrationSqlMIResource> response = await collection.GetIfExistsAsync(managedInstanceName, targetDBName, expand: expand);
            DatabaseMigrationSqlMIResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DatabaseMigrationSqlMIData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Get Sql MI database Migration without the expand parameter.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSqlMIDatabaseMigrationWithoutTheExpandParameter()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlMiGetDatabaseMigration.json
            // this example is just showing the usage of "DatabaseMigrationsSqlMi_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this DatabaseMigrationSqlMIResource
            DatabaseMigrationSqlMICollection collection = resourceGroupResource.GetDatabaseMigrationSqlMIs();

            // invoke the operation
            string managedInstanceName = "managedInstance1";
            string targetDBName = "db1";
            DatabaseMigrationSqlMIResource result = await collection.GetAsync(managedInstanceName, targetDBName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseMigrationSqlMIData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Sql MI database Migration without the expand parameter.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_GetSqlMIDatabaseMigrationWithoutTheExpandParameter()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlMiGetDatabaseMigration.json
            // this example is just showing the usage of "DatabaseMigrationsSqlMi_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this DatabaseMigrationSqlMIResource
            DatabaseMigrationSqlMICollection collection = resourceGroupResource.GetDatabaseMigrationSqlMIs();

            // invoke the operation
            string managedInstanceName = "managedInstance1";
            string targetDBName = "db1";
            bool result = await collection.ExistsAsync(managedInstanceName, targetDBName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Get Sql MI database Migration without the expand parameter.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_GetSqlMIDatabaseMigrationWithoutTheExpandParameter()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlMiGetDatabaseMigration.json
            // this example is just showing the usage of "DatabaseMigrationsSqlMi_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this DatabaseMigrationSqlMIResource
            DatabaseMigrationSqlMICollection collection = resourceGroupResource.GetDatabaseMigrationSqlMIs();

            // invoke the operation
            string managedInstanceName = "managedInstance1";
            string targetDBName = "db1";
            NullableResponse<DatabaseMigrationSqlMIResource> response = await collection.GetIfExistsAsync(managedInstanceName, targetDBName);
            DatabaseMigrationSqlMIResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DatabaseMigrationSqlMIData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create or Update Database Migration resource with Maximum parameters.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateDatabaseMigrationResourceWithMaximumParameters()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlMiCreateOrUpdateDatabaseMigrationMAX.json
            // this example is just showing the usage of "DatabaseMigrationsSqlMi_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this DatabaseMigrationSqlMIResource
            DatabaseMigrationSqlMICollection collection = resourceGroupResource.GetDatabaseMigrationSqlMIs();

            // invoke the operation
            string managedInstanceName = "managedInstance1";
            string targetDBName = "db1";
            DatabaseMigrationSqlMIData data = new DatabaseMigrationSqlMIData()
            {
                Properties = new DatabaseMigrationSqlMIProperties()
                {
                    BackupConfiguration = new BackupConfiguration()
                    {
                        SourceLocation = new SourceLocation()
                        {
                            FileShare = new SqlFileShare()
                            {
                                Path = "C:\\aaa\\bbb\\ccc",
                                Username = "name",
                                Password = "placeholder",
                            },
                        },
                        TargetLocation = new TargetLocation()
                        {
                            StorageAccountResourceId = "account.database.windows.net",
                            AccountKey = "abcd",
                        },
                    },
                    OfflineConfiguration = new OfflineConfiguration()
                    {
                        Offline = true,
                        LastBackupName = "last_backup_file_name",
                    },
                    Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/instance",
                    SourceSqlConnection = new SqlConnectionInformation()
                    {
                        DataSource = "aaa",
                        Authentication = "WindowsAuthentication",
                        UserName = "bbb",
                        Password = "placeholder",
                        EncryptConnection = true,
                        TrustServerCertificate = true,
                    },
                    SourceDatabaseName = "aaa",
                    MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent",
                },
            };
            ArmOperation<DatabaseMigrationSqlMIResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, managedInstanceName, targetDBName, data);
            DatabaseMigrationSqlMIResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseMigrationSqlMIData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Database Migration resource with Minimum parameters.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateOrUpdateDatabaseMigrationResourceWithMinimumParameters()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlMiCreateOrUpdateDatabaseMigrationMIN.json
            // this example is just showing the usage of "DatabaseMigrationsSqlMi_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this DatabaseMigrationSqlMIResource
            DatabaseMigrationSqlMICollection collection = resourceGroupResource.GetDatabaseMigrationSqlMIs();

            // invoke the operation
            string managedInstanceName = "managedInstance1";
            string targetDBName = "db1";
            DatabaseMigrationSqlMIData data = new DatabaseMigrationSqlMIData()
            {
                Properties = new DatabaseMigrationSqlMIProperties()
                {
                    BackupConfiguration = new BackupConfiguration()
                    {
                        SourceLocation = new SourceLocation()
                        {
                            FileShare = new SqlFileShare()
                            {
                                Path = "C:\\aaa\\bbb\\ccc",
                                Username = "name",
                                Password = "placeholder",
                            },
                        },
                        TargetLocation = new TargetLocation()
                        {
                            StorageAccountResourceId = "account.database.windows.net",
                            AccountKey = "abcd",
                        },
                    },
                    Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/managedInstances/instance",
                    SourceSqlConnection = new SqlConnectionInformation()
                    {
                        DataSource = "aaa",
                        Authentication = "WindowsAuthentication",
                        UserName = "bbb",
                        Password = "placeholder",
                        EncryptConnection = true,
                        TrustServerCertificate = true,
                    },
                    SourceDatabaseName = "aaa",
                    MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent",
                },
            };
            ArmOperation<DatabaseMigrationSqlMIResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, managedInstanceName, targetDBName, data);
            DatabaseMigrationSqlMIResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseMigrationSqlMIData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
