// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.DataMigration.Models;

namespace Azure.ResourceManager.DataMigration.Samples
{
    public partial class Sample_DatabaseMigrationSqlDBResource
    {
        // Get Sql DB database Migration with the expand parameter.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSqlDBDatabaseMigrationWithTheExpandParameter()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlDbGetDatabaseMigrationExpanded.json
            // this example is just showing the usage of "DatabaseMigrationsSqlDb_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DatabaseMigrationSqlDBResource created on azure
            // for more information of creating DatabaseMigrationSqlDBResource, please refer to the document of DatabaseMigrationSqlDBResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlDBInstanceName = "sqldbinstance";
            string targetDBName = "db1";
            ResourceIdentifier databaseMigrationSqlDBResourceId = DatabaseMigrationSqlDBResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlDBInstanceName, targetDBName);
            DatabaseMigrationSqlDBResource databaseMigrationSqlDB = client.GetDatabaseMigrationSqlDBResource(databaseMigrationSqlDBResourceId);

            // invoke the operation
            string expand = "MigrationStatusDetails";
            DatabaseMigrationSqlDBResource result = await databaseMigrationSqlDB.GetAsync(expand: expand);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseMigrationSqlDBData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get Sql DB database Migration without the expand parameter.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetSqlDBDatabaseMigrationWithoutTheExpandParameter()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlDbGetDatabaseMigration.json
            // this example is just showing the usage of "DatabaseMigrationsSqlDb_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DatabaseMigrationSqlDBResource created on azure
            // for more information of creating DatabaseMigrationSqlDBResource, please refer to the document of DatabaseMigrationSqlDBResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlDBInstanceName = "sqldbinstance";
            string targetDBName = "db1";
            ResourceIdentifier databaseMigrationSqlDBResourceId = DatabaseMigrationSqlDBResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlDBInstanceName, targetDBName);
            DatabaseMigrationSqlDBResource databaseMigrationSqlDB = client.GetDatabaseMigrationSqlDBResource(databaseMigrationSqlDBResourceId);

            // invoke the operation
            DatabaseMigrationSqlDBResource result = await databaseMigrationSqlDB.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseMigrationSqlDBData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Database Migration resource with Maximum parameters.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateDatabaseMigrationResourceWithMaximumParameters()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlDbCreateOrUpdateDatabaseMigrationMAX.json
            // this example is just showing the usage of "DatabaseMigrationsSqlDb_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DatabaseMigrationSqlDBResource created on azure
            // for more information of creating DatabaseMigrationSqlDBResource, please refer to the document of DatabaseMigrationSqlDBResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlDBInstanceName = "sqldbinstance";
            string targetDBName = "db1";
            ResourceIdentifier databaseMigrationSqlDBResourceId = DatabaseMigrationSqlDBResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlDBInstanceName, targetDBName);
            DatabaseMigrationSqlDBResource databaseMigrationSqlDB = client.GetDatabaseMigrationSqlDBResource(databaseMigrationSqlDBResourceId);

            // invoke the operation
            DatabaseMigrationSqlDBData data = new DatabaseMigrationSqlDBData()
            {
                Properties = new DatabaseMigrationSqlDBProperties()
                {
                    TargetSqlConnection = new SqlConnectionInformation()
                    {
                        DataSource = "sqldbinstance",
                        Authentication = "SqlAuthentication",
                        UserName = "bbb",
                        Password = "placeholder",
                        EncryptConnection = true,
                        TrustServerCertificate = true,
                    },
                    TableList =
{
"[Schema1].[TableName1]","[Schema2].[TableName2]"
},
                    Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance",
                    SourceSqlConnection = new SqlConnectionInformation()
                    {
                        DataSource = "aaa",
                        Authentication = "WindowsAuthentication",
                        UserName = "bbb",
                        Password = "placeholder",
                        EncryptConnection = true,
                        TrustServerCertificate = true,
                    },
                    SourceDatabaseName = "aaa",
                    MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent",
                },
            };
            ArmOperation<DatabaseMigrationSqlDBResource> lro = await databaseMigrationSqlDB.UpdateAsync(WaitUntil.Completed, data);
            DatabaseMigrationSqlDBResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseMigrationSqlDBData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or Update Database Migration resource with Minimum parameters.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateDatabaseMigrationResourceWithMinimumParameters()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlDbCreateOrUpdateDatabaseMigrationMIN.json
            // this example is just showing the usage of "DatabaseMigrationsSqlDb_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DatabaseMigrationSqlDBResource created on azure
            // for more information of creating DatabaseMigrationSqlDBResource, please refer to the document of DatabaseMigrationSqlDBResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlDBInstanceName = "sqldbinstance";
            string targetDBName = "db1";
            ResourceIdentifier databaseMigrationSqlDBResourceId = DatabaseMigrationSqlDBResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlDBInstanceName, targetDBName);
            DatabaseMigrationSqlDBResource databaseMigrationSqlDB = client.GetDatabaseMigrationSqlDBResource(databaseMigrationSqlDBResourceId);

            // invoke the operation
            DatabaseMigrationSqlDBData data = new DatabaseMigrationSqlDBData()
            {
                Properties = new DatabaseMigrationSqlDBProperties()
                {
                    TargetSqlConnection = new SqlConnectionInformation()
                    {
                        DataSource = "sqldbinstance",
                        Authentication = "SqlAuthentication",
                        UserName = "bbb",
                        Password = "placeholder",
                        EncryptConnection = true,
                        TrustServerCertificate = true,
                    },
                    Scope = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.Sql/servers/sqldbinstance",
                    SourceSqlConnection = new SqlConnectionInformation()
                    {
                        DataSource = "aaa",
                        Authentication = "WindowsAuthentication",
                        UserName = "bbb",
                        Password = "placeholder",
                        EncryptConnection = true,
                        TrustServerCertificate = true,
                    },
                    SourceDatabaseName = "aaa",
                    MigrationService = "/subscriptions/00000000-1111-2222-3333-444444444444/resourceGroups/testrg/providers/Microsoft.DataMigration/sqlMigrationServices/testagent",
                },
            };
            ArmOperation<DatabaseMigrationSqlDBResource> lro = await databaseMigrationSqlDB.UpdateAsync(WaitUntil.Completed, data);
            DatabaseMigrationSqlDBResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DatabaseMigrationSqlDBData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete Database Migration resource.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteDatabaseMigrationResource()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlDbDeleteDatabaseMigration.json
            // this example is just showing the usage of "DatabaseMigrationsSqlDb_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DatabaseMigrationSqlDBResource created on azure
            // for more information of creating DatabaseMigrationSqlDBResource, please refer to the document of DatabaseMigrationSqlDBResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlDBInstanceName = "sqldbinstance";
            string targetDBName = "db1";
            ResourceIdentifier databaseMigrationSqlDBResourceId = DatabaseMigrationSqlDBResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlDBInstanceName, targetDBName);
            DatabaseMigrationSqlDBResource databaseMigrationSqlDB = client.GetDatabaseMigrationSqlDBResource(databaseMigrationSqlDBResourceId);

            // invoke the operation
            await databaseMigrationSqlDB.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Stop ongoing migration for the database.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Cancel_StopOngoingMigrationForTheDatabase()
        {
            // Generated from example definition: specification/datamigration/resource-manager/Microsoft.DataMigration/preview/2022-03-30-preview/examples/SqlDbCancelDatabaseMigration.json
            // this example is just showing the usage of "DatabaseMigrationsSqlDb_Cancel" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DatabaseMigrationSqlDBResource created on azure
            // for more information of creating DatabaseMigrationSqlDBResource, please refer to the document of DatabaseMigrationSqlDBResource
            string subscriptionId = "00000000-1111-2222-3333-444444444444";
            string resourceGroupName = "testrg";
            string sqlDBInstanceName = "sqldbinstance";
            string targetDBName = "db1";
            ResourceIdentifier databaseMigrationSqlDBResourceId = DatabaseMigrationSqlDBResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, sqlDBInstanceName, targetDBName);
            DatabaseMigrationSqlDBResource databaseMigrationSqlDB = client.GetDatabaseMigrationSqlDBResource(databaseMigrationSqlDBResourceId);

            // invoke the operation
            MigrationOperationInput input = new MigrationOperationInput()
            {
                MigrationOperationId = Guid.Parse("9a90bb84-e70f-46f7-b0ae-1aef5b3b9f07"),
            };
            await databaseMigrationSqlDB.CancelAsync(WaitUntil.Completed, input);

            Console.WriteLine($"Succeeded");
        }
    }
}
