// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    /// <summary> The encryption configuration used to update a user managed Key Vault key. </summary>
    internal partial class UpdateEncryptionConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="UpdateEncryptionConfig"/>. </summary>
        public UpdateEncryptionConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="UpdateEncryptionConfig"/>. </summary>
        /// <param name="keyVaultMetaInfo"> The updated Key Vault key to use in user managed key rotation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal UpdateEncryptionConfig(UpdateKeyVaultMetaInfo keyVaultMetaInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            KeyVaultMetaInfo = keyVaultMetaInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The updated Key Vault key to use in user managed key rotation. </summary>
        internal UpdateKeyVaultMetaInfo KeyVaultMetaInfo { get; set; }
        /// <summary> The version of the user managed encryption key to update through a key rotation. </summary>
        public string EncryptionKeyVersion
        {
            get => KeyVaultMetaInfo is null ? default : KeyVaultMetaInfo.EncryptionKeyVersion;
            set
            {
                if (KeyVaultMetaInfo is null)
                    KeyVaultMetaInfo = new UpdateKeyVaultMetaInfo();
                KeyVaultMetaInfo.EncryptionKeyVersion = value;
            }
        }
    }
}
