// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    internal static partial class DataLakeStoreTrustedIdProviderStateExtensions
    {
        public static string ToSerialString(this DataLakeStoreTrustedIdProviderState value) => value switch
        {
            DataLakeStoreTrustedIdProviderState.Enabled => "Enabled",
            DataLakeStoreTrustedIdProviderState.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreTrustedIdProviderState value.")
        };

        public static DataLakeStoreTrustedIdProviderState ToDataLakeStoreTrustedIdProviderState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return DataLakeStoreTrustedIdProviderState.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return DataLakeStoreTrustedIdProviderState.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreTrustedIdProviderState value.");
        }
    }
}
