// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    /// <summary> The subscription state. </summary>
    public readonly partial struct DataLakeStoreSubscriptionState : IEquatable<DataLakeStoreSubscriptionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataLakeStoreSubscriptionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataLakeStoreSubscriptionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegisteredValue = "Registered";
        private const string SuspendedValue = "Suspended";
        private const string DeletedValue = "Deleted";
        private const string UnregisteredValue = "Unregistered";
        private const string WarnedValue = "Warned";

        /// <summary> Registered. </summary>
        public static DataLakeStoreSubscriptionState Registered { get; } = new DataLakeStoreSubscriptionState(RegisteredValue);
        /// <summary> Suspended. </summary>
        public static DataLakeStoreSubscriptionState Suspended { get; } = new DataLakeStoreSubscriptionState(SuspendedValue);
        /// <summary> Deleted. </summary>
        public static DataLakeStoreSubscriptionState Deleted { get; } = new DataLakeStoreSubscriptionState(DeletedValue);
        /// <summary> Unregistered. </summary>
        public static DataLakeStoreSubscriptionState Unregistered { get; } = new DataLakeStoreSubscriptionState(UnregisteredValue);
        /// <summary> Warned. </summary>
        public static DataLakeStoreSubscriptionState Warned { get; } = new DataLakeStoreSubscriptionState(WarnedValue);
        /// <summary> Determines if two <see cref="DataLakeStoreSubscriptionState"/> values are the same. </summary>
        public static bool operator ==(DataLakeStoreSubscriptionState left, DataLakeStoreSubscriptionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataLakeStoreSubscriptionState"/> values are not the same. </summary>
        public static bool operator !=(DataLakeStoreSubscriptionState left, DataLakeStoreSubscriptionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataLakeStoreSubscriptionState"/>. </summary>
        public static implicit operator DataLakeStoreSubscriptionState(string value) => new DataLakeStoreSubscriptionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataLakeStoreSubscriptionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataLakeStoreSubscriptionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
