// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    /// <summary> The resource type. Note: This should not be set by the user, as the constant value is Microsoft.DataLakeStore/accounts. </summary>
    public readonly partial struct DataLakeStoreResourceType : IEquatable<DataLakeStoreResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataLakeStoreResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataLakeStoreResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftDataLakeStoreAccountsValue = "Microsoft.DataLakeStore/accounts";

        /// <summary> Microsoft.DataLakeStore/accounts. </summary>
        public static DataLakeStoreResourceType MicrosoftDataLakeStoreAccounts { get; } = new DataLakeStoreResourceType(MicrosoftDataLakeStoreAccountsValue);
        /// <summary> Determines if two <see cref="DataLakeStoreResourceType"/> values are the same. </summary>
        public static bool operator ==(DataLakeStoreResourceType left, DataLakeStoreResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataLakeStoreResourceType"/> values are not the same. </summary>
        public static bool operator !=(DataLakeStoreResourceType left, DataLakeStoreResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataLakeStoreResourceType"/>. </summary>
        public static implicit operator DataLakeStoreResourceType(string value) => new DataLakeStoreResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataLakeStoreResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataLakeStoreResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
