// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    internal static partial class DataLakeStoreFirewallStateExtensions
    {
        public static string ToSerialString(this DataLakeStoreFirewallState value) => value switch
        {
            DataLakeStoreFirewallState.Enabled => "Enabled",
            DataLakeStoreFirewallState.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreFirewallState value.")
        };

        public static DataLakeStoreFirewallState ToDataLakeStoreFirewallState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return DataLakeStoreFirewallState.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return DataLakeStoreFirewallState.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreFirewallState value.");
        }
    }
}
