// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    internal static partial class DataLakeStoreEncryptionStateExtensions
    {
        public static string ToSerialString(this DataLakeStoreEncryptionState value) => value switch
        {
            DataLakeStoreEncryptionState.Enabled => "Enabled",
            DataLakeStoreEncryptionState.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreEncryptionState value.")
        };

        public static DataLakeStoreEncryptionState ToDataLakeStoreEncryptionState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return DataLakeStoreEncryptionState.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return DataLakeStoreEncryptionState.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreEncryptionState value.");
        }
    }
}
