// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    internal static partial class DataLakeStoreEncryptionProvisioningStateExtensions
    {
        public static string ToSerialString(this DataLakeStoreEncryptionProvisioningState value) => value switch
        {
            DataLakeStoreEncryptionProvisioningState.Creating => "Creating",
            DataLakeStoreEncryptionProvisioningState.Succeeded => "Succeeded",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreEncryptionProvisioningState value.")
        };

        public static DataLakeStoreEncryptionProvisioningState ToDataLakeStoreEncryptionProvisioningState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Creating")) return DataLakeStoreEncryptionProvisioningState.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return DataLakeStoreEncryptionProvisioningState.Succeeded;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreEncryptionProvisioningState value.");
        }
    }
}
