// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    internal static partial class DataLakeStoreAccountStatusExtensions
    {
        public static string ToSerialString(this DataLakeStoreAccountStatus value) => value switch
        {
            DataLakeStoreAccountStatus.Failed => "Failed",
            DataLakeStoreAccountStatus.Creating => "Creating",
            DataLakeStoreAccountStatus.Running => "Running",
            DataLakeStoreAccountStatus.Succeeded => "Succeeded",
            DataLakeStoreAccountStatus.Patching => "Patching",
            DataLakeStoreAccountStatus.Suspending => "Suspending",
            DataLakeStoreAccountStatus.Resuming => "Resuming",
            DataLakeStoreAccountStatus.Deleting => "Deleting",
            DataLakeStoreAccountStatus.Deleted => "Deleted",
            DataLakeStoreAccountStatus.Undeleting => "Undeleting",
            DataLakeStoreAccountStatus.Canceled => "Canceled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreAccountStatus value.")
        };

        public static DataLakeStoreAccountStatus ToDataLakeStoreAccountStatus(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return DataLakeStoreAccountStatus.Failed;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Creating")) return DataLakeStoreAccountStatus.Creating;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Running")) return DataLakeStoreAccountStatus.Running;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return DataLakeStoreAccountStatus.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Patching")) return DataLakeStoreAccountStatus.Patching;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Suspending")) return DataLakeStoreAccountStatus.Suspending;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Resuming")) return DataLakeStoreAccountStatus.Resuming;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleting")) return DataLakeStoreAccountStatus.Deleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Deleted")) return DataLakeStoreAccountStatus.Deleted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Undeleting")) return DataLakeStoreAccountStatus.Undeleting;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Canceled")) return DataLakeStoreAccountStatus.Canceled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreAccountStatus value.");
        }
    }
}
