// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    internal static partial class DataLakeStoreAccountStateExtensions
    {
        public static string ToSerialString(this DataLakeStoreAccountState value) => value switch
        {
            DataLakeStoreAccountState.Active => "Active",
            DataLakeStoreAccountState.Suspended => "Suspended",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreAccountState value.")
        };

        public static DataLakeStoreAccountState ToDataLakeStoreAccountState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Active")) return DataLakeStoreAccountState.Active;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Suspended")) return DataLakeStoreAccountState.Suspended;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeStoreAccountState value.");
        }
    }
}
