// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    /// <summary> Data Lake Store account name availability result information. </summary>
    public partial class DataLakeStoreAccountNameAvailabilityResult
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataLakeStoreAccountNameAvailabilityResult"/>. </summary>
        internal DataLakeStoreAccountNameAvailabilityResult()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeStoreAccountNameAvailabilityResult"/>. </summary>
        /// <param name="isNameAvailable"> The Boolean value of true or false to indicate whether the Data Lake Store account name is available or not. </param>
        /// <param name="reason"> The reason why the Data Lake Store account name is not available, if nameAvailable is false. </param>
        /// <param name="message"> The message describing why the Data Lake Store account name is not available, if nameAvailable is false. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataLakeStoreAccountNameAvailabilityResult(bool? isNameAvailable, string reason, string message, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            IsNameAvailable = isNameAvailable;
            Reason = reason;
            Message = message;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The Boolean value of true or false to indicate whether the Data Lake Store account name is available or not. </summary>
        public bool? IsNameAvailable { get; }
        /// <summary> The reason why the Data Lake Store account name is not available, if nameAvailable is false. </summary>
        public string Reason { get; }
        /// <summary> The message describing why the Data Lake Store account name is not available, if nameAvailable is false. </summary>
        public string Message { get; }
    }
}
