// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataLakeStore.Models
{
    /// <summary> The encryption configuration for the account. </summary>
    public partial class DataLakeStoreAccountEncryptionConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataLakeStoreAccountEncryptionConfig"/>. </summary>
        /// <param name="configType"> The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'. </param>
        public DataLakeStoreAccountEncryptionConfig(DataLakeStoreAccountEncryptionConfigType configType)
        {
            ConfigType = configType;
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeStoreAccountEncryptionConfig"/>. </summary>
        /// <param name="configType"> The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'. </param>
        /// <param name="keyVaultMetaInfo"> The Key Vault information for connecting to user managed encryption keys. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataLakeStoreAccountEncryptionConfig(DataLakeStoreAccountEncryptionConfigType configType, DataLakeStoreAccountKeyVaultMetaInfo keyVaultMetaInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ConfigType = configType;
            KeyVaultMetaInfo = keyVaultMetaInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeStoreAccountEncryptionConfig"/> for deserialization. </summary>
        internal DataLakeStoreAccountEncryptionConfig()
        {
        }

        /// <summary> The type of encryption configuration being used. Currently the only supported types are 'UserManaged' and 'ServiceManaged'. </summary>
        public DataLakeStoreAccountEncryptionConfigType ConfigType { get; set; }
        /// <summary> The Key Vault information for connecting to user managed encryption keys. </summary>
        public DataLakeStoreAccountKeyVaultMetaInfo KeyVaultMetaInfo { get; set; }
    }
}
