// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using Azure.Core;

namespace Azure.ResourceManager.DataLakeStore.Mocking
{
    /// <summary> A class to add extension methods to ArmClient. </summary>
    public partial class MockableDataLakeStoreArmClient : ArmResource
    {
        /// <summary> Initializes a new instance of the <see cref="MockableDataLakeStoreArmClient"/> class for mocking. </summary>
        protected MockableDataLakeStoreArmClient()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockableDataLakeStoreArmClient"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockableDataLakeStoreArmClient(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        internal MockableDataLakeStoreArmClient(ArmClient client) : this(client, ResourceIdentifier.Root)
        {
        }

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataLakeStoreAccountResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataLakeStoreAccountResource.CreateResourceIdentifier" /> to create a <see cref="DataLakeStoreAccountResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataLakeStoreAccountResource"/> object. </returns>
        public virtual DataLakeStoreAccountResource GetDataLakeStoreAccountResource(ResourceIdentifier id)
        {
            DataLakeStoreAccountResource.ValidateResourceId(id);
            return new DataLakeStoreAccountResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataLakeStoreFirewallRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataLakeStoreFirewallRuleResource.CreateResourceIdentifier" /> to create a <see cref="DataLakeStoreFirewallRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataLakeStoreFirewallRuleResource"/> object. </returns>
        public virtual DataLakeStoreFirewallRuleResource GetDataLakeStoreFirewallRuleResource(ResourceIdentifier id)
        {
            DataLakeStoreFirewallRuleResource.ValidateResourceId(id);
            return new DataLakeStoreFirewallRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataLakeStoreVirtualNetworkRuleResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataLakeStoreVirtualNetworkRuleResource.CreateResourceIdentifier" /> to create a <see cref="DataLakeStoreVirtualNetworkRuleResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataLakeStoreVirtualNetworkRuleResource"/> object. </returns>
        public virtual DataLakeStoreVirtualNetworkRuleResource GetDataLakeStoreVirtualNetworkRuleResource(ResourceIdentifier id)
        {
            DataLakeStoreVirtualNetworkRuleResource.ValidateResourceId(id);
            return new DataLakeStoreVirtualNetworkRuleResource(Client, id);
        }

        /// <summary>
        /// Gets an object representing a <see cref="DataLakeStoreTrustedIdProviderResource"/> along with the instance operations that can be performed on it but with no data.
        /// You can use <see cref="DataLakeStoreTrustedIdProviderResource.CreateResourceIdentifier" /> to create a <see cref="DataLakeStoreTrustedIdProviderResource"/> <see cref="ResourceIdentifier"/> from its components.
        /// </summary>
        /// <param name="id"> The resource ID of the resource to get. </param>
        /// <returns> Returns a <see cref="DataLakeStoreTrustedIdProviderResource"/> object. </returns>
        public virtual DataLakeStoreTrustedIdProviderResource GetDataLakeStoreTrustedIdProviderResource(ResourceIdentifier id)
        {
            DataLakeStoreTrustedIdProviderResource.ValidateResourceId(id);
            return new DataLakeStoreTrustedIdProviderResource(Client, id);
        }
    }
}
