// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    /// <summary>
    /// The parameters used to update an Azure Storage account while updating a Data Lake Analytics account.
    /// Serialized Name: UpdateStorageAccountWithAccountParameters
    /// </summary>
    public partial class StorageAccountForDataLakeAnalyticsAccountUpdateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="StorageAccountForDataLakeAnalyticsAccountUpdateContent"/>. </summary>
        /// <param name="name">
        /// The unique name of the Azure Storage account to update.
        /// Serialized Name: UpdateStorageAccountWithAccountParameters.name
        /// </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        public StorageAccountForDataLakeAnalyticsAccountUpdateContent(string name)
        {
            Argument.AssertNotNull(name, nameof(name));

            Name = name;
        }

        /// <summary> Initializes a new instance of <see cref="StorageAccountForDataLakeAnalyticsAccountUpdateContent"/>. </summary>
        /// <param name="name">
        /// The unique name of the Azure Storage account to update.
        /// Serialized Name: UpdateStorageAccountWithAccountParameters.name
        /// </param>
        /// <param name="accessKey">
        /// The updated access key associated with this Azure Storage account that will be used to connect to it.
        /// Serialized Name: UpdateStorageAccountWithAccountParameters.properties.accessKey
        /// </param>
        /// <param name="suffix">
        /// The optional suffix for the storage account.
        /// Serialized Name: UpdateStorageAccountWithAccountParameters.properties.suffix
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal StorageAccountForDataLakeAnalyticsAccountUpdateContent(string name, string accessKey, string suffix, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            AccessKey = accessKey;
            Suffix = suffix;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="StorageAccountForDataLakeAnalyticsAccountUpdateContent"/> for deserialization. </summary>
        internal StorageAccountForDataLakeAnalyticsAccountUpdateContent()
        {
        }

        /// <summary>
        /// The unique name of the Azure Storage account to update.
        /// Serialized Name: UpdateStorageAccountWithAccountParameters.name
        /// </summary>
        public string Name { get; }
        /// <summary>
        /// The updated access key associated with this Azure Storage account that will be used to connect to it.
        /// Serialized Name: UpdateStorageAccountWithAccountParameters.properties.accessKey
        /// </summary>
        public string AccessKey { get; set; }
        /// <summary>
        /// The optional suffix for the storage account.
        /// Serialized Name: UpdateStorageAccountWithAccountParameters.properties.suffix
        /// </summary>
        public string Suffix { get; set; }
    }
}
