// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    internal static partial class NestedResourceProvisioningStateExtensions
    {
        public static string ToSerialString(this NestedResourceProvisioningState value) => value switch
        {
            NestedResourceProvisioningState.Succeeded => "Succeeded",
            NestedResourceProvisioningState.Canceled => "Canceled",
            NestedResourceProvisioningState.Failed => "Failed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown NestedResourceProvisioningState value.")
        };

        public static NestedResourceProvisioningState ToNestedResourceProvisioningState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Succeeded")) return NestedResourceProvisioningState.Succeeded;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Canceled")) return NestedResourceProvisioningState.Canceled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return NestedResourceProvisioningState.Failed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown NestedResourceProvisioningState value.");
        }
    }
}
