// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    internal static partial class DataLakeAnalyticsVirtualNetworkRuleStateExtensions
    {
        public static string ToSerialString(this DataLakeAnalyticsVirtualNetworkRuleState value) => value switch
        {
            DataLakeAnalyticsVirtualNetworkRuleState.Active => "Active",
            DataLakeAnalyticsVirtualNetworkRuleState.NetworkSourceDeleted => "NetworkSourceDeleted",
            DataLakeAnalyticsVirtualNetworkRuleState.Failed => "Failed",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsVirtualNetworkRuleState value.")
        };

        public static DataLakeAnalyticsVirtualNetworkRuleState ToDataLakeAnalyticsVirtualNetworkRuleState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Active")) return DataLakeAnalyticsVirtualNetworkRuleState.Active;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "NetworkSourceDeleted")) return DataLakeAnalyticsVirtualNetworkRuleState.NetworkSourceDeleted;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Failed")) return DataLakeAnalyticsVirtualNetworkRuleState.Failed;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsVirtualNetworkRuleState value.");
        }
    }
}
