// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    /// <summary>
    /// The subscription state.
    /// Serialized Name: SubscriptionState
    /// </summary>
    public readonly partial struct DataLakeAnalyticsSubscriptionState : IEquatable<DataLakeAnalyticsSubscriptionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsSubscriptionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataLakeAnalyticsSubscriptionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string RegisteredValue = "Registered";
        private const string SuspendedValue = "Suspended";
        private const string DeletedValue = "Deleted";
        private const string UnregisteredValue = "Unregistered";
        private const string WarnedValue = "Warned";

        /// <summary>
        /// Registered
        /// Serialized Name: SubscriptionState.Registered
        /// </summary>
        public static DataLakeAnalyticsSubscriptionState Registered { get; } = new DataLakeAnalyticsSubscriptionState(RegisteredValue);
        /// <summary>
        /// Suspended
        /// Serialized Name: SubscriptionState.Suspended
        /// </summary>
        public static DataLakeAnalyticsSubscriptionState Suspended { get; } = new DataLakeAnalyticsSubscriptionState(SuspendedValue);
        /// <summary>
        /// Deleted
        /// Serialized Name: SubscriptionState.Deleted
        /// </summary>
        public static DataLakeAnalyticsSubscriptionState Deleted { get; } = new DataLakeAnalyticsSubscriptionState(DeletedValue);
        /// <summary>
        /// Unregistered
        /// Serialized Name: SubscriptionState.Unregistered
        /// </summary>
        public static DataLakeAnalyticsSubscriptionState Unregistered { get; } = new DataLakeAnalyticsSubscriptionState(UnregisteredValue);
        /// <summary>
        /// Warned
        /// Serialized Name: SubscriptionState.Warned
        /// </summary>
        public static DataLakeAnalyticsSubscriptionState Warned { get; } = new DataLakeAnalyticsSubscriptionState(WarnedValue);
        /// <summary> Determines if two <see cref="DataLakeAnalyticsSubscriptionState"/> values are the same. </summary>
        public static bool operator ==(DataLakeAnalyticsSubscriptionState left, DataLakeAnalyticsSubscriptionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataLakeAnalyticsSubscriptionState"/> values are not the same. </summary>
        public static bool operator !=(DataLakeAnalyticsSubscriptionState left, DataLakeAnalyticsSubscriptionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataLakeAnalyticsSubscriptionState"/>. </summary>
        public static implicit operator DataLakeAnalyticsSubscriptionState(string value) => new DataLakeAnalyticsSubscriptionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataLakeAnalyticsSubscriptionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataLakeAnalyticsSubscriptionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
