// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    /// <summary>
    /// The resource type. Note: This should not be set by the user, as the constant value is Microsoft.DataLakeAnalytics/accounts
    /// Serialized Name: CheckNameAvailabilityParametersType
    /// </summary>
    public readonly partial struct DataLakeAnalyticsResourceType : IEquatable<DataLakeAnalyticsResourceType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsResourceType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataLakeAnalyticsResourceType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftDataLakeAnalyticsAccountsValue = "Microsoft.DataLakeAnalytics/accounts";

        /// <summary>
        /// Microsoft.DataLakeAnalytics/accounts
        /// Serialized Name: CheckNameAvailabilityParametersType.Microsoft.DataLakeAnalytics/accounts
        /// </summary>
        public static DataLakeAnalyticsResourceType MicrosoftDataLakeAnalyticsAccounts { get; } = new DataLakeAnalyticsResourceType(MicrosoftDataLakeAnalyticsAccountsValue);
        /// <summary> Determines if two <see cref="DataLakeAnalyticsResourceType"/> values are the same. </summary>
        public static bool operator ==(DataLakeAnalyticsResourceType left, DataLakeAnalyticsResourceType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataLakeAnalyticsResourceType"/> values are not the same. </summary>
        public static bool operator !=(DataLakeAnalyticsResourceType left, DataLakeAnalyticsResourceType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataLakeAnalyticsResourceType"/>. </summary>
        public static implicit operator DataLakeAnalyticsResourceType(string value) => new DataLakeAnalyticsResourceType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataLakeAnalyticsResourceType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataLakeAnalyticsResourceType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
