// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    internal static partial class DataLakeAnalyticsFirewallStateExtensions
    {
        public static string ToSerialString(this DataLakeAnalyticsFirewallState value) => value switch
        {
            DataLakeAnalyticsFirewallState.Enabled => "Enabled",
            DataLakeAnalyticsFirewallState.Disabled => "Disabled",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsFirewallState value.")
        };

        public static DataLakeAnalyticsFirewallState ToDataLakeAnalyticsFirewallState(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Enabled")) return DataLakeAnalyticsFirewallState.Enabled;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Disabled")) return DataLakeAnalyticsFirewallState.Disabled;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown DataLakeAnalyticsFirewallState value.");
        }
    }
}
