// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.DataLakeAnalytics.Models
{
    /// <summary>
    /// The parameters used to create a new compute policy.
    /// Serialized Name: CreateOrUpdateComputePolicyParameters
    /// </summary>
    public partial class DataLakeAnalyticsComputePolicyCreateOrUpdateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsComputePolicyCreateOrUpdateContent"/>. </summary>
        /// <param name="objectId">
        /// The AAD object identifier for the entity to create a policy for.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.objectId
        /// </param>
        /// <param name="objectType">
        /// The type of AAD object the object identifier refers to.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.objectType
        /// </param>
        public DataLakeAnalyticsComputePolicyCreateOrUpdateContent(Guid objectId, AadObjectIdentifierType objectType)
        {
            ObjectId = objectId;
            ObjectType = objectType;
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsComputePolicyCreateOrUpdateContent"/>. </summary>
        /// <param name="objectId">
        /// The AAD object identifier for the entity to create a policy for.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.objectId
        /// </param>
        /// <param name="objectType">
        /// The type of AAD object the object identifier refers to.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.objectType
        /// </param>
        /// <param name="maxDegreeOfParallelismPerJob">
        /// The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.maxDegreeOfParallelismPerJob
        /// </param>
        /// <param name="minPriorityPerJob">
        /// The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.minPriorityPerJob
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataLakeAnalyticsComputePolicyCreateOrUpdateContent(Guid objectId, AadObjectIdentifierType objectType, int? maxDegreeOfParallelismPerJob, int? minPriorityPerJob, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ObjectId = objectId;
            ObjectType = objectType;
            MaxDegreeOfParallelismPerJob = maxDegreeOfParallelismPerJob;
            MinPriorityPerJob = minPriorityPerJob;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="DataLakeAnalyticsComputePolicyCreateOrUpdateContent"/> for deserialization. </summary>
        internal DataLakeAnalyticsComputePolicyCreateOrUpdateContent()
        {
        }

        /// <summary>
        /// The AAD object identifier for the entity to create a policy for.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.objectId
        /// </summary>
        public Guid ObjectId { get; }
        /// <summary>
        /// The type of AAD object the object identifier refers to.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.objectType
        /// </summary>
        public AadObjectIdentifierType ObjectType { get; }
        /// <summary>
        /// The maximum degree of parallelism per job this user can use to submit jobs. This property, the min priority per job property, or both must be passed.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.maxDegreeOfParallelismPerJob
        /// </summary>
        public int? MaxDegreeOfParallelismPerJob { get; set; }
        /// <summary>
        /// The minimum priority per job this user can use to submit jobs. This property, the max degree of parallelism per job property, or both must be passed.
        /// Serialized Name: CreateOrUpdateComputePolicyParameters.properties.minPriorityPerJob
        /// </summary>
        public int? MinPriorityPerJob { get; set; }
    }
}
